#!/usr/bin/perl
###########################################################################
#    WWWThreads  - Interactive Discussion Forum
#    Copyright (C) 1998  Rick Baker rbaker@techline.com
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
###########################################################################
require "wwwthread_variables.pl";

#***********************************************************************
# Get_Input - Grab the input and Parse it
#***********************************************************************

sub get_input{
   
   # Get the input
   if($ENV{'REQUEST_METHOD'} eq "POST"){
      read(STDIN, $input, $ENV{'CONTENT_LENGTH'});
   }
   if($ENV{'REQUEST_METHOD'} eq "GET"){
      $input=$ENV{'QUERY_STRING'};
   }

   # Split the name-value pairs
   @pairs = split(/&/, $input);

   foreach $pair (@pairs) {
      ($name, $value) = split(/=/, $pair);           
   
   # Un-Webify plus signs and %-encoding
   $value =~ tr/+/ /;
   $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
   $value =~ s/<!--(.|\n)*-->//g;
   $value =~ s/\n/<br>/g;
   $FORM{$name} = $value;
   }


}

#***********************************************************************
# Get_Date - Get the Date and Assign it to variables
#***********************************************************************

sub get_date{
   $currtime=time();
   $adjust=$currtime+($adjusttime*3600);
   $fulldate=localtime($adjust);
}

#***********************************************************************
# Send_Header - Send a Header
#***********************************************************************

sub send_header{

print "Content-type: text/html\n\n";
print<<STUFF;

   <HTML>
   <HEAD>
   <TITLE>$title</TITLE>
STUFF
&style_sheet;
print<<STUFF;
   </HEAD>
   <BODY bgcolor=$bodybg>
   <center>
   <a href="$logourl">
   <img src="$imageurl/logo.gif" border=0>
   </a>
STUFF
}

#***********************************************************************
# Index_Header - Send the Index Header
#***********************************************************************

sub index_header{

print "Content-type: text/html\n\n";
print<<STUFF;

   <HTML>
   <HEAD>
   <TITLE>$title</TITLE>
STUFF
&style_sheet;
print<<STUFF;
   </HEAD>
   <BODY bgcolor="$bodybg">

   <TABLE BORDER=0 WIDTH=100%>
   <TR>
      <TD>
      <a href="$logourl">
      <img src="$imageurl/logo.gif" border=0>
      </a>
      </TD><TD VALIGN=bottom>
         <P ALIGN=RIGHT>
STUFF
            &$whichmenu;
print<<STUFF;
            <br clear=all>
            <MAP NAME="map1">
            <AREA SHAPE=RECT COORDS="151,0,248,20" HREF="$cgiurl/wwwthread.cgi?action=showfaq">
            <AREA SHAPE=RECT COORDS="73,0,147,20" HREF="$cgiurl/wwwthread.cgi?action=editinfo">
            <AREA SHAPE=RECT COORDS="0,0,73,20" HREF="$cgiurl/wwwthread.cgi?action=newuser">
         </MAP><IMG USEMAP="#map1" SRC="$imageurl/menu.gif" ALT="Menu"
         WIDTH=249 HEIGHT=21 BORDER=0 ALIGN=bottom>
      </TD></TR>
   </TABLE>

STUFF

}

#***********************************************************************
# Thanks_Header - Send the Thanks Header
#***********************************************************************

sub thanks_header{

print"Content-type: text/html\n\n";
print<<STUFF;
<HTML>
<HEAD>
   <TITLE>$title</TITLE>
<META HTTP-EQUIV="Refresh"  CONTENT="5;
url=$cgiurl/wwwthread.cgi?action=list&board=$board&bnum=$bnum">
STUFF
&style_sheet;
print<<STUFF;
</HEAD>
<BODY bgcolor="$bodybg">

<CENTER><IMG SRC="$imageurl/logo.gif" WIDTH=240 HEIGHT=84 ALIGN=bottom>
</CENTER></P> 

STUFF

}


#***********************************************************************
# admin_thanks - Send the Thanks Header
#***********************************************************************

sub admin_thanks{
print"Content-type: text/html\n\n";

print<<STUFF;
   <HTML>
<HEAD>
   <TITLE>$title</TITLE>
<META HTTP-EQUIV="Refresh"  CONTENT="5; url=wwwthread_admin.cgi">
STUFF
&style_sheet;
print<<STUFF;
</HEAD>
<BODY bgcolor=$bodybg>

<CENTER><IMG SRC="$imageurl/logo.gif" WIDTH=240 HEIGHT=84 ALIGN=bottom>
</CENTER></P> 

STUFF

}


#***********************************************************************
# Admin_Header - Send the Admin Header
#***********************************************************************

sub admin_header{

print "Content-type: text/html\n\n";
print<<STUFF;

   <HTML>
   <HEAD>
   <TITLE>$title</TITLE>
STUFF
&style_sheet;
print<<STUFF;
   </HEAD>
   <BODY bgcolor=$bodybg>

   <TABLE BORDER=0 WIDTH=100%>
   <TR>
      <TD>
      <a href="$logourl">
      <img src="$imageurl/logo.gif" border=0>
      </a>
      </TD><TD VALIGN=bottom>
         <P ALIGN=RIGHT>
STUFF
            &$whichmenu;
print<<STUFF;
      </TD></TR>
   </TABLE>

STUFF

}


#***********************************************************************
# Index_Footer - Send the footer
#***********************************************************************

sub index_footer{

print<<STUFF;

</TABLE><TABLE BORDER=0 WIDTH=100%>
   <TR>
      <TH align=center>
          <font size=-1>
          <a href="$homeurl">$urltitle</a>
          &nbsp;&nbsp;&nbsp;
          &nbsp;&nbsp;&nbsp;
          &nbsp;&nbsp;&nbsp;
          <a href="mailto:$emailaddy">$emailtitle</a>
          </font>
   </TH>
   </TR>
   <TR>
      <TD colspan=3>
         <CENTER><B><FONT
         SIZE="-2">Forums Powered By<br><A
HREF="http://www.screamingweb.com/wwwthreads">WWWThreads
         Version 2.7.1</A></FONT><FONT SIZE="-2"><BR>
         </CENTER>         
      </TD></TR>
</TABLE></P>
</BODY>
</HTML>

STUFF

}

#***********************************************************************
# Style_SHeet
#***********************************************************************

sub style_sheet{

if ($useimage == 1){

print<<STUFF;
<STYLE TYPE="text/css">
BODY   { background-image: url("$imageurl/$backimage");
         color: $textcol;
         font-size: 9pt;
         font-family: Arial, Verdana, Helvetica, helv, sans-serif;
         }

A:link, A:visited, A:active { text-decoration: none }

A:link {color: $linkcol}

A:visited {color: $linkvis}

A:active {color: $linkactive}

P {color: $textcol; 
   font-family: Arial, Verdana, Helvetica, helv, sans-serif;
   font-size: 11pt }

TD {color: $textcol;
   }

TD.dark {
   color: $textcol;
   font-family: Arial, Verdana, Helvetica, helv, sans-serif;
   font-size: 9pt }
TD.light {
   color: $textcol;
   font-family: Arial, Verdana, Helvetica, helv, sans-serif;
   font-size: 9pt }

TD.alt {
   color: $textcol;
   font-family: Arial, Verdana, Helvetica, helv, sans-serif;
   font-size: 9pt }

</STYLE>
STUFF

}else{

print<<STUFF;
<STYLE TYPE="text/css">
BODY   { background: $bodybg;
         color: $textcol;
         font-size: 9pt;
         font-family: Arial, Verdana, Helvetica, helv, sans-serif;
         }

A:link, A:visited, A:active { text-decoration: none }

A:link {color: $linkcol}

A:visited {color: $linkvis}

A:active {color: $linkactive}

P {color: $textcol;
   font-family: Arial, Verdana, Helvetica, helv, sans-serif;
   font-size: 11pt }

TD {color: $textcol;
   }

TD.dark {background: $tddark;
   color: $textcol;
   font-family: Arial, Verdana, Helvetica, helv, sans-serif;
   font-size: 9pt }
TD.light {background: $tdlight;
   color: $textcol;
   font-family: Arial, Verdana, Helvetica, helv, sans-serif;
   font-size: 9pt }

TD.alt {background: $tdalt;
   color: $textcol;
   font-family: Arial, Verdana, Helvetica, helv, sans-serif;
   font-size: 9pt }

</STYLE>
STUFF


}
}

#***********************************************************************
# Back_Button - Give a Back Button to the user
#***********************************************************************

sub back_button{
   print<<'EOF';
   <p align="center">&nbsp;</p>
   <center>
   <script language="LiveScript">
   <!--
      function goHist(a)
   {
      history.go(a)
   }
   //<!-- -->
   </script>

   <form><input type="button" value="Go Back" onclick=goHist(-1)>
   </form>
   </center>
EOF
}

#***********************************************************************
# Not_Done - Make them fill out all required info. 
#***********************************************************************

sub not_done{

   $info="All Required Information is not filled in.";
   &not_right_info;			# Something is not right - Notify
User

}

#***********************************************************************
# Not_Right - Something is wrong - 
#***********************************************************************

sub not_right{

     
      print"<center>\n";

      print"<h2>$info</h2>\n";
      print"</font>";
      print"<p></p>\n";
      print"</center>\n";
         
      &back_button;		# Send a back button to the browser
      &index_footer;		# Send a footer back to the browser
         
      die "$info";			# Die Nicely         
   
}

#***********************************************************************
# Not_Right_info - Something is wrong - 
#***********************************************************************

sub not_right_info{

      &send_header;		# Send the header back to the browser
         
      print"<center>\n";

      print"<h2>$info</h2>\n";
      print"</font>";
      print"<p></p>\n";
      print"</center>\n";
         
      &back_button;		# Send a back button to the browser
      &index_footer;		# Send a footer back to the browser
         
      die "$info";			# Die Nicely         
   
}


sub get_cookie {

    local(@Cstuff) = @_;
    local($cookie,$value);

    if ($ENV{'HTTP_COOKIE'}) {

       foreach (split(/; /,$ENV{'HTTP_COOKIE'})) {
          ($cookie,$value) = split(/=/);

             foreach $char (@Cdec) {
                 $cookie =~ s/$char/$Cdec{$char}/g;
                 $value =~ s/$char/$Cdec{$char}/g;
             }

             $cookie{$cookie} = $value;
         }
     }
}

sub set_cookie {
    local(@cookie) = @_;
    local($cookie,$value,$char);
    while( ($cookie,$value) = @cookie ) {

        foreach $char (@Cenc) {
            $cookie =~ s/$char/$Cenc{$char}/g;
            $value =~ s/$char/$Cenc{$char}/g;
        }
        print 'Set-Cookie: ' . $cookie . '=' . $value . ';';

        if ($Cookie_Exp_Date) {
            print ' expires=' . $Cookie_Exp_Date . ';';
        }

        print "\n";
        shift(@cookie); shift(@cookie);
    }
}

#***********************************************************************
# File locking subs 
#***********************************************************************


sub Lock_File {	
   $LockUse="yes";
   local(*FILE) = @_;	
   local($AdjLeft) = 10;	
   if ($LockUse eq "yes") {
      while ($AdjLeft--) {
         $lockresult = eval("flock(FILE,6)");			
         if ($@) {
            $LockUse = "no";
            last;			
         }			
         if (!$lockresult){
            select(undef,undef,undef,0.1);
         }else {
            last;
         }		
      }	
   }
   if ($AdjLeft >= 0) {		
      return 0;	
   }else {
      return -1;	
   }
}

sub Unlock_File {
   local(*FILE) = @_;	
   if ($UseLocking) {
      flock(FILE,8);	
   }
} 

#***********************************************************************
1;     # Return True Value
#***********************************************************************

#***********************************************************************
# End of Module
#***********************************************************************


