// Pipe.cpp
#define ACE_BUILD_DLL
#include "ace/Log_Msg.h"
#include "ace/SOCK_Acceptor.h"
#include "ace/SOCK_Connector.h"
#include "ace/Pipe.h"

void
ACE_Pipe::dump (void) const
{
  ACE_TRACE ("ACE_Pipe::dump");
  ACE_DEBUG ((LM_DEBUG, ACE_BEGIN_DUMP, this));
  ACE_DEBUG ((LM_DEBUG, "handles_[0] = %d", this->handles_[0]));
  ACE_DEBUG ((LM_DEBUG, "\nhandles_[1] = %d", this->handles_[1]));
  ACE_DEBUG ((LM_DEBUG, "\n"));
  ACE_DEBUG ((LM_DEBUG, ACE_END_DUMP));
}

int
ACE_Pipe::open (void)
{
  ACE_TRACE ("ACE_Pipe::open");
#if defined (ACE_WIN32) || defined (ACE_LACKS_SOCKETPAIR)
  ACE_INET_Addr my_addr;
  ACE_SOCK_Acceptor acceptor;
  ACE_SOCK_Connector connector;
  ACE_SOCK_Stream reader;
  ACE_SOCK_Stream writer;
  int result = 0;

  // Bind listener to any port.
  if (acceptor.open (ACE_Addr::sap_any) == -1)
    result = -1;
  else if (acceptor.get_local_addr (my_addr) == -1)
    result = -1;
  else
    {
      ACE_INET_Addr sv_addr (my_addr.get_port_number (), "localhost");
      
      // Establish a connection within the same process!
      if (connector.connect (writer, sv_addr) == -1)
	result = -1;
      else if (acceptor.accept (reader) == -1)
	{
	  writer.close ();
	  result = -1;
	}
    }
      
  // Close down the acceptor endpoint since we don't need it anymore.
  acceptor.close ();
  if (result == -1)
    return -1;

  this->handles_[0] = reader.get_handle ();
  this->handles_[1] = writer.get_handle ();

  return 0;
#elif defined (ACE_HAS_STREAM_PIPES)
  if (ACE_OS::pipe (this->handles_) == -1)
    ACE_ERROR_RETURN ((LM_ERROR, "%p\n", "pipe"), -1);

  int arg = RMSGN;

  // Enable "msg no discard" mode, which ensures that record
  // boundaries are maintained when messages are sent and received.
  if (ACE_OS::ioctl (this->handles_[0], I_SRDOPT, (void *) arg) == -1
      || ACE_OS::ioctl (this->handles_[1], I_SRDOPT, (void *) arg) == -1)
    ACE_ERROR_RETURN ((LM_ERROR, "%p\n", "ioctl"), -1);
#else
  if (ACE_OS::socketpair (AF_UNIX, SOCK_DGRAM, 0, this->handles_) == -1)
    ACE_ERROR_RETURN ((LM_ERROR, "%p\n", "socketpair"), -1);
#endif /* ACE_WIN32 */
  // Point both the read and write HANDLES to the appropriate socket
  // HANDLEs.

  return 0;
}

int
ACE_Pipe::open (ACE_HANDLE handles[2])
{
  ACE_TRACE ("ACE_Pipe::open");

  if (this->open () == -1)
    return -1;
  else
    {
      handles[0] = this->handles_[0];
      handles[1] = this->handles_[1];
      return 0;
    }
}

// Do nothing...

ACE_Pipe::ACE_Pipe (void)
{
  ACE_TRACE ("ACE_Pipe::ACE_Pipe");

}

ACE_Pipe::ACE_Pipe (ACE_HANDLE handles[2])
{
  ACE_TRACE ("ACE_Pipe::ACE_Pipe");

  if (this->open (handles) == -1)
    ACE_ERROR ((LM_ERROR, "ACE_Pipe::ACE_Pipe"));
}

ACE_Pipe::ACE_Pipe (ACE_HANDLE read, 
		    ACE_HANDLE write)
{
  ACE_TRACE ("ACE_Pipe::ACE_Pipe");
  this->handles_[0] = read;
  this->handles_[1] = write;
}

int
ACE_Pipe::close (void)
{
  ACE_TRACE ("ACE_Pipe::close");

  if (ACE_OS::close (this->handles_[0]) == -1
      || ACE_OS::close (this->handles_[1]) == -1)
    return -1;
  else
    return 0;
}
