#if !defined (ACE_HANDLE_THR_STREAM_C)
#define ACE_HANDLE_THR_STREAM_C

#include "ace/Get_Opt.h"
#include "ace/INET_Addr.h"
#include "Handle_Thr_Stream.h"

#if defined (ACE_HAS_THREADS)

#if !defined (__ACE_INLINE__)
#include "Handle_Thr_Stream.i"
#endif /* __ACE_INLINE__ */

// Shorthand names.
#define SH SVC_HANDLER 
#define PR_AC_1 ACE_PEER_ACCEPTOR_1
#define PR_AC_2 ACE_PEER_ACCEPTOR_2
#define PR_ST_1 ACE_PEER_STREAM_1
#define PR_ST_2 ACE_PEER_STREAM_2

template <class SH, PR_AC_1> 
Handle_Thr_Stream<SH, PR_AC_2>::~Handle_Thr_Stream (void)
{
}

template <class SH, PR_AC_1> 
Handle_Thr_Stream<SH, PR_AC_2>::Handle_Thr_Stream (void)
#if defined (ACE_HAS_THREADS)
  : thr_flags_ (THR_DETACHED | THR_NEW_LWP)
#else
  : thr_flags_ (0)
#endif /* ACE_HAS_THREADS */
{
}

template <class SH, PR_AC_1> int 
Handle_Thr_Stream<SH, PR_AC_2>::info (char **strp, 
				      size_t length) const
{
  char buf[BUFSIZ];
  ACE_INET_Addr sa;

  if (this->acceptor ().get_local_addr (sa) == -1)
    return -1;

  ACE_OS::sprintf (buf, "%d/%s %s", sa.get_port_number (), "tcp",
	     "# tests threaded remote stream\n");

  if (*strp == 0 && (*strp = ACE_OS::strdup (buf)) == 0)
    return -1;
  else
    ACE_OS::strncpy (*strp, buf, length);
  return ACE_OS::strlen (buf);
}

template <class SH, PR_AC_1> int
Handle_Thr_Stream<SH, PR_AC_2>::init (int argc, char *argv[])
{
  ACE_INET_Addr local_addr (inherited::DEFAULT_PORT_);
  int n_threads = ACE_DEFAULT_THREADS;

  ACE_Get_Opt get_opt (argc, argv, "p:t:", 0);

  for (int c; (c = get_opt ()) != -1; )
    {
      switch (c)
	{
	case 'p': 
	  local_addr.set (ACE_OS::atoi (get_opt.optarg));
	  break;
	case 't':
	  n_threads = ACE_OS::atoi (get_opt.optarg);
	  break;
	default:
	  break;
	}
    }

  // Initialize the threading strategy.
  if (this->thr_strategy_.open (&this->thr_mgr_, 
				this->thr_flags_, 
				n_threads) == -1)
    ACE_ERROR_RETURN ((LM_ERROR, "%p\n", "open"), -1);

  // Initialize the Acceptor base class, passing in the desired
  // concurrency strategy.
  else if (this->open (local_addr, ACE_Service_Config::reactor (),
		       0, 0, &this->thr_strategy_) == -1)
    ACE_ERROR_RETURN ((LM_ERROR, "%p\n", "open"), -1);
  else
    return 0;
}

template <class SH, PR_AC_1> int 
Handle_Thr_Stream<SH, PR_AC_2>::fini (void)
{
  return ACE_Service_Config::reactor ()->remove_handler 
    (this, ACE_Event_Handler::READ_MASK);
}

template <PR_ST_1>
CLI_Stream<PR_ST_2>::CLI_Stream (ACE_Thread_Manager *thr_mgr)
  : inherited (thr_mgr)
{
}

template <PR_ST_1> int
CLI_Stream<PR_ST_2>::close (u_long)
{
  ACE_DEBUG ((LM_DEBUG, "(%t) client stream object closing down\n"));
  this->peer ().close ();
      
  /* Must be allocated dynamically! */
  delete this;
  return 0;
}

template <PR_ST_1> int
CLI_Stream<PR_ST_2>::open (void *)
{
  ACE_INET_Addr sa;

  ACE_DEBUG ((LM_DEBUG, "(%t) client handle = %d\n", 
	      this->peer ().get_handle ()));

  if (this->peer ().get_remote_addr (sa) == -1)
    return -1;

  ACE_DEBUG ((LM_DEBUG, "(%t) accepted at port %d\n", 
	     sa.get_port_number ()));
  return 0;
}

template <PR_ST_1> int
CLI_Stream<PR_ST_2>::svc (void)
{
  char buf[BUFSIZ];
  char login_name[L_cuserid];
  int bytes;

  ACE_OS::puts ("----------------------------------------");

  while ((bytes = this->peer ().recv (buf, sizeof buf)) > 0)
    ACE_OS::write (ACE_STDOUT, buf, bytes);

  ACE_OS::puts ("----------------------------------------");
  ACE_OS::fflush (stdout);

  long t = ACE_OS::time (0L);
  ACE_OS::cuserid (login_name);
  ACE_OS::sprintf (buf, "user %s %s", login_name, ACE_OS::ctime (&t));

  if (this->peer ().send_n (buf, ACE_OS::strlen (buf) + 1) == -1)
    return -1;

  ACE_DEBUG ((LM_DEBUG, "(%t) sent reply %s", buf));
  return 0;
}

#undef SH
#undef PR_AC_1
#undef PR_AC_2
#undef PR_ST_1
#undef PR_ST_2

//----------------------------------------

#if defined (ACE_HAS_TLI)
#include "ace/TLI_Stream.h"
#include "ace/TLI_Acceptor.h"
#define THR_STREAM ACE_TLI_STREAM 
#define THR_ACCEPTOR ACE_TLI_ACCEPTOR 
#else
#include "ace/SOCK_Stream.h"
#include "ace/SOCK_Acceptor.h"
#define THR_STREAM ACE_SOCK_STREAM 
#define THR_ACCEPTOR ACE_SOCK_ACCEPTOR 
#endif /* ACE_HAS_TLI */
#include "ace/INET_Addr.h"

typedef CLI_Stream <THR_STREAM> CLI_STREAM;
typedef Handle_Thr_Stream<CLI_STREAM, THR_ACCEPTOR> HANDLE_THR_STREAM;

/* Static class variables */

u_short HANDLE_THR_STREAM::DEFAULT_PORT_ = ACE_DEFAULT_THR_PORT;

/* Service object */
HANDLE_THR_STREAM remote_thr_stream;
ACE_Service_Object_Type rts (&remote_thr_stream, "Remote_Thr_Stream");

#if defined (ACE_TEMPLATES_REQUIRE_SPECIALIZATION)
template class CLI_Stream<THR_STREAM>;
template class Handle_Thr_Stream<CLI_Stream<THR_STREAM>, THR_ACCEPTOR>;
#endif /* ACE_TEMPLATES_REQUIRE_SPECIALIZATION */

#endif /* ACE_HAS_THREADS */
#endif /* ACE_HANDLE_THR_STREAM_C */
