# Irix 6.2 with SGI C++

# This suppresses common compiler warnings which appear in the 
# ACE code but should not matter.  The warnings can be turned on
# again by removing the -woff clause in the CPPFLAGS definition.
#
# I (Gonzalo Diethelm <gonzo@ing.puc.cl>) also turned off warning 85
# from the linker; otherwise there are a lot of warnings about symbols
# in the pthread library overriding symbols in the C library (which is
# OK), and added libpthread.so to the link phase.

CC             = cc
CXX            = CC
DLD            = $(CXX)
CPPFLAGS       += -ptused -prelink +pp -D_SGI_MP_SOURCE -woff 3203,3209,3161,3262,3665
LDFLAGS        += -rpath "$(WRAPPER_ROOT)/ace" -Wl,-woff,85
LIBS           += -lpthread
PIC            = -KPIC
AR             = ar
ARFLAGS	       = r
RANLIB	       = echo
SOFLAGS	       = -shared $(CPPFLAGS) -all
SOBUILD	       = $(COMPILE.cc) $(PIC) -o $(VSHDIR)$*.o $<; \
                 $(SOLINK.cc) -o $@ $(LDFLAGS) $(VSHDIR)$*.o
