// Copyright (C) 1999-2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// 
// As a special exception to the GNU General Public License, permission is 
// granted for additional uses of the text contained in its release 
// of APE.
// 
// The exception is that, if you link the APE library with other files
// to produce an executable, this does not by itself cause the
// resulting executable to be covered by the GNU General Public License.
// Your use of that executable is in no way restricted on account of
// linking the APE library code into it.
//
// This exception does not however invalidate any other reasons why
// the executable file might be covered by the GNU General Public License.
//
// This exception applies only to the code released under the 
// name APE.  If you copy code from other releases into a copy of
// APE, as the General Public License permits, the exception does
// not apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
// 
// If you write modifications of your own for APE, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice.  


#include <APE/thread.h>
#include <APE/socket.h>

class myTCPSocket : public TCPSocket
{
protected:
	bool OnAccept(InetHostAddress &ia, short port);

public:
	myTCPSocket(InetAddress &ia);
};

class myTCPSession : public Semaphore, public TCPSession
{
private:
	void Run(void);

public:
	myTCPSession(TCPSocket &server);
	static int count;
};

myTCPSocket::myTCPSocket(InetAddress &ia) : TCPSocket(ia, 4096) {};

bool myTCPSocket::OnAccept(InetHostAddress &ia, short port)
{
	cout << "accepting from: " << ia.getHostname() << ":" << port << endl;;
	return true;
}

int myTCPSession::count = 0;

myTCPSession::myTCPSession(TCPSocket &server) :
Semaphore(0), TCPSession((Semaphore *)this, server)
{
	cout << "creating session client object" << endl;
	++count;
	unsetf(ios::binary);
}

void myTCPSession::Run(void)
{
	InetAddress addr = getLocal();
	*tcp() << "welcome to " << addr.getHostname() << " from socket " << so << endl;
	*tcp() << "called from thread " << count << endl;
	Sleep(20000);
	*tcp() << "ending session" << endl;
}

int main()
{
	myTCPSession *tcp;
	InetAddress addr;
	addr = "255.255.255.255";
	cout << "testing addr: " << addr.getHostname() << ":" << 4096 << endl;
	addr = "127.0.0.1";
	cout << "binding for: " << addr.getHostname() << ":" << 4096 << endl;

	try
	{
		myTCPSocket server(addr);

		while(server.isPending(30000))
		{
			tcp = new myTCPSession(server);
			yield();
			if(tcp->isActive())
				tcp->Start();
			else
				delete tcp;
		}
	}
	catch(Socket *socket)
	{
		short port;
		int err = socket->getErrorNumber();
		InetAddress saddr = (InetAddress)socket->getPeer(&port);
		cerr << "socket error " << saddr.getHostname() << ":" << port << " = " << err << endl; 
		if(err == SOCKET_BINDING_FAILED)
		{
			cerr << "bind failed; port busy" << endl;
			exit(-1);
		}
		else
			cerr << "client socket failed" << endl;
	}
	cout << "timeout after 30 seconds inactivity, exiting" << endl;
}

