// Copyright (C) 1999-2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
// 
// As a special exception to the GNU General Public License, permission is 
// granted for additional uses of the text contained in its release 
// of Common C++.
// 
// The exception is that, if you link the Common C++ library with other
// files to produce an executable, this does not by itself cause the
// resulting executable to be covered by the GNU General Public License.
// Your use of that executable is in no way restricted on account of
// linking the Common C++ library code into it.
// 
// This exception does not however invalidate any other reasons why
// the executable file might be covered by the GNU General Public License.
// 
// This exception applies only to the code released under the 
// name Common C++.  If you copy code from other releases into a copy of
// Common C++, as the General Public License permits, the exception does
// not apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
// 
// If you write modifications of your own for Common C++, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice.  

#ifndef	__CCXX_SLOG_H__
#define	__CCXX_SLOG_H__

#ifndef	__CCXX_THREAD_H__
#include <cc++/thread.h>
#else
#ifdef	__CCXX_NAMESPACE_H__
#include <cc++/macros.h>
#endif
#endif

#include <strstream.h>

typedef enum
{
	SLOG_SECURITY,
	SLOG_AUDIT,
	SLOG_DAEMON,
	SLOG_USER,
	SLOG_DEFAULT
}	slog_class_t;

typedef enum
{
	SLOG_EMERGENCY = 1,
	SLOG_ALERT,
	SLOG_CRITICAL,
	SLOG_ERROR,
	SLOG_WARNING,
	SLOG_NOTICE,
	SLOG_INFO,
	SLOG_DEBUG
}	slog_level_t;

/**
 * The slog class is used to stream messages to the system
 * logging fascility.  A default "slog" object is used to avoid
 * confusion with the native syslog fascility and to imply
 * a logical relationship to the C++ clog().
 * 
 * The key difference is that the "slog" object sends it's output to the
 * system logging daemon (typically syslogd) rather than through stderr.
 * "slog" can be streamed with the << operator just like "clog".  "slog" can
 * also accept arguments to specify logging severity level, etc.
 * 
 * @author David Sugar <dyfet@ostel.com>
 * @short system logging fascility class.
 */
class Slog : public streambuf, public ostream
{
private:
	int priority;
	slog_level_t  _level;
	bool _enable;

public:
	Slog();
	~Slog();
	int overflow(int c);
	void close(void);
	void open(const char *ident, slog_class_t grp = SLOG_USER);
	Slog &operator()(const char *ident, slog_class_t grp = SLOG_USER, 
			 slog_level_t level = SLOG_ERROR);	
	Slog &operator()(slog_level_t level, slog_class_t = SLOG_DEFAULT);
	Slog &operator()(void);	

	inline void level(slog_level_t enable)
		{_level = enable;};
};

extern Slog	slog;

#ifdef	__CCXX_NAMESPACE_H__
#undef	__CCXX_NAMESPACE_H__
#include <cc++/namespace.h>
#endif

#endif

/** EMACS **
 * Local variables:
 * mode: c++
 * c-basic-offset: 8
 * End:
 */
