// Copyright (C) 1999 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include <APE/config.h>
#include "misc.h"

unsigned short getRTShort(unsigned char *data)
{
	return data[0] * 0x100 + data[1];
}

void setRTShort(unsigned char *data, unsigned short value)
{
	data[0] = value / 256;
	data[1] = value % 256;
}


unsigned long getRTLong(unsigned char *data)
{
	return getRTShort(data) * 0x10000 + getRTShort(data + 2);
}

void setRTLong(unsigned char *data, unsigned long value)
{
	setRTShort(data, (unsigned short)(value / 0x10000));
	setRTShort(data + 2, (unsigned short)(value % 0x10000));
}
