/* backnet.h
   Author: Marko Meyer
   Date:  10.02.1995 (creation)
   Time-stamp: <96/01/27 14:45:31 mme>

   Headerfile for whole Backnet-Implementation.
   Holds all initial data and definitions for supported datatypes.


   This file belongs to the Library BACKNET.
   It is Copyright (C) 1995 Marko Meyer.
   Please read the files README, doc/LICENSE and doc/DISCLAIMER.
   If you miss one of these files, please contact me:

   Email: mme@pub.th-zwickau.de
   Ordinary Mail:  Marko Meyer
                   Teichstrasse 27
				   D-08289 Schneeberg
				   Germany
				   
   History:

   95/10/31 -- Heiko Schellhorn  __BORLANDC__ -- Environment 
   95/11/13 -- Ralf Schmidt (marked with 'rsc951113')

*/

#ifndef _BACKNET_
#define _BACKNET_

#define ELEMTYPE double

#include <dosbug.h>
#include <net_errs.h>

#include <errno.h>
#include <math.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#ifdef __BORLANDC__ 
#include <dos.h>  /* ;-] */
#include <time.h>
#define is_open is_open()
#else
#include <unistd.h>
#include <sys/time.h>
#endif /* __BORLANDC__ */


#ifdef __cplusplus   /* When using C++ only ... */
#include <fstream.h>
#include <iostream.h>

/* When using the Array Manager instead of the List Manager. */
#ifdef _WITH_ARRAY_  
#include <arrman-t.h>
#define C_List C_Array
#else
#include __LISTMAN__
#endif /* _WITH_ARRAY_ */
#endif /* __cplusplus */

#ifdef _DEBUG_ON_
#define DBG(x) x
#else
/*rsc 96/01/28: inserted the following line*/
#undef DBG(x) 
#define DBG(x) 
#endif


#define VERSION_NR "0.2"     /*Version-Nr,*/
#define NAME_ID "BACKNET"    /*Name of the application*/

#define INIT_FROM_GWI 0    /*initialize from GWI-file*/
#define INIT_GV_0_1 1      /*initialize with GV[0,1]*/
#define INIT_GV_N_P 2      /*initialize with GV[-1,1]*/
#define INIT_0 3           /*initialize with zero*/
#define INIT_1 4           /*initialize with one*/

#define ACTN_LEARN 0x0001       /*learn the net*/
#define ACTN_RECAL 0x0002       /*recall the net*/
#define ACTN_ALLSC 0x0010		/*allow self coupling (Autoass. only!)*/
#define ACTN_DENSC 0x0020		/*deny self coupling (Autoass. only!)*/

#define LDPAT_MST 1        /*load pattern from MST-file*/
#define LDPAT_LRN 2        /*load pattern from LRN-file*/

#define USE_BIAS 1         /*use BIAS in every Layer*/
#define NO_BIAS 0          /*do not use BIAS at all*/

#define CALC_NO_DERIV 0    /*do not calculate the derivation*/
#define CALC_DERIV 1       /*calculate the derivation*/

#define SelfBackCuppling_Allowed 1 /* rsc951113 -- two lines */
#define SelfBackCuppling_Denied 0

#define MST_EXTENSION ".mst"  /*extension for patternfiles*/
#define LRN_EXTENSION ".lrn"  /*extension for learnpatternfiles*/
#define GWI_EXTENSION ".gwi"  /*extension for weightfiles*/
#define ERR_EXTENSION ".err"  /*extension for errorfiles*/
#define OUT_EXTENSION ".out"  /*extension for outputfiles*/
#define GWB_EXTENSION ".gwb"  /*extension for weightbackups*/

#define LINELENGTH 80       /* The length of an input line in a file. */

struct S_Fermi_Param
{
	float f_Minimum;       /*minimum of fermi-function*/
	float f_Maximum;       /*maximum of fermi-function*/
	float f_Theta;         /*gradient of fermi-function*/
	float f_Sigma;         /*threshold of fermi-function*/
};

struct S_Neuro_Param
{
	int i_Neuro_Nr;        /*number of neuron*/
	int i_Weights;         /*number of list holding weights*/
	int i_WeightCnt;	   /*number of weights to hold (w/ BIAS)*/
    int i_UseBias;         /*does neuron use bias weight!?*/
};

struct S_Layer_Param
{
	int i_Layer_Nr;              /*number of layer*/
	int i_Neuro_Cnt;             /*number of neurons contained in layer*/
	int i_Input_List;            /*number of list with stored input data*/
 	int i_Help_Input_List;       /*number of the list with neurons 
 								   output data*/ /* rsc951113 */
	int i_Output_List;           /*number of list with stored output data*/
	int i_Error_List;            /*number of list with stored error data*/
	int i_Last_Error_List;       /*number of list of last layer with it's
								   stored error data*/
	float f_Learn_Rate;           /*learning rate*/
};

struct S_NNet_Param               /* rsc 95/11/13 -- this struct */
{
	int i_SelfBackCuppling;
	int i_Minimum;
};


char *Return_ErrorMsg(int i_Error);


#endif /*_BACKNET_*/

