/* layer.h 
   
   Realizes functionality of a neural-network layer.

   Author: Marko Meyer
   Date:   29.03.1995 (creation)
           03.06.1995 (last modification)

   This file belongs to the library BACKNET.
   It is Copyright (C) 1995 Marko Meyer.
   Please read the files README, doc/LICENSE and doc/DISCLAIMER.
   If you miss one of these files, please contact me:

   Email: mme@pub.th-zwickau.de
   Ordinary Mail: Marko Meyer
                  Teichstrasse 27
				  D-08289 Schneeberg
				  F.R.G.

*/

#ifndef _LAYER_
#define _LAYER_

#include <backnet.h>
#include <neuron.h>

class C_Layer
{
  protected:
	S_Fermi_Param *S_FermiData;
	S_Layer_Param S_LayerData /*struct with layer-data*/;
	C_List<ELEMTYPE> *C_ListMan  /*pointer to ListManager<ELEMTYPE>*/;
	C_List<C_Neuron*> *C_NeuStor  /*pointer to Neuro-Storage*/;
	int i_NeuList /*Number of the Neuron-List in Neuro-Storage*/;	
	int inCount;
	int i_Bias;

	/*for maintenance*/ 

  	/*creates list i_Count elems long, each filled with Cont*/
	virtual int Create_List(int i_Count,ELEMTYPE Cont);

    /*destroys list i_Numb*/
	virtual int Destroy_List(int i_Numb); 

	/*initializes all the neurons*/
	virtual int Init_Neurons(int i_Number,int i_BiasQuest,
							 int inCount,ifstream *I_GWI_File);
	
	/*destroys all the neurons using information stored in layerdata*/
	virtual int Destroy_Neurons();
	

  public:
	
	C_Layer(C_List<ELEMTYPE> *C_NetLists,/*pointer to ListManager<ELEMTYPE>*/
			int i_NeuCnt,                /*number of neurons in curr. layer*/
			C_Layer *C_LastLay,          /*pointer to previous layer*/
			int i_InpList,               /*pointer to inputlist if firstlay*/
			float f_LearnRate,           /*learning rate*/
			int i_BiasQuest);             /*using BIAS or not*/
	int Init(S_Fermi_Param *S_Fermi_Data, /*pointer to struct with Fermi-data*/
			int i_InitMode,              /*init-mode for neurons*/
			ifstream *I_GWI_File);         /*file with stored weights*/
	virtual int Action(int i_action_nr)   /*recalls or learns*/;
	virtual int Save(ofstream *O_GWI_Save);   /*file with saved old weights*/
	virtual ~C_Layer();
	
	/*for handing layerparameter data to anyone*/
	virtual S_Layer_Param *hand_lay_data();

	
};



#endif /*_LAYER_ */

