/* layer_aa.h 
   
   Realizes functionality of a neural-network layer.

   Author: Ralf Schmidt
   Date:   29.03.1995 (creation)
   Time-stamp: <96/01/21 20:28:53 rsc> (last modification)

   This file belongs to the library BACKNET.
   It is Copyright (C) 1995 Ralf Schmidt.
   Please read the files README, doc/LICENSE and doc/DISCLAIMER.
   If you miss one of these files, please contact me:

   Email: rsc@informatik.th-zwickau.de
   Ordinary Mail: Ralf Schmidt
                  Neuplanitzer Strasse 41
				  D-08062
				  F.R.G.

   Email: mme@pub.th-zwickau.de
   Ordinary Mail: Marko Meyer, Teichstrasse 27, D-08289 Schneeberg, Germany

   Changes: 
   
   95/12/08 -- Marko Meyer: changed header of C_Layer_aa::C_Layer_aa(...)
*/

#ifndef _LAYER_aa
#define _LAYER_aa

#include <backnet.h>
#include __RS_N_AA__
#include <layer.h>

class C_Layer_aa:public C_Layer
{
  protected:
	S_NNet_Param *S_NNet;
	
	C_List<C_Neuron_aa*> *C_Neu_aaStor  /*pointer to Neuro-Storage*/;
	
	int SelfBackCuppling;     /*SelfBackCuppling allowed or not?*/          
	

	/*for maintenance*/ 

  	/*creates list i_Count elems long, each filled with Cont*/
	virtual int Create_List(int i_Count,ELEMTYPE Cont);

    /*destroys list i_Numb*/
	virtual int Destroy_List(int i_Numb); 

	/*initializes all the neurons*/
	virtual int Init_Neurons(int i_Number,int i_BiasQuest,
							 int inCount,ifstream *I_GWI_File);
	
	/*destroys all the neurons using information stored in layerdata*/
	virtual int Destroy_Neurons();
	
		

  public:
	
	C_Layer_aa(S_NNet_Param *S_NNetData, /*pointer to struct with
										   NNet-Data*/
			   C_List<ELEMTYPE> *C_NetLists, /*pointer to 
											  ListManager<ELEMTYPE>*/
			   int i_NeuCnt,                /*number of neurons in curr. layer*/
			   int i_InpList,               /*pointer to inputlist if firstlay*/
			float f_LearnRate           /*learning rate*/
			   );
	
	int Init(int i_InitMode,              /*init-mode for neurons*/
			 ifstream *I_GWI_File);         /*file with stored weights*/
	virtual int Action(int i_action_nr);   /*recalls or learns*/;
		
	virtual int Save(ofstream *O_GWI_Save);   /*file with saved old weights*/
	virtual ~C_Layer_aa();
	
	/*for handing layerparameter data to anyone*/
	virtual S_Layer_Param *hand_lay_data();

	
};



#endif /*_LAYER_ */

