/* listman-t.h

   List-Manager with Templates.

   Author: Marko Meyer
   Time-stamp: <96/01/16 14:14:54 mme>

   This file belongs to the library BACKNET.
   It is Copyright (C) 1995 Marko Meyer.
   Please read the files README, doc/LICENSE and doc/DISCLAIMER.
   If you miss one of these files, please contact me:

   Email: mme@pub.th-zwickau.de
   Ordinary Mail: Marko Meyer
                  Teichstrasse 27
				  D-08289 Schneeberg
				  F.R.G.


*/

#include __LIST_ER__
#include <new.h>

#ifdef _DEBUG_ON_
#define DBG(x) x
#else
#define DBG(x)  
#endif

#define MAXLISTS 10000

template <class X> struct S_ListElem
{
   S_ListElem<X> *next,*previous;	
                       /*pointers to next and previous element.*/
   X content;				/*content of listelement*/
};


template <class X> class C_List
{
	int i_ListCount;         /*number of lists*/
	S_ListElem<X>* AS_FirstElem[MAXLISTS];	/*pointers to listheads*/
	int ai_ElemCount[MAXLISTS];	   /*number of elements stored in list.*/
	
	public:


C_List()
{
	i_ListCount=0;
	for(int i=0;i<MAXLISTS;i++)
	{
		ai_ElemCount[i]=0;
	    AS_FirstElem[i]=NULL;
	}
}

/* We need a new create. The old one did create a list by creating one
   Element with a given content and appending it to a free listnode.
   The new one will only mark a listnode as taken by writing -1 to
   ai_ElemCount[listnode] or create the amount of Elements specified.
   mme - 09/02 1995. */

int
ncreate(int amount, int *i_Error)
{
	int listnr,i;
	
	*i_Error=NO_ERROR;
	if((i_ListCount < (MAXLISTS - 1)))
	{
		for(listnr=1 ; (listnr < (MAXLISTS - 1) && 
						(lexist(listnr) == LIST_EXISTS)); listnr++);
		i_ListCount++;
		ai_ElemCount[listnr] = -1; /* Mark as taken. */

		if(amount > 0)
		{
			/* We use append to append the amount of Elements. */
			for(i = 1;(i <= amount)&&(*i_Error == NO_ERROR); i++)
				*i_Error = append(listnr,0);
		}
		if(*i_Error == NO_ERROR) return listnr;
		else 
		{
			destroy(listnr);
			return 0;
		}
	}
	else *i_Error=ERR_OVERFL_LIST;
	return 0;
}

						

int create(X continp,int *i_Error)
{
	S_ListElem<X> *Element;
	int listnr;

	*i_Error=NO_ERROR;
	if((i_ListCount<(MAXLISTS-1)))
	{
	 	for(listnr=1;(listnr<MAXLISTS-1)&&lexist(listnr)==LIST_EXISTS;
			listnr++);	
		if((Element=(S_ListElem<X>*)new(S_ListElem<X>))) 
		{
			Element->previous=NULL;
			Element->next=NULL;
			Element->content=continp;
		
			i_ListCount++;
			AS_FirstElem[listnr]=Element;
			ai_ElemCount[listnr]++;
			
			return listnr;	
		}
		else *i_Error=ERR_MEMORY_LIST;
		
	}
	else *i_Error=ERR_OVERFL_LIST;
	return 0;
	
}

int lexist(int listnr)
{
	if(((ai_ElemCount[listnr]!=0)/*&&(AS_FirstElem[listnr])*/))
		return LIST_EXISTS;
	/* I commented this, because it seems to be okay, when we only check
	   ai_ElemCount[], because this is set properly when things change.
	   Did this because -1 as ai_ElemCount[listnr] shows that the list is
	   taken, though no Element is appended yet. mme - 09/02 1995 */
	else return NO_LIST;
}

int eexist(int listnr,int elemnr)
{
	if(((lexist(listnr)==LIST_EXISTS)
	   &&(ai_ElemCount[listnr]>=elemnr))) return ELEM_EXISTS;
	else return NO_ELEM;
}

int read(int listnr,int elemnr,X* content)
{
  S_ListElem<X> *Element;
  int i=0;
  
  if((eexist(listnr,elemnr)==ELEM_EXISTS))
  {
    Element=AS_FirstElem[listnr];
  	for(i=1;i<elemnr;Element=Element->next,i++);
  	*content=Element->content;
  	return NO_ERROR;
  }
  else return ERR_NOELEM_LIST;
}

int write(int listnr,int elemnr,X continp)
{
	S_ListElem<X> *Element;
	int i=0;
	
	if((eexist(listnr,elemnr)==ELEM_EXISTS))
	{
		Element=AS_FirstElem[listnr];
		for(i=1;i<elemnr;Element=Element->next,i++);
		Element->content=continp;
		return NO_ERROR;
	}
	else return ERR_NOELEM_LIST;
}

int append(int listnr,X continp)
{
	S_ListElem<X> *Element1,*Element2;
	
	if((lexist(listnr)==LIST_EXISTS))
	{
		/* We have to check if we only set the list taken and no Element
		   is present in this list.  mme - 09/02 1995*/

		if(ai_ElemCount[listnr] == -1)
		{
			/* Okay, that's the case!! */
			if((Element1 = (S_ListElem<X>*) new (S_ListElem<X>))
			   != NULL)
			{
				Element1->previous = NULL;
				Element1->next = NULL;
				Element1->content = continp;
				AS_FirstElem[listnr] = Element1;
				ai_ElemCount[listnr] = 1;
			}
			else return ERR_MEMORY_LIST;
		}
		else
		{
			/* Otherwise there's still an Element to append after. */

			if((Element2=(S_ListElem<X>*)new(S_ListElem<X>)))
			{
				for(Element1=AS_FirstElem[listnr];Element1->next!=NULL;
					Element1=Element1->next);
				Element2->previous=Element1;
				Element2->next=NULL;
				Element2->content=continp;
				
				Element1->next=Element2;
				
				ai_ElemCount[listnr]++;
				return NO_ERROR;
			}
			else return ERR_MEMORY_LIST;
		}
	}
	else return ERR_NOELEM_LIST;
	return NO_ERROR;
}

int insert(int listnr,int before_elem,X continp)
{
	S_ListElem<X> *Element1,*Element2,*Element3;
	int i=0;
	
	if((lexist(listnr)==LIST_EXISTS))
	{
		if(((before_elem<=ai_ElemCount[listnr])&&(ai_ElemCount[listnr]>0)))
		{
			if((Element2=(S_ListElem<X>*)new(S_ListElem<X>)))
			{
				Element3=AS_FirstElem[listnr];
				for(i=1;i<before_elem;Element3=Element3->next,i++);
				Element1=Element3->previous;
				
				Element1->next=Element2;	
				Element2->previous=Element1;
				Element2->next=Element3;
				Element3->previous=Element2;

				Element2->content=continp;
			
				ai_ElemCount[listnr]++;
				return NO_ERROR;
			}
			else return ERR_MEMORY_LIST;
		}
		else return ERR_NOELEM_LIST;
	}
	else return ERR_NOELEM_LIST;
}

int del(int listnr,int elemnr)
{
	S_ListElem<X> *Element=NULL;
	int i=0;

	i=0;
	if((eexist(listnr,elemnr)==ELEM_EXISTS))
	{
		Element=AS_FirstElem[listnr];
		for(i=1;(i<elemnr)&&(Element);Element=Element->next,i++);
		if(!Element)
			return ERR_NOELEM_LIST;
		if((Element->next)) Element->next->previous=Element->previous;
		if((Element->previous)) Element->previous->next=Element->next;
		delete Element;
		ai_ElemCount[listnr]--;
		if(!ai_ElemCount[listnr]) destroy(listnr);
		return NO_ERROR;
	}
	else return ERR_NOELEM_LIST;
}

int destroy(int listnr)
{
  int i=0;
  int i_Error;
  
  i_Error=NO_ERROR;
  if(ai_ElemCount[listnr] == -1)
  {
	  /* The list was taken, no Element present. We just set back
		 the values. mme - 09/02 1995. */
	  
	  ai_ElemCount[listnr] = 0;
	  i_ListCount--;
	  return NO_ERROR;
  }

  if(((ai_ElemCount[listnr] > 0) && AS_FirstElem[listnr] ))
  {
	  for(i=ai_ElemCount[listnr];(i>=1)&&(i_Error==NO_ERROR);
		  i_Error=del(listnr,i--)) ;

	  AS_FirstElem[listnr]=NULL;
	  ai_ElemCount[listnr]=0;
	  i_ListCount--;
  }
  else i_Error=ERR_LNOTEX_LIST;
  
  return i_Error;
}

~C_List()
{
  int i=0;
	if((i_ListCount>0)) for(i=1;i<=i_ListCount;destroy(i++));
}

};


/* Due to some new preferences I changed the ListManager slightly on
   September 2 1995. mme. */
