/* netbacknet.h
   Author: Marko Meyer
   Date:  23.08.1995 (creation)
   Time-stamp: <96/01/12 14:03:41 mme>

   Headerfile for whole Backnet-Implementation.
   
   Definitions and datatypes for distributed use of Backnet.

   This file belongs to the Library BACKNET.
   It is Copyright (C) 1995, 1996 Marko Meyer.
   Please read the files README, doc/LICENSE and doc/DISCLAIMER.
   If you miss one of these files, please contact me:

   Email: mme@pub.th-zwickau.de
   Ordinary Mail:  Marko Meyer
                   Teichstrasse 27
				   D-08289 Schneeberg
				   Germany

   History:
   
   95/08/23 -- Marko Meyer: Developed this one.

   95/11/12 -- Marko Meyer: Changed some structure definitions for more
               generosity even in structure-field-names.
			   Included function header of recv_req(int sock), which is
			   not longer a function of the neuron_server.

   95/11/18 -- Marko Meyer: included header and variables of some 
               semaphore operations.
			   
   95/11/21 -- Marko Meyer: included another header for set_up_tcp
               [look into back_connect_1.cc for details]

   95/11/26 -- Marko Meyer: included struct Buf_Info [from array_serv...3.cc]
               changed char *recv_req(int) to Buf_Info *recv_req(int)

   95/12/03 -- Marko Meyer: included set_up_udp(char*, short) -- header
                            changed send_-- und recv_ -- headers.

   95/12/10 -- Marko Meyer: included header for key_t get_key(unsigned int)
   95/12/12 -- Marko Meyer: included conditionally compiled union semun-type
   95/12/17 -- Marko Meyer: changed header of get_key(unsigned).
   95/12/21 -- Marko Meyer: included bstruct in Buffer_Info.
   95/12/22 -- Marko Meyer: DVLEN is new length of DataVector in RDSt.
                            MAXREQEL and DVLEN settable from outside.

   95/12/24 -- Marko Meyer: Took back setability of MAXREQEL and DVLEN from
                            outside. This would make it much easier to
							change, while these values are important for
							the cooperation of two independently compileable
							things. So it is very important to leave them
							equal. If we must change the code to change the
							values possibly we are much more aware of this
							things. Added a message as well.

   96/01/06 -- Marko Meyer: Added function headers for back_ntoh(...) and
                            back_hton(...) -- see sh_send_rcv.cc.

   96/01/11 -- Marko Meyer: Changed some headers for new timeouting.
   
   96/01/12 -- Marko Meyer: Included a macro for timeouting.
*/

#ifndef _NETBACKNET_H
#define _NETBACKNET_H

#include <backnet.h>

#include <netdb.h>
#include <signal.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>


#include <arpa/inet.h>

#include <netinet/in.h>

#include <sys/ipc.h>
#include <sys/sem.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/wait.h>

#define SETTIMEOUT(x,y,z) (x).tv_sec=(y); (x).tv_usec = (z) 

#ifdef _WITHOUT_B_
#define bzero(a,b) (memset((a),(b),0))
#endif

#ifdef _WITHOUT_SEMUN_
union semun
{
	int val;
	struct semid_ds *buf;
	ushort *array;
};
#endif

/* Never change this values without making sure, that this is changed for
   _all_ clients/servers as well!! If these values are different throughout 
   the server and the clients, nobody will really know what happens to your 
   data. --mme*/
 
#define MAXREQEL 10
#define DVLEN 20

/* We will probably never need this, since we have back_connect_1.cc -mme 
#define SERV_TCP_PORT   6005
#define SERV_HOST_ADR   "127.0.0.1"
*/
/* I just realized, that on Linux MSG_WAITALL is undefined!
   Maybe on other systems its otherwise. Until further notice I handle
   MSG_WAITALL in the undefined case as 0. -mme*/

#ifndef MSG_WAITALL
#define MSG_WAITALL 0
#endif

typedef unsigned short int buf_t;

struct Buffer_Info
{
	int size;
	key_t key;
	buf_t bstruct;
	char *address;
};
	
#define NO_BUF    0x0000
#define HAS_RS    0x0001
#define HAS_RDST  0x0010
#define HAS_NIST  0x0100
#define HAS_AS    0x1000

/* Neuron Information Struct. I don't call it NIS, because that can cause
   trouble ;-). I call it NISt. 
   It replaces and extends the S_Neuron_Param data structure given in
   backnet.h. */

struct NISt
{
	/* The pre- and surname.*/

	int Magic;             /* The magic key: 0xF1. */

	int i_NeuronID;        /* The position of the Neuron within the Net.*/
	                       /* This is the reference parameter! */
	int i_NeuronLID;       /* The position of the Neuron within the Layer.*/
	int i_NIStList;        /* The ListID of the NISt-List of the Network
							  the Neuron is applied to. Should be set to
							  0, if this is the first request of the current
							  Network. Then there is a valid value returned. */

	/* The lists. */

	int i_WeightID;        /* ID of WeightList. */
	int i_WeightCnt;       /* Number of Weights held. (w/ BIAS!!)*/
	int i_InputCnt;        /* Number of Inputs to get. */
	int i_PrErrLID;        /* ID of Previous Error List. */

	/* The modes. */

	int i_InitMode;        /* Initialisation mode of Weights. */
	int i_LearnMode;       /* A mode for learning. */
	int i_FuncMode;        /* The function set to use. */
	int i_UseBias;

	/* The parameters. */
	
	char Net_Input[DVLEN];     
	char Activ_Value[DVLEN];
	char Output_Value[DVLEN];
	char Output_Deriv[DVLEN];   /* useless?? */
	
	/* Additionals. */
	
	char LearnRate[DVLEN];    /* The Learning Rate. */
	char Descript[DVLEN];     /* An arbitrary string. */
};


/* Request Struct. Otherwise referred as to RS. 
   Holds informations used when making an request via IPC. 
   
   RSID is a unique identifier of the Request-Struct. If there are
   RDSt's attached to the RS, this identifier is used to logically connect
   the RDSt's to a RS.

   The NeuronID is the index for seeking in the NISt List of the Neuron
   Server. It should be correct to guarantee sufficient work.

   The AttNIStList field is the number of the NIStList attached to the
   with NeuronID addressed Neuron. If ReqID is REQ_INITN, it might be zero
   to force the server to use a new NIStList, especially when a completely
   new Network (or Layer) first accesses the NeuronServer. Later on this 
   field is used to choose the List, where action is taken on. 
   When AttNIStList is zero and the ReqID is unequal to REQ_INITN, then 
   an error is signaled to the sending process.

   The RSFollow and NIStFollow fields describe the kind of data following
   the RS. NIStFollow should only be FLW_YES when ReqID is REQ_INITN. 
   If both fields are set to FLW_YES, the NISt preceedes the RDSt's.

   [some changes as of 95/12/24 --mme:]

   Since a RS is not longer connected to a Neuron Request, we had to find
   some more general descriptions for the fields inside. 
   Here it comes:

   Magic is still magic.
   The ReqID is still a Request ID as described below.
   The RSID is a 'unique' identifier of the RS and the applied data.
      Unique here refers to a distinct address [IP, port] of a client,
	  which sends us the data. If there are sent multiple RS's with the
	  same RSID from the same client, it is assumed that the client didn't
	  receive our data, so we have to do something.

   The now called ObjectID [former NeuronID] is an ID of an Object being
   used for satisfying the request. Instead of a real 'object' [ as it may
   be for the Neuron Server ] it can contain a number or anything else
   useful for performing some action. Per example, for the Array Server this
   field only says, how many array-fields are made at a REQ_INITA.

   The now called AttList [former AttNIStList] is an ID of a List [or Array],
   action is performed on. It can be as well a list [array] of NISts as a
   list [array] of frobs, foos or bars. Each of the servers making use of
   this will have their own interpretation of the list ID in this field.

   RSFollow contains a number of RDSts following this struct.

   StFollow has been renamed but is still used as NIStFollow.*/

#define AttNIStList AttList
#define NeuronID ObjectID
#define NIStFollow StFollow

struct RS
{
	/* The requested function. */
	int Magic;             /* The magic key: 0xF2. */
 
	int RSID;              /* The ID of the Request Structure. */
	int ReqID;             /* The ID of the requested function. */

	/* The Request - Informations. */
	int ObjectID;          /* The ID of the Object for request processing */
	int AttList;           /* The attached List. */

	int RSFollow;          /* RDSt's will follow if not FLW_NO. 
							The amount of following RS' is specified herein.*/
	int StFollow;          /* Info-Structs will follow if FLW_YES. */
};


/* The Request Data Struct. I really would like to call it RDS, but this
   again may cause trouble ;-]. 

   It contains the information added to the Request. There may be more than
   one RDSt's attached to one RS. Then the RSSID-field is non-zero. The 
   incoming RDSt's are ordered by increasing RSSID-fields. If the current
   RDSt is followed by another RDSt, the RSFollow-field is set to YES.
   
   DVSize contains the amount of Data stored in the DataVector (number of
   last used field in DataVector plus one). If the 
   DataVector is completely used, it must be equal to MAXREQEL. The Data is
   ordered from DataVector[0] to increasing indexes. 

   [some changes as of 95/12/24 --mme:]

   RSFollow is not longer a binary field of two values FLW_YES and FLW_NO.
   Instead there's a number of following RDSt's applied to RSFollow.
   RSSID is (other than previously expressed above) ordered increasingly.*/

struct RDSt
{
	int Magic;            /* The magic key: 0xF4. */
	
	int RSID;
	int RSSID;            /* The Sub-ID of the Request Structure. */
	int RSFollow;          /* Completeness of Request Data. */
	
	int DVSize;            /* Used Elements of DataVector. */
	char DataVector[MAXREQEL][DVLEN];  /* The Data Vector. */
};

/* The Answer Struct AS.

   It contains the ReqID of the request, the answer applies to. 
   Furthermore the RSID of the RS, the answer is applied to, is contained.
   
   The Error field is set to NO_ERROR or the Error occured during receiving
   or processing the request.
   
   The RSFollow field is similar to the same field in the RDSt, it is set to
   YES, when some RDSt's are attached to the AS.

   The NIStFollow field is similar to the RSFollow field although it is set
   to YES, when a NISt is attached to the AS. Sometimes (in case of an
   ReqID == REQ_INITN) a NISt is returned containing the Data of the inited
   Neuron.

   There shall be no case when RSFollow and NIStFollow are both set to YES.

   [some minor changes as of 95/12/24 --mme:]
   
   The Error field not longer contains only Error-Information. If the server
   is the Array Server p.e. it contains either a positive value which applies
   to a array number (when REQ_INITA), a NO_ERROR or a negative value 
   which is a negated Error-Value.
*/

struct AS
{
	int Magic;             /* The magic key: 0xF8. */
	
	int RSID;
	int ReqID;
	int Error;
	
	int RSFollow;
	int NIStFollow;
};


/* Magic keys: */

#define MAG_NISt   0xF1
#define MAG_RS     0xF2
#define MAG_RDSt   0xF4
#define MAG_AS     0xF8
#define MAG_STab   0xFF


/* Possible Requests: */

/* General and for Neuron Server: */

#define REQ_EMERG  0      /* Emergency Request. */
#define REQ_INITN  1      /* Request Initialize Neuron */
#define REQ_LEARN  2      /* Request Learn Neuron */
#define REQ_RECAL  3      /* Request Recall Neuron */
#define REQ_SAVEW  4      /* Request Save Weights of Neuron */
#define REQ_DSTRY  5      /* Request Destroy Neuron */

/* for Array Server: */

#define REQ_INITA  1      /* Initialize one Array. */
#define REQ_STORE  2      /* Store into one Array. */
#define REQ_QUERY  4      /* Read from one Array. */
#define REQ_DESTR  5      /* Destroy one Array. */

/* Values for RSFollow: */

#define FLW_NO     0      /* No further {Request} Structs follow. */

/* Values for i_FuncMode: */

#define FUN_UNDEF  0      /* No function specified. */
#define FUN_FERMI  1      /* Use the Fermi Function Set. */

/* Values for i_LearnMode: */

#define LRN_UNDEF  0      /* No LearnMode specified. */
#define LRN_BACKP  1      /* Backpropagation Mode specified. */

/* Values for i_InitMode: refer to include/backnet.h! */

/* Values for receive-data. */

#define RCV_RS   ((signed)sizeof(RS))
#define RCV_RDSt ((signed)sizeof(RDSt))
#define RCV_AS   ((signed)sizeof(AS))
#define RCV_NISt ((signed)sizeof(NISt))

#define MAX_RCV_REQ (RCV_RS + RCV_NISt + 10*RCV_RDSt)

#define AS_INDIV 0
#define AS_EMERG 1

/* Some headers from functions in back_connect_1.cc -mme */

int set_up_tcp(char *host_addr, char *serv_name, short port);
int set_up_tcp(sockaddr_in *for_addr);
int set_up_udp(char *serv_name, short port);

int send_emerg(int sd, int ASType, AS *EmAS);
int Displ_RS(RS *This_RS);
RS *Get_RS(int sd, struct timeval *timeout);
int Displ_NISt(NISt *This_NISt);
NISt *Get_NISt(int sd, struct timeval *timeout);
int Displ_RDSt(RDSt *This_RDSt);
RDSt *Get_RDSt(int sd, struct timeval *timeout);
int Displ_AS(AS *This_AS);
AS *Get_AS(int sd, struct timeval *timeout);

int back_ntoh(struct NISt *NI);
int back_ntoh(struct RS *R);
int back_ntoh(struct RDSt *RD);
int back_ntoh(struct AS *A);

int back_hton(struct NISt *NI);
int back_hton(struct RS *R);
int back_hton(struct RDSt *RD);
int back_hton(struct AS *A);

int send_(int sd, char *sndbuf, int buflen, unsigned int flags, 
		  sockaddr_in *addr, int len);
int send_(int sd, NISt *NI, unsigned int flags, sockaddr_in *addr, int len);
int send_(int sd, RDSt *RD, unsigned int flags, sockaddr_in *addr, int len);
int send_(int sd, RS *R, unsigned int flags, sockaddr_in *addr, int len);
int send_(int sd, AS *A, unsigned int flags, sockaddr_in *addr, int len);

int recv_sel(int sockd, char *buf, int count, unsigned int flags, 
			 sockaddr_in *addr, int *len, struct timeval *timeout);
int recv_(int sd, char *rcvbuf, int buflen, unsigned int flags, 
		  sockaddr_in *addr, int *len);
int recv_(int sd, NISt *NI, unsigned int flags, sockaddr_in *addr, int *len,
		  struct timeval *timeout);
int recv_(int sd, RDSt *RD, unsigned int flags, sockaddr_in *addr, int *len,
		  struct timeval *timeout);
int recv_(int sd, RS *R, unsigned int flags, sockaddr_in *addr, int *len,
		  struct timeval *timeout);
int recv_(int sd, AS *A, unsigned int flags, sockaddr_in *addr, int *len,
		  struct timeval *timeout);

Buffer_Info *recv_req(int sock, sockaddr_in *addr, int *len);

int create_sem(key_t *sem_key);
int open_sem(int semid, key_t sem_key);
int remove_sem(int semid);
int wakeup_sem(int semid);
int down_sem(int semid);

key_t get_key(unsigned int seed = 0);
#endif /*_NETBACKNET_H*/
