/* neuron.h
   Headerfile for functions implemented in a single neuron, being presented as
   an object in C++. 

   Author: Marko Meyer
   Date: 10.02.1995 (creation)
         22.07.1995 (last modification)

   This file belongs to the library BACKNET.
   It is Copyright (C) 1995 Marko Meyer.
   Please read the files README, doc/LICENSE and doc/DISCLAIMER.
   If you miss one of these files, please contact me:

   Email: mme@pub.th-zwickau.de
   Ordinary Mail: Marko Meyer
                  Teichstrasse 27
				  D-08289 Schneeberg
				  F.R.G.

   Particular copyrights/code comments:

     - unsigned int getseed() was suggested by Heiko Schellhorn
	   (hsc@pub.th-zwickau.de), for compatibility between Borland C++ - 
	   Compilers and UNIX - C++ - Compilers. Thanks!

*/

#ifndef _NEURON_
#define _NEURON_

#include <backnet.h>

unsigned int getseed(); /* suggested by hsc */

class C_Neuron
{
  protected:
	S_Neuro_Param *S_Neuron;      /*pointer to struct with neuro-information*/
	S_Layer_Param *S_Layer;       /*pointer to struct with layer-information*/
	S_Fermi_Param *S_Fermi;       /*pointer to struct with fermi-information*/
	C_List<ELEMTYPE> *C_ListMan;  /*pointer to ListManager*/
	ELEMTYPE Entrance;            /*entrance-value for calculation*/
	ELEMTYPE Activity;            /*activity-value for calculation*/
	ELEMTYPE Exit;                /*exit-value after calculation*/
	ELEMTYPE ExitDerv;            /*derivative exit-value*/

	int i_NetID;               /*ID of Neuron in the NNet*/
	int i_InpCount;            /* Input Count of Neuron */

	virtual int calc_effective_input();      /*calculates effective input*/
    virtual int calc_activity_value();          /*calculates activity*/
    virtual int calc_output_value(int i_Derivation); 
	                              /*calculates output or it's derivation*/
	virtual int modify_weights();         /*modifies weights*/
	virtual int distribute_error();
	                       /*distributes the error to the previous layer*/

	/*some functions for maintenance:*/
	virtual int Init_GWI(ifstream *I_GWI_File);  /*initializes from GWI-File*/
	int Init_(ELEMTYPE value);      /*initializes with constant value*/
	int Init_GV(ELEMTYPE Min,ELEMTYPE Max);
	                                     /*initialize with GV[Min,Max]*/
	virtual int Create_Wgt_List(int i_Count,ELEMTYPE Cont);
   		/*creates weighlist i_Count elems long, each filled with Cont*/
	virtual int Destroy_Wgt_List();  
                             /*destroys weightlist using Neuron information*/
	
	virtual int Load_GWI(ifstream *I_GWI_File);
                                    /*loads Weights from a file to the list*/
	virtual int Save_GWI(ofstream *O_GWI_Save);
	                                /*saves Weights from a list to the save*/


  public:
	C_Neuron(S_Layer_Param *S_LayerData, /*pointer to struct with layer-data*/
			 C_List<ELEMTYPE> *C_NetLists,  /*pointer to ListManager*/
			 int i_NeuNetID,             /*position of neuron within net*/
			 int i_NeuLayID,             /*position of neuton within layer*/
			 int i_InputCount,           /*number of inputs*/
			 int i_BiasQuest);            /*using BIAS or not*/

	int Init(S_Fermi_Param *S_FermiData, /*pointer to struct with fermi-data*/
			 int i_InitMode,             /*number of initmode*/
			 ifstream *I_GWI_File);        /*file with weights stored*/
	virtual int Recall();                /*Recall-function of neuron*/
	virtual int Learn();                 /*Learn-function of neuron*/
	virtual int Save(ofstream *O_GWI_Save);  /*file with saved old weights*/
	virtual ~C_Neuron();
};	


#endif /*_NEURON_*/
