/* nnet.h
   
   Headerfile: Neural Network as class.

   Author: Marko Meyer
   Date:   13.05.1995 (creation)
   Time-stamp: <95/12/17 11:05:15 rsc> 

   This file belongs to the library BACKNET.
   It is Copyright (C) 1995 Marko Meyer.
   Please read the files README, doc/LICENSE and doc/DISCLAIMER.
   If you miss one of these files, please contact me:

   Email: mme@pub.th-zwickau.de
   Ordinary Mail: Marko Meyer
                  Teichstrasse 27
				  D-08289 Schneeberg
				  Germany

   Changes:
   
   95/12/08 -- Marko Meyer: Changed old Take_Layer(...) to
               virtual int Take_Layer(int) 
	
   95/12/09 -- Marko Meyer: included virtual int save();
*/

#ifndef _NEURAL_NET_
#define _NEURAL_NET_

#include <backnet.h>
#include <layer.h>

#ifdef LAYERTYPE
#undef LAYERTYPE
#endif

#define LAYERTYPE C_Layer

class C_NNet
{
  protected:
	S_Fermi_Param  *S_FermiD /*Fermi Data*/;
	C_List<C_Layer*> *C_LayStor  /*Store for Layers.*/;
	C_List<ELEMTYPE> *C_NetLists  /*Weightstore.*/;

	C_Layer *C_AktLayer /* One that is actually loaded. */;

	int i_LayList    /*This is the list in C_LayStore, where data lays.*/;
	int i_LastLayer  /*This is the very last layer.*/;
	int i_LernOutList /*The list for the wanted output.*/;
	int i_InList     /*The list for the input.*/;
	int i_OutList    /*The list for the real output.*/;
	int i_LastErrList /*The list with the last errors.*/;
	int i_NeuronCnt  /* The amount of Neurons in the whole NNet.*/;
	int i_InputNeu   /* Amount of Neurons in the input-Layer.*/;
	int i_OutputNeu  /* Amount of Neurons in the output-Layer.*/;
	int i_Bias;

	/*---rsc: 95/12/17 ---*/
	int i_Kind_Of_Action;
	
	float f_LearnRate;
	char *s_Net_GWI  /*The GWI-Filename.*/;
	ifstream I_GWI_File /*The GWI-File itself!*/;
	ifstream I_MST_File /*The MST-File itself!*/;
	ifstream I_LRN_File /*The LRN-File itself!*/;
	ofstream O_OUT_File /*The OUT-File itself!*/;
	ofstream O_ERR_File /*The ERR-File itself!*/;
	ofstream O_GWI_Save /*The File for saving Weights.*/;

	/*maintenance:*/

	virtual int Learn(char *s_Name,int *i_Steps,int i_MST);
	virtual int Recall(char *s_Name,int i_MST);

	virtual int learn();
	virtual int recal();

	virtual int Create_Lists();
	virtual int Open_GWI(char *s_Name);
	virtual int Init_Layers(C_List<C_Layer*> *C_LStore,int *i_ArNeuCnt,
					float f_LearnRate,int i_InitMode,int i_Bias);
	virtual int Open_MST(char *s_Name,int *i_MST);
	virtual int Open_LRN(char *s_Name,int *i_LRN);
	virtual int Open_ERR(char *s_Name);
	virtual int Open_OUT(char *s_Name,int i_MST);
	virtual int Randomize_Patterns(int *i_PatArr,int i_MST);
	virtual int Load_Pattern(int i_Where,int i_Num);
	virtual int Detect_Error();
	virtual int Write_OUT();
	virtual int save();
	virtual int Take_Layer(int i_Num);
	
  public:
	
	C_NNet(int i_LayerCnt  /*Amount of layers.*/,
		   float f_LearnRate  /*Learning Rate.*/,
		   int i_Bias /*Should BIAS be used?*/,
		   char *s_GWIName  /*Filename for GWI-file.*/);

	int Init(int *i_ArNeuCnt  /*Array with amount of neurons/layer.*/,
			 S_Fermi_Param *S_FermiData /*Struct with FermiData.*/,
			 int i_InitMode  /*InitMode for neurons.*/);

	virtual int Action(int i_Action /*Determines, what action.*/,
			   char *s_Name /*Prename of files.*/,
			   int *i_Steps /*If i_Action==ACTN_LEARN number of learning
							  steps, otherwise unused.*/);
	virtual int Save();
	virtual ~C_NNet();

};
#endif /*_NEURAL_NET_*/






