/* nnet_aa.h
   
   Headerfile: Neural Network as class.

   Author: Ralf Schmidt
   Date:   13.05.1995 (creation)
   Time-stamp: <96/01/29 09:24:47 mme> (last modification)

   This file belongs to the library BACKNET.
   It is Copyright (C) 1995, 1996 Ralf Schmidt.
   Please read the files README, doc/LICENSE and doc/DISCLAIMER.
   If you miss one of these files, please contact me:

   Email: rsc@informatik.th-zwickau.de
   Ordinary Mail: Ralf Schmidt
                  Neuplanitzer Strasse 41
				  D-08062 Zwickau
				  Germany

   Email: mme@pub.th-zwickau.de
   Ordinary Mail: Marko Meyer
                  Teichstrasse 27
				  D-08289 Schneeberg
				  Germany

   Changing History:
   
   95/12/08 -- Marko Meyer: Fixed up some problems with Take_Layer(int),
               which is now defined as virtual int Take_Layer(int).

*/



#include <net_errs.h>
#include <backnet.h>
#include <layer_aa.h>
#include <string.h>
#include <stdio.h>
#include __NN_FAST__

#ifdef LAYERTYPE
#undef LAYERTYPE
#endif

#define LAYERTYPE C_Layer_aa
#define C_ListMan C_NetLists

class C_NNet_aa:public C_FNNet
{
  protected:
	
	
	/*maintenance:*/
	
	C_Layer_aa *C_AktLayer;  /* Needed for successful work with the new
								Take_Layer(int)  --mme */
	int Maxsteps;
		
	ELEMTYPE Equal;
	ELEMTYPE MaxiDiff;
	
		
	S_NNet_Param *S_NNet; /* struct with NNet-data */
	

	virtual int Learn(char *s_Name, int *i_Steps, int i_MST);
	virtual int Recall(char *s_Name, int i_MST);

	virtual int learn();
	virtual int recal();
	
	virtual int Create_Lists();
	virtual int Open_GWI(char *s_Name);
	virtual int Init_Layers(int i_ArNeuCnt,
							float f_LearnRate, int i_InitMode, int i_Bias); 

	virtual int Open_MST(char *s_Name, int *i_MST);
	virtual int Open_LRN(char *s_Name, int *i_LRN);
	virtual int Open_ERR(char *s_Name);
	virtual int Open_OUT(char *s_Name, int i_MST);
	virtual int Randomize_Patterns(int *i_PatArr, int i_MST);

	virtual int Load_Pattern(int i_Where, int i_Num);
	virtual int Detect_Error();
	virtual int Write_OUT();
	virtual int Take_Layer(int);
	virtual int save();
		
  public:
	
	
	C_NNet_aa(float f_LearnRate  /*Learning Rate.*/,
			  int i_SelfBackCuppling /*allowed or not?*/,
			  char *s_GWIName  /*Filename for GWI-file.*/);

	int Init(int NeuCnt /*Array with amounts of neurpns/layer*/,
			 int i_InitMode /*InitMode for neuron*/,
			 int i_Minimum /*Minimum for Hopfield-activity-function 
							 of neurons*/,
			 int i_Maxsteps /*Maximal count of steps which 
							  can be done in function recall*/,
			 ELEMTYPE i_Equal /*If the highest difference between 
								the output-datas of neurons from two
								following neuron-recalls is slower than 
								i_Equal, then the net is stabil*/ );
	

	virtual int Action(int i_Action /*Determines, what action.*/,
			   char *s_Name /*Prename of files.*/,
			   int *i_Steps /*If i_Action==ACTN_LEARN number of learning
							  steps, otherwise unused.*/);
	virtual int Save(); 
	

	virtual ~C_NNet_aa();


};







