/* nnet.h
   
   Headerfile: Neural Network as class.

   Author: Marko Meyer
   Date:   13.05.1995 (creation)
   Time-stamp: <95/12/09 14:19:39 mme>

   This file belongs to the library BACKNET.
   It is Copyright (C) 1995 Marko Meyer.
   Please read the files README, doc/LICENSE and doc/DISCLAIMER.
   If you miss one of these files, please contact me:

   Email: mme@pub.th-zwickau.de
   Ordinary Mail: Marko Meyer
                  Teichstrasse 27
				  D-08289 Schneeberg
				  Germany

   Changes:
   
   95/12/08 -- Marko Meyer: Changed old Take_Layer(...) to
               virtual int Take_Layer(int)
   95/12/09 -- Marko Meyer: Included virtual int save();

*/

#ifndef _FAST_NEURAL_NET_
#define _FAST_NEURAL_NET_

#include <backnet.h>
#include <nnet.h>

class C_FNNet : public C_NNet
{
	
  protected:
	ELEMTYPE **Patterns;
	ELEMTYPE **LearnPatterns;

	/*maintenance:*/

	virtual int Learn(char *s_Name, int *i_Steps, int i_MST);
	virtual int Recall(char *s_Name, int i_MST);

	virtual int learn();
	virtual int recal();
	
	virtual int Create_Lists();
	virtual int Open_GWI(char *s_Name);
	virtual int Init_Layers(C_List<C_Layer*> *C_LStore, int *i_ArNeuCnt,
							float f_LearnRate, int i_InitMode, int i_Bias); 

	virtual int Open_MST(char *s_Name, int *i_MST);
	virtual int Open_LRN(char *s_Name, int *i_LRN);
	virtual int Open_ERR(char *s_Name);
	virtual int Open_OUT(char *s_Name, int i_MST);
	virtual int Randomize_Patterns(int *i_PatArr, int i_MST);

	virtual int Load_Pattern(int i_Where, int i_Num);
	virtual int Detect_Error();
	virtual int Write_OUT();
	virtual int Take_Layer(int);
	virtual int save();

  public:
	
	C_FNNet(int i_LayerCnt  /*Amount of layers.*/,
		   float f_LearnRate  /*Learning Rate.*/,
		   int i_Bias /*Should BIAS be used?*/,
		   char *s_GWIName  /*Filename for GWI-file.*/);

	virtual int Action(int i_Action /*Determines, what action.*/,
			   char *s_Name /*Prename of files.*/,
			   int *i_Steps /*If i_Action==ACTN_LEARN number of learning
							  steps, otherwise unused.*/);
	virtual int Save();
	virtual ~C_FNNet();


};
#endif /*_FAST_NEURAL_NET_*/






