/* autotest.cc

   Simple test program for BACKNET.

   Author: Marko Meyer
   Date:   10.08.1995 (creation)
   Time-stamp: <95/11/05 14:36:38 mme>

	BACKNET - A library for simulating neural BACKPROPAGATION-Networks
    Copyright (C) 1995	Marko Meyer

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


	If you have any suggestions, ideas or comments regarding this library
	feel free to contact me:

	Email:	mme@pub.th-zwickau.de
	Ordinary Mail:	Marko Meyer
					Teichstrasse 27
					D-08289 Schneeberg
					Germany


*/

#include <backnet.h>
#include <net_errs.h>
#include <nn_autoass.h>
#include <signal.h>
#include <sys/time.h>
#include <unistd.h>

int Inquire_Neurons(int* i_NeuArr,int i_Layers)
{
	for(int i=0;i<i_Layers;i++)
	{
		i_NeuArr[i]=0;
		while((i_NeuArr[i]<1)||(i_NeuArr[i]>100))
		{
			cin.clear();
			cout<<"How many Neurons do you want in Layer "<<i<<" ? ";
			cin>>i_NeuArr[i];
			if((i_NeuArr[i]<1)||(i_NeuArr[i]>100))
				cout<<"This amount ("<<i_NeuArr[i]<<") is not allowed!"<<endl;
		}
	}
	return NO_ERROR;
}


int Inquire_Params(float* f_LRate,int* i_Mode,int* i_Bias)
{
	*f_LRate=0;
	while((*f_LRate<=0)||(*f_LRate>=1))
	{
		cin.clear();
		cout<<"Please choose a factor for learning (usually betw. 0 and 1)! ";
		cin>>*f_LRate;
		if((*f_LRate<=0)||(*f_LRate>=1))
			cout<<"Such a factor ("<<*f_LRate<<") is not allowed!"
				<<endl;
	}
	*i_Mode=-1;
	while((*i_Mode<0)||(*i_Mode>4))
	{
		cin.clear();
		cout<<"What's the InitMode of the Neurons?"<<endl;
		cout<<"Possible choices are:"<<endl;
		cout<<"\t0 - Init from GWI-File"<<endl;
		cout<<"\t1 - Init with uniform values between 0 and 1"<<endl;
		cout<<"\t2 - Init with uniform values between -1 and 1"<<endl;
		cout<<"\t3 - Init with all values set to 0"<<endl;
		cout<<"\t4 - Init with all values set to 1"<<endl;
		cout<<"Make your choice: ";
		cin>>*i_Mode;
		if((*i_Mode<0)||(*i_Mode>4))
			cout<<"You've chosen a not allowed mode("<<*i_Mode<<")."<<endl;
	}
	
	*i_Bias=-1;
	while((*i_Bias<0)||(*i_Bias>1))
	{
		cin.clear();
		cout<<"Should BIAS be used?"<<endl;
		cout<<"Possible choices are:"<<endl;
		cout<<"\t0 - Do not use BIAS."<<endl;
		cout<<"\t1 - Use BIAS."<<endl;
		cout<<"Make your choice: ";
		cin>>*i_Bias;
		if((*i_Bias<0)||(*i_Bias>1))
			cout<<"This is not an allowed value ("<<*i_Bias<<")."<<endl;
	}
	return NO_ERROR;
}

int Inquire_Name(char* s_Name)
{
	cin.clear();
	cout<<"You must now choose a name for the GWI-file."<<endl;
	cout<<"Your choice: ";
	cin>>s_Name;
	return NO_ERROR;
}

int Inquire_Patternfile(char* s_FileName)
{
	cin.clear();
	cout<<"Please input a name for the Patternfile: ";
	cin>>s_FileName;
	return NO_ERROR;
}

int Inquire_Action(int *i_Action)
{
	*i_Action=0;
	cin.clear();
	
	while((*i_Action<1)||(*i_Action>3))
	{
		cin.clear();
		cout<<"What Action do you want? Possible choices are:"<<endl;
		cout<<"\t1 - Learning"<<endl;
		cout<<"\t2 - Recalling"<<endl;
		cout<<"\t3 - Ending"<<endl;
		cout<<"Make your choice: ";
		cin>>*i_Action;
		if((*i_Action<1)||(*i_Action>3))
			cout<<"This Action ("<<*i_Action<<") is not allowed."<<endl;
	}
	int i_SubAction=0;
	if(*i_Action<3)
	{
		while((i_SubAction<1)||(i_SubAction>2))
		{
			cin.clear();
			cout<<"Do you want to allow or deny self couplings?"<<endl;
			cout<<"\t1 - Allow self couplings"<<endl;
			cout<<"\t2 - Deny self couplings"<<endl;
			cout<<"Your choice: ";
			cin>>i_SubAction;
			if((i_SubAction<1)||(i_SubAction>2))
				cout<<"This is not allowed."<<endl;
		}
	}
	
	
	*i_Action|=(i_SubAction*16);
	return NO_ERROR;
}


int Inquire_Learn(int *i_Steps)
{
	*i_Steps=0;
	while(*i_Steps<=0)
	{
		cin.clear();
		cout<<"How many steps? ";
		cin>>*i_Steps;
		if(*i_Steps<=0) cout<<"Zero or less steps are not allowed!"<<endl;
	}
	return NO_ERROR;
}

int Inquire_Minimum(int *i_Min)
{
	*i_Min=0;
	cin.clear();
	cout<<"What's the minimum of the input data?";
	cin>>*i_Min;
	return NO_ERROR;
}

int Inquire_RecLim(int *i_RecLimit)
{
	*i_RecLimit=0;
	cin.clear();
	cout<<"What's the minimum of recalls when learning? (0 for unlimited): ";
	cin>>*i_RecLimit;
	return NO_ERROR;
}

int main(void)
{
	char c_Change='y',*s_Name=NULL;
	int *i_NeuroArr=NULL,i_InitMode,i_Bias;
	float f_Learnrate;
	int i_LSteps,i_Action, i_Minimum,i_RecLim;
	char *s_PatName,*s_RecPatName;
	ifstream I_Error;
	C_NN_Autoass *MyNet;
	int i_NetError;
	struct timeval time1, time2;
	int hour, minute, second;
	
	cout<<"This is AUTOTEST. You are expected to answer the following" 
		<<"questions \n and follow the advises the program will give."<<endl;
	cout<<endl;

    while(c_Change=='y')
	{
		i_NeuroArr=(int*)new int[1];
		Inquire_Neurons(i_NeuroArr,1);
		Inquire_Params(&f_Learnrate,&i_InitMode,&i_Bias);
		Inquire_Minimum(&i_Minimum);
		Inquire_RecLim(&i_RecLim);
		s_Name=(char*)new char[80];
		Inquire_Name(s_Name);
		cout<<"\f";
		cout<<"Okay, that's what you entered: "<<endl;
		cout<<"Your Net should have: "<<endl;
		cout<<"\t1 Layer with "<<i_NeuroArr[0]<<" Neurons"<<endl;
		cout<<"\tLearnrate: "<<f_Learnrate<<endl;
		cout<<"\tInitMode : "<<i_InitMode<<endl;
		cout<<"\tBias     : "<<((i_Bias==USE_BIAS)?"USED":"NOT USED")<<endl;
		cout<<"\tFilename : "<<s_Name<<endl;
		cout<<"\tMinimum  : "<<i_Minimum<<endl;
		cout<<endl;
	
		cout<<"That's all. Is there anything to change? (In case there is,\n"\
			<<"you have to enter new values for EVERYTHING!) ";
		cin>>c_Change;
	}
	cout<<"\f";
	cout<<"You entered lot's of values, now we will start to build up"
		<<"the Net!"<<endl;
	
	MyNet=(C_NN_Autoass*)new C_NN_Autoass(1,f_Learnrate,i_Bias,s_Name);
	i_NetError=MyNet->Init(i_NeuroArr[0],i_Minimum,i_InitMode,i_RecLim);
	cout<<"The Net returned ";
	if(i_NetError==NO_ERROR)
		cout<<"NO Error."<<endl;
	else
		cout<<"Error "<<i_NetError<<":"<<endl
			<<Return_ErrorMsg(i_NetError)<<endl;

	if(i_NetError==NO_ERROR)
	{
		cout<<endl;
		s_PatName=(char*)new char[80];
		s_RecPatName=(char*)new char[80];

		i_Action=ACTN_LEARN;
		while((i_Action & 0x0F)<=2)
		{
			Inquire_Action(&i_Action);
		
			if((i_Action & 0x0F)==ACTN_LEARN)	
			{	
				cout<<"We continue with learning."<<endl;
				do
				{
					Inquire_Patternfile(s_PatName);
				    Inquire_Learn(&i_LSteps);
					/* TIME */
					gettimeofday(&time1,NULL);
					i_NetError=MyNet->Action(i_Action,s_PatName,&i_LSteps);
					gettimeofday(&time2,NULL);
					/* TIME */
					hour=(time2.tv_sec-time1.tv_sec)/3600;
					minute=((time2.tv_sec-time1.tv_sec)%3600)/60;
					second=((time2.tv_sec-time1.tv_sec)%3600)%60;
					cout<<"Learning lasted: "<<endl
						<<"\t"<<hour<<" hours,\t"<<minute<<" minutes,\t"
							<<second<<" seconds."<<endl;
					cout<<"After learning the Net there is ";
					if(i_NetError==NO_ERROR)
						cout<<"NO Error."<<endl;
					else
						cout<<"Error "<<i_NetError<<":"<<endl
							<<Return_ErrorMsg(i_NetError)<<endl;
					c_Change='n';
					if(i_NetError==NO_ERROR)
					{
						cout<<"Continue learning ? ";
						cin>>c_Change;
					}
					else return i_NetError;
				}
				while(c_Change!='n');
			}
			else
			if((i_Action & 0x0F)==ACTN_RECAL)
			{
				cout<<"We continue with recalling!"<<endl;
				Inquire_Patternfile(s_RecPatName);
				i_NetError=MyNet->Action(i_Action,s_RecPatName,0);
				cout<<"After recalling the Net there is ";
				if(i_NetError==NO_ERROR)
					cout<<"NO Error."<<endl;
				else
					cout<<"Error "<<i_NetError<<":"<<endl
						<<Return_ErrorMsg(i_NetError)<<endl;
			}
			else 
				cout<<"Good bye and have a nice day!"<<endl;
		}
		if(i_NetError==NO_ERROR)
		{
			MyNet->Save();
			delete MyNet;
			if(i_NetError!=NO_ERROR)
				cout<<"Error at the end is: "<<i_NetError<<":"<<endl
					<<Return_ErrorMsg(i_NetError)<<endl;
		}
		else return i_NetError;
	}
	else return i_NetError;
	return i_NetError;
}


