/* back_connect_1.cc
   Author: Marko Meyer
   Date:   95/11/05 (creation)
   Time-stamp: <96/01/12 14:51:43 mme>

   These are functions for use in both client and server processes to
   provide some ability for creating TCP (and UDP, in future) connetctions.
   They have been moved mainly from neuron_serv_tcp_3.cc. 

   This file belongs to BACKNET.

   	BACKNET - A library for simulating neural BACKPROPAGATION-Networks
    Copyright (C) 1995, 1996	Marko Meyer

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


	If you have any suggestions, ideas or comments regarding this library
	feel free to contact me:

	Email:	mme@pub.th-zwickau.de
	Ordinary Mail:	Marko Meyer
					Teichstrasse 27
					D-08289 Schneeberg
					Germany

	History:

	95/11/05 -- Marko Meyer: created this with functions from 
	            neuron_srv_tcp_3.cc which became neuron_serv_tcp_4.cc.

	95/11/12 -- Marko Meyer: brought neuron_serv-function recv_req(...)
	            into this one and edited it slightly.

    95/11/18 -- Marko Meyer: included some semaphore operations
	
	95/11/22 -- Marko Meyer: prepared another instance of set_up_tcp
	            set_up_tcp(sockaddr_in *);

	95/11/26 -- Marko Meyer: changed char *recv_req(int) to 
	            Buf_Info *recv_req(int)

	95/12/03 -- Marko Meyer: included set_up_udp(char*, short)

	95/12/10 -- Marko Meyer: included key_t get_key(unsigned int seed)
	                         replaced ftok(3) widely with this.

	95/12/17 -- Marko Meyer: changed header of get_key(unsigned).

	95/12/21 -- Marko Meyer: Included bstruct in Buf_Info *recv_req(...).

	95/12/24 -- Marko Meyer: Changed recv_req because the definition of
	                         RSFollow in the RS and RDSt Structs got
							 changed: there's now stored an IntValue with
							 the amount of RDSt's follow the actual one.
	
	95/12/30 -- Marko Meyer: Changed send_emerg, so that sent errorvalues
	                         are negative.
							 
    96/01/11 -- Marko Meyer: Changed timeouting.
*/

#include <netbacknet.h>

int
set_up_tcp(char* host_addr, char *serv_name, short port)
{
	/* Sets a half connection up. Does a socket() and a bind() call. 
	   Returns the Socket-Descriptor or a negated ErrorInt. */

	int            sd = 0;   /* The socket descriptor. */
	sockaddr_in    own_adr;  /* The server adress. */
	servent       *service;  /* If given port is 0.*/
	

	/* Open the TCP socket. */

	if(port <= 0)
	{
		DBG(cerr<<"set_up_tcp: Given port is 0, trying to figure it out ..."
			<<endl);
		if(serv_name)
		{
			service = getservbyname(serv_name, "tcp");
			if((service))
			{
				port = (short) service->s_port;
				DBG(cerr<<"set_up_tcp: Found port "<<port<<" for service "
					<<serv_name<<"."<<endl);
			}
			else
			{
				cerr<<"set_up_tcp: Unknown service_name "<<serv_name
					<<". Going down."<<endl;
				exit(-ERR_UKSVNM_NWK);
			}
		}
		else
		{
			cerr<<"set_up_tcp: port AND serv_name are both unset. Unable to "
				<<"figure out service port. Going down."<<endl;
			exit(-ERR_USSNPO_NWK);
		}
	}
	
	DBG(cerr<<"set_up_tcp: Opening TCP socket ..."<<endl);
	
	if( (sd = socket(AF_INET, SOCK_STREAM, 0)) < 0)
	{
		cerr<<"set_up_tcp: Can't open stream socket; going down."<<endl;
		exit(-ERR_NDSSUP_NWK);
	}
	else
	{
		DBG(cerr<<"set_up_tcp: Socket descriptor is: "<<sd
			<<", now binding ..."<<endl);
		
		/* Bind the local or given adress to the socket. */
		
		bzero((char *) &own_adr, sizeof(own_adr));
		own_adr.sin_family = AF_INET;
		if(host_addr) 
			own_adr.sin_addr.s_addr = inet_addr(host_addr);
		else
			own_adr.sin_addr.s_addr = htonl(INADDR_ANY);
		own_adr.sin_port = htons(port);
		
		if(host_addr)
			if( connect(sd, (sockaddr *) &own_adr, sizeof(own_adr)) < 0)
			{
				cerr<<"set_up_tcp: Can't connect."<<endl;
				exit(-ERR_NOCONN_NWK);
			}
			else
				DBG(cerr<<"set_up_tcp: Connect successfull!"<<endl);
		else
			if( bind(sd, ( sockaddr *) &own_adr, sizeof(own_adr)) < 0)
			{
				cerr<<"set_up_tcp: Can't bind address."<<endl;
				exit(-ERR_NBLCAD_NWK);
			}
			else
				DBG(cerr<<"set_up_tcp: Binding successfull!"<<endl);
		return sd;	
	}
}

int
set_up_tcp(sockaddr_in *for_addr)
{
	/* Another set_up_tcp. Can be used when the address to _connect_ to
	   is already assembled into a sockaddr_in struct.        --mme */

	int sd;

	if( (sd = socket(AF_INET, SOCK_STREAM, 0)) < 0)
	{
		cerr<<"set_up_tcp: Can't open stream socket; going down."<<endl;
		exit(-ERR_NDSSUP_NWK);
	}
	else
	{
		if(connect(sd, (sockaddr *) for_addr, sizeof(sockaddr_in)) < 0)
		{
			cerr<<"set_up_tcp: Can't connect to address."<<endl;
			exit(-ERR_NBLCAD_NWK);
		}
		else
			DBG(cerr<<"set_up_tcp: Connecting successfull ..."<<endl);
		return sd;
	}
	
}

int
set_up_udp(char *serv_name, short port)
{
	/* Provides an UDP-Halfconnection. */

	int sd = 0;
	sockaddr_in own_addr;
	servent *service;
	
	if(port < 0)
	{
		DBG(cerr<<"set_up_udp: Port is less than zero."<<endl
			<<"\tTrying to figure out port by service name."<<endl);

		if(serv_name)
		{
			if((service = getservbyname(serv_name, "udp")))
			{
				DBG(cerr<<"set_up_udp: Figured out service: "<<serv_name
					<<" port is: "<<service->s_port<<endl);
				
				port = (short) service->s_port;
			}
			else
			{
				cerr<<"set_up_udp: Unknown serv_name: "<<serv_name
					<<" Going down."<<endl;
				exit(-ERR_UKSVNM_NWK);
			}
		}
		else
		{
			cerr<<"set_up_udp: port AND serv_name are both unset. Unable to "
				<<endl<<"\tfigure out service port. Going down."<<endl;
			exit(-ERR_USSNPO_NWK);
		}
	}
	
	DBG(cerr<<"set_up_udp: Opening UDP socket ..."<<endl);
	
	if( (sd = socket(AF_INET, SOCK_DGRAM, 0)) < 0)
		perror("set_up_udp: Error at socket(2) ");
	else
	{
		DBG(cerr<<"set_up_udp: Socket descriptor is: "<<sd<< ", now binding."
			<<endl);
		
		bzero((char *) &own_addr, sizeof(own_addr));
		own_addr.sin_family = AF_INET;
		own_addr.sin_addr.s_addr = htonl(INADDR_ANY);
		own_addr.sin_port = htons(port);
		
		if(bind(sd, (sockaddr *) &own_addr, sizeof(own_addr)) < 0)
			perror("set_up_udp: Error at bind ");
		else
			DBG(cerr<<"set_up_udp: Binding successfull!"<<endl);
	}
	return sd;
}

int 
send_emerg(int sd, int ASType,  AS *EmAS, sockaddr_in *addr = NULL, 
		   int len = 0)
{
	/* Sends an Emergency AS to sd. */
	
	if(ASType == AS_EMERG)
	{
		if((EmAS = ( AS *) calloc(1, RCV_AS)) != NULL)
		{
			EmAS->Magic = MAG_AS;
			EmAS->ReqID = REQ_EMERG;
			EmAS->RSID = 0;
			EmAS->Error = -ERR_TIMOUT_NWK;
			EmAS->RSFollow = FLW_NO;
			EmAS->NIStFollow = FLW_NO;
			
		}
		else 
		{
			cerr<<"send_emerg: Virtual memory exhausted."<<endl;
			exit(-ERR_MEMORY_NWK);
		}
	}	
	else
		if((ASType != AS_INDIV) || (EmAS == NULL))
			return ERR_UKEMTP_NWK;
	
	if(send_(sd, EmAS, 0, addr, len) < 0) return ERR_SNDEMR_NWK;
	else return NO_ERROR;
}

int
Displ_RS( RS *This_Request)
{
	cerr<<"Displaying RS at: "<<This_Request<<endl;
	cerr<<"\t\tMagic is: "<<This_Request->Magic<<endl;
	cerr<<"\t\tReqID is: "<<This_Request->ReqID<<endl;
	cerr<<"\t\tRSID is: "<<This_Request->RSID<<endl;
	cerr<<"\t\tNeuronID is: "<<This_Request->RSID<<endl;
	cerr<<"\t\tAttNIStList is: "<<This_Request->AttNIStList<<endl;
	cerr<<"\t\tRSFollow is: "<<This_Request->RSFollow<<endl;
	cerr<<"\t\tNIStFollow is: "<<This_Request->NIStFollow<<endl;
	
	return NO_ERROR;
}

struct RS *
Get_RS(int sd, sockaddr_in *addr = NULL, int *len = NULL, 
	   struct timeval *timeout = NULL)
{
	/* This one gets a Request Struct from the socket described by sd. 
	   Maybe there is some trouble getting it, then we return NULL. Error
	   management must be done by the calling function. */

	RS *This_Request;

	DBG(cerr<<"Get_RS: Getting RS from socket "<<sd<<endl);

	if((This_Request = ( RS *) new RS) == NULL)
	{
		cerr<<"Get_RS: Virtual memory exhausted."<<endl;
		exit(-ERR_MEMORY_NWK);
	}

	/* We will wait until a whole RS is arrived. Check the '0'!!*/
	/* We use recv_ now! */
	if( recv_(sd, This_Request, MSG_WAITALL, addr, len, timeout) <= 0)
	{
		/* Otherwise the connection is timed out or some other failure
		   occured. Then we delete the new'd struct and return NULL. */
		DBG(cerr<<"Get_RS: Receive timed out or failed."<<endl);
		DBG(perror("Get_RS: Error at recv_ [RS]"));
		
		delete This_Request;
	    return NULL;
	}
	DBG(Displ_RS(This_Request));
	if(This_Request->Magic != MAG_RS)
	{
		/* We should tell this to a console waiting or to a linked err-file,
		   because Magic-Errors are always serious things! */
		cerr<<"Get_RS: Magic Error"<<endl;
		delete This_Request;
		return NULL;
	}
	return This_Request;
}

int
Displ_NISt( NISt *This_NISt)
{
	cerr<<"Displaying NISt at: "<<This_NISt<<endl;
	cerr<<"\t\tMagic is: "<<This_NISt->Magic<<endl;
	cerr<<"\t\ti_NeuronID is: "<<This_NISt->i_NeuronID<<endl;
	cerr<<"\t\ti_NeuronLID is: "<<This_NISt->i_NeuronLID<<endl;
	cerr<<"\t\ti_NIStList is: "<<This_NISt->i_NIStList<<endl;
	cerr<<"\t\ti_WeightID is: "<<This_NISt->i_WeightID<<endl;
	cerr<<"\t\ti_WeightCnt is: "<<This_NISt->i_WeightCnt<<endl;
	cerr<<"\t\ti_InputCnt is: "<<This_NISt->i_InputCnt<<endl;
	cerr<<"\t\ti_PrErrLID is: "<<This_NISt->i_PrErrLID<<endl;
	cerr<<"\t\ti_InitMode is: "<<This_NISt->i_InitMode<<endl;
	cerr<<"\t\ti_LearnMode is: "<<This_NISt->i_LearnMode<<endl;
	cerr<<"\t\ti_FuncMode is: "<<This_NISt->i_FuncMode<<endl;
	cerr<<"\t\ti_UseBias is: "<<This_NISt->i_UseBias<<endl;
	cerr<<"\t\tNet_Input is: "<<This_NISt->Net_Input<<endl;
	cerr<<"\t\tActiv_Value is: "<<This_NISt->Activ_Value<<endl;
	cerr<<"\t\tOutput_Value is: "<<This_NISt->Output_Value<<endl;
	cerr<<"\t\tOutput_Deriv is: "<<This_NISt->Output_Deriv<<endl;
	cerr<<"\t\tLearnRate is: "<<This_NISt->LearnRate<<endl;
	cerr<<"\t\tDescript is: "<<This_NISt->Descript<<endl;

	return NO_ERROR;
}


struct NISt *
Get_NISt(int sd, sockaddr_in *addr = NULL, int *len = NULL,
		 struct timeval *timeout = NULL)
{
	/* This function receives one NISt from socket sd. */
	
	 NISt *This_NISt;
	
	DBG(cerr<<"Get_NISt: Reading NISt from socket "<<sd<<endl);
	
	if( (This_NISt = ( NISt *) new NISt) == NULL)
	{
		cerr<<"Get_NISt: Virtual Memory Exhausted!"<<endl;
		exit(-ERR_MEMORY_NWK);
	}
	
	/* There has been RCV_NISt instead of '0', please check! */

	if( recv_(sd, This_NISt, MSG_WAITALL, addr, len, timeout) <= 0)
	{
		DBG(cerr<<"Get_NISt: Receive timed out or failed."<<endl);
		delete This_NISt;
		return NULL;
	}
	
	DBG(Displ_NISt(This_NISt));
	if(This_NISt->Magic != MAG_NISt)
	{
		/* We should write this to stderr, because this is a serious error. */
		cerr<<"Get_NISt: Magic Error"<<endl;
		delete This_NISt;
		return NULL;
	}
	return This_NISt;
}

int
Displ_RDSt( RDSt *This_RDSt)
{
	cerr<<"Displaying RDSt at "<<This_RDSt<<endl;
	cerr<<"\t\tMagic is: "<<This_RDSt->Magic<<endl;
	cerr<<"\t\tRSID is: "<<This_RDSt->RSID<<endl;
	cerr<<"\t\tRSSID is: "<<This_RDSt->RSSID<<endl;
	cerr<<"\t\tRSFollow is: "<<This_RDSt->RSFollow<<endl;
	cerr<<"\t\tDVSize is: "<<This_RDSt->DVSize<<endl;
	cerr<<"\t\tDataVector is:"<<endl;
	cerr<<"\t\t";
	for(int i=0; i < This_RDSt->DVSize; i++)
		cerr<<"\t"<<This_RDSt->DataVector[i]<<endl;
	cerr<<endl;

	return NO_ERROR;
}


struct RDSt *
Get_RDSt(int sd, sockaddr_in *addr = NULL, int *addrlen = NULL,
		 struct timeval *timeout = NULL)
{
	/* This function reads a RDSt from the socket sd. */

	 RDSt *This_RDSt;
	int len = 0;
	
	DBG(cerr<<"Get_RDSt: Getting RDSt from socket "<<sd<<endl);
	
	if( (This_RDSt = ( RDSt *) new RDSt) == NULL)
	{
		cerr<<"Get_RDSt: Virtual Memory Exhausted!"<<endl;
		exit(-ERR_MEMORY_NWK);
	}

	/* Earlier on here RCV_RDSt was placed instead of '0'. Check sometimes! */
	if( (len = recv_(sd, This_RDSt, MSG_WAITALL, addr, addrlen, timeout)) <= 0)
	{
		DBG(cerr<<"Get_RDSt: Receive timed out or failed."<<endl);
		delete This_RDSt;
		return NULL;
	}

	DBG(Displ_RDSt(This_RDSt));
	
	if(This_RDSt->Magic != MAG_RDSt)
	{
		/* We should tell this error to stderr, because this is a serious 
		   error. */
		cerr<<"Get_RDSt: Magic Error"<<endl;
		delete This_RDSt;
		return NULL;
	}
	
	return This_RDSt;
}

int
Displ_AS( AS* This_AS)
{
	
	cerr<<"Displaying AS at: "<<This_AS<<endl;
	cerr<<"\t\tMagic: "<<This_AS->Magic<<endl;
	cerr<<"\t\tReqID: "<<This_AS->ReqID<<endl;
	cerr<<"\t\tRSID : "<<This_AS->RSID<<endl;
	cerr<<"\t\tError: "<<This_AS->Error<<endl;
	cerr<<"\t\t(Error Message is: "<<endl
		<<"\t\t "<<Return_ErrorMsg(This_AS->Error)<<")"<<endl;
	cerr<<"\t\tRSFollow: "<<This_AS->RSFollow<<endl;
	cerr<<"\t\tNIStFollow: "<<This_AS->NIStFollow<<endl;
	
	return NO_ERROR;
}


struct AS*
Get_AS(int sd, sockaddr_in *addr = NULL, int *len = NULL,
	   struct timeval *timeout = NULL)
{
	/* This one gets an AS from socket sd. */
	
	 AS *This_AS;
	
	DBG(cerr<<"Get_AS: Getting AS from socket: "<<sd<<endl);
	
	if( (This_AS = ( AS *) new AS) == NULL)
	{
		cerr<<"Get_AS: Virtual memory exhausted."<<endl;
		exit(-ERR_MEMORY_NWK);
	}
	else
	{
		if( recv_(sd, This_AS, MSG_WAITALL, addr, len, timeout) < 0)
		{
			DBG(cerr<<"Get_AS: Receive timed out or failed."<<endl);
			delete This_AS;
			return NULL;
		}

		DBG(Displ_AS(This_AS));
		
		if(This_AS->Magic != MAG_AS)
		{
			cerr<<"Get_AS: Magic Error!"<<endl;
			delete This_AS;
			return NULL;
		}
		
	}
	return This_AS;
}

		

struct Buffer_Info *
recv_req(int sd, sockaddr_in *addr = NULL, int *len = NULL)
{
	/* This one receives the request and stores it in the Buffer buf. 
	   The memory is allocated when the amount of data is determined. 
	   If recv_req sees incorrect data, it sends an AnswerStruct with an
	   appropriate error back and returns NULL. Otherwise the pointer to
	   the allocated Buffer is returned. */

	/* This function got changed when I revisited it during implementation
	   of the array server. I realized, that if this function is slightly
	   edited it can be used for this one as well. --mme 95/11/12 */

	struct RS *RS_Rcv = NULL;
	struct RDSt **RDSt_Rcv = NULL;
	struct NISt *NISt_Rcv = NULL;
	struct Buffer_Info *Buffer = new Buffer_Info;
	int RDSt_Cnt = 0;
	struct timeval timeout =  { 2,0 };
	char *buf = NULL;
	char *onbuf = NULL;
	int bufsize = 0;
	
	int i;
	
	DBG(cerr<<"recv_req: recv_req("<<sd<<")"<<endl);
	
	if(sd == 0) return NULL;
	else
	{
		if( (RS_Rcv = Get_RS(sd, addr, len)) == NULL)
		{
			/*cerr<<"recv_req: Receive Error. Writing AS_EMERG."<<endl;
			i_IntError = send_emerg(sd, AS_EMERG, NULL, addr, *len);
			cerr<<"recv_req: Writing AS_EMERG with "<<i_IntError<<endl;*/
			return NULL;
		}
		else
		{
			switch(RS_Rcv->ReqID)
			{
			  case REQ_INITN:
				/* We wait for a RS [which we have received yet], 
				   possibly (--mme 95/11/12) a NISt and
				   possibly (depending on the InitMode expressed in the NISt)
				   for some RDSt's with the initial weights. */
				
				DBG(cerr<<"recv_req: Received REQ_INITN."<<endl);
				if(RS_Rcv->NIStFollow != FLW_NO)
				{
					/* Everything is fine, so we read the NISt, which must be
					   next. */
	
					SETTIMEOUT(timeout,2,0);
					if( (NISt_Rcv = Get_NISt(sd, addr, len, &timeout)) == NULL)
					{
						send_emerg(sd, AS_EMERG, NULL, addr, *len);
						return NULL;
					}
				}
				RDSt_Cnt = RS_Rcv->RSFollow;
				if(RDSt_Cnt > 0)
				{
					if( (RDSt_Rcv = (struct RDSt **) new RDSt*[RDSt_Cnt])
					   == NULL)
				    {
						cerr<<"recv_req: Virtual Memory exhausted!"<<endl;
						exit(-1);
					}
					
					i = 0;
					do
					{
						DBG(cerr<<"recv_req: Recv. RDSt."<<endl);
						SETTIMEOUT(timeout,2,0);
						if( (RDSt_Rcv[i] = Get_RDSt(sd, addr, len, &timeout)) 
						   == NULL)
						{
							send_emerg(sd, AS_EMERG, NULL, addr, *len);
							return NULL;
						}
						i++;
					}
					while((RDSt_Rcv[i-1]->RSFollow != FLW_NO) 
						  && (i < RDSt_Cnt));
					
					/* We don't care some more attached RDSt's. The sender 
					   has to take care about the filling situation of it's
					   RDSt's. They have to be filled completely. */

					/* If there have been not enough RDSt's, we send an 
					   EMERGENCY AS. */
					
					if( i < RDSt_Cnt)
					{
						DBG(cerr<<"recv_req: Got not enough RDSt's!"<<endl);
						send_emerg(sd, AS_EMERG, NULL, addr, *len);
						return NULL;
					}
					
					/* Now we are ready. The buffer is filled, we can return 
					   it. */
				}
				break;
			  case REQ_RECAL:
			  case REQ_LEARN:
				/* We wait for a RS (which we have received yet) and some
				   RDSt's with the learn-data. */
				DBG(cerr<<"recv_req: Received REQ_LEARN or REQ_RECAL."
					<<endl);				
				if(RS_Rcv->RSFollow == FLW_NO)
				{
					DBG(cerr<<"recv_req: Expected RS.RSFollow set, got "
						<<RS_Rcv->RSFollow<<endl);
					send_emerg(sd, AS_EMERG, NULL, addr, *len);
					return NULL;
				}
				i = 0;
				RDSt_Cnt = RS_Rcv->RSFollow;
				if((RDSt_Rcv=(struct RDSt **) new RDSt*[RDSt_Cnt]) == NULL)
				{
					cerr<<"recv_req: Virtual Memory exhausted!"<<endl;
					exit(-1);
				}
					
				do
				{
					SETTIMEOUT(timeout,2,0);
					if( (RDSt_Rcv[i] = Get_RDSt(sd, addr, len, &timeout)) 
					   == NULL)
					{
						DBG(cerr<<"recv_req: Expected another RDSt, got "
							<<"none."<<endl);
						send_emerg(sd, AS_EMERG, NULL, addr, *len);
						return NULL;
					}
					i++;
				}
				while((RDSt_Rcv[i-1]->RSFollow != FLW_NO) && 
					  (i < RDSt_Cnt));
				break;
			  case REQ_DSTRY:
			  case REQ_SAVEW:
				/* We expect nothing but the RS. */
				DBG(cerr<<"recv_req: Received REQ_SAVEW or REQ_DSTRY."
					<<endl);
				break;
			  default:
				DBG(cerr<<"recv_req: Received unknown REQ."<<endl);
				return NULL;
			}

			/* Now we received everything we need. We assemble the 
			   buffer for return now. */
			
			bufsize = RCV_RS +
				((NISt_Rcv == NULL)? 0 : RCV_NISt) +
					((RDSt_Rcv == NULL)? 0 : RDSt_Cnt * RCV_RDSt);
			
			DBG(cerr<<"recv_req: Assembling return buffer."<<endl;
				cerr<<"\t\tRS_Rcv is: "<<RS_Rcv<<endl;
				cerr<<"\t\tNISt_Rcv is: "<<NISt_Rcv<<endl;
				cerr<<"\t\tRDSt_Rcv is: "<<RDSt_Rcv<<endl;
				cerr<<"\t\t\tRDSt_Cnt is: "<<RDSt_Cnt<<endl;
				cerr<<"\t\tgives a size of "<<bufsize<<" Bytes."<<endl);
			
			if( (buf = (char *) calloc(1,bufsize)) == NULL)
			{
				cerr<<"recv_req: Virtual Memory exhausted."<<endl;
				exit(-1);
			}
			
			onbuf = buf;
			memcpy(onbuf, RS_Rcv, RCV_RS);
			onbuf += RCV_RS;
			Buffer->bstruct=HAS_RS;
			delete(RS_Rcv);
			
			if(NISt_Rcv != NULL)
			{
				memcpy(onbuf, NISt_Rcv, RCV_NISt);
				onbuf += RCV_NISt;
				Buffer->bstruct|=HAS_NIST;
				delete(NISt_Rcv);
			}
			if(RDSt_Rcv != NULL)
			{
				for( i = 0; i < RDSt_Cnt; i++)
				{
					memcpy(onbuf, RDSt_Rcv[i], RCV_RDSt);
					onbuf += RCV_RDSt;
					delete(RDSt_Rcv[i]);
				}
				free(RDSt_Rcv);
				Buffer->bstruct|=HAS_RDST;
			}

			Buffer->size = bufsize;
			Buffer->key = -1;
			Buffer->address = buf;

			return Buffer;	
		}
	}
}

int 
create_sem(key_t *sem_key)
{
	/* Creates a semaphore and returns it's id. */
	int id = -1;
	union semun un;
	
	un.val=0;

	if(sem_key == NULL)
	{
		if((sem_key = (key_t *) calloc(1,sizeof(key_t))) == NULL)
			perror("create_sem: error at calloc");
	}
	
	/*if((*sem_key = ftok("/etc/passwd", (char) random())) == -1)
		perror("create_sem: error at ftok");*/
	if((*sem_key = get_key(0)) == 0)
		perror("Error at get_key");
	else
	{
		if( (id=semget(*sem_key, 1 , 0666 | IPC_CREAT )) < 0)
			perror("create_sem: error at semget");
		else
			if((semctl(id,0,SETVAL,un)) < 0) 
			{
				perror("create_sem: error at semctl-SETVAL");
				id=-1;
			}
	}
	
	return id;
}

int 
open_sem(key_t sem_key)
{
	/* Opens the semaphore named semid. */
	
	return semget(sem_key, 1, 0);
}

int
remove_sem(int semid)
{
	/* Removes a semaphore 'the hard way'. */

	semun dummy;
	
	dummy.val = 0;
	return semctl(semid, 0, IPC_RMID, dummy);
}

int 
wakeup_sem(int semid)
{
	/* This one wakes someone up by doing an UP on a semaphore semid. */

	sembuf upsem ={0,1,0};

	return semop(semid, &upsem, 1);
}

int 
down_sem(int semid)
{
	/* This one does a DOWN on a semaphore semid. */

	sembuf downsem = {0,-1,0};

	return semop(semid, &downsem, 1);
}

key_t
get_key(unsigned int seed)
{
	/* This method replaces ftok(3), which is not sufficient for getting
	   lots of keys in a short time. */

	struct timeval timev;

	if(seed == 0) /* The user can give a seed, (s)he didn't. */
	{
		gettimeofday(&timev,NULL);
		srand((unsigned int) (timev.tv_usec));
		return (key_t) rand();
	}
	else 
	{
		srand(seed);
		return (key_t) rand();
	}
}

