/* layer_aa.cc

   Realizes functionality of a neural-network-layer.

   Author: Ralf Schmidt
   Date:   30.09.1995 (creation)
   Time-stamp: <96/01/31 13:15:06 rsc> (last modification)
		   
	BACKNET - A library for simulating neural BACKPROPAGATION-Networks
    Copyright (C) 1995	Ralf Schmidt

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


	If you have any suggestions, ideas or comments regarding this library
	feel free to contact me:

	
	Email:  rsc@informatik.th-zwickau.de
	Ordinary Mail:  Ralf Schmidt
	                Neuplanitzer Strasse 41
					D-08062 Zwickau
					F.R.G.


	Email:	mme@pub.th-zwickau.de
	Ordinary Mail:	Marko Meyer, Teichstrasse 27, D-08289 Schneeberg, Germany

	Changes:

	95/12/08 -- Marko Meyer: Changed header of C_Layer_aa::C_Layer_aa(...).
	95/12/09 -- Marko Meyer: Took changes back.

*/

#define error(x)  (cerr<<"Layer_aa: The following error has occured: "\
					  <<x<<"!"<<endl)

#include <layer_aa.h>

C_Layer_aa::C_Layer_aa(S_NNet_Param *S_NNetData, /*pointer to 
												   struct with 
												   NNet-Data*/
					   C_List<ELEMTYPE> *C_NetLists, /*pointer to 
													   ListManager
													   <ELEMTYPE>*/
					    int i_NeuCnt,    /*number of neurons 
										   in current layer*/
					    int i_InpList,   /*number of first inputlist*/
						float f_LearnRate  /*learning rate*/
					   )
:
C_Layer(C_NetLists,/*i_LayNetID, --mme*/i_NeuCnt, (C_Layer *) NULL,
		i_InpList,f_LearnRate,NO_BIAS)
{
	int i_Error=NO_ERROR;
	
	DBG(cerr<<"Layer_aa: Entering Auto-associator-Layer constructor"<<endl);
	S_NNet=S_NNetData;
	
	C_Neu_aaStor=(C_List<C_Neuron_aa*>*) new C_List<C_Neuron_aa*>;
	S_LayerData.i_Input_List=i_InpList;
	S_LayerData.i_Output_List=C_ListMan->ncreate(S_LayerData.i_Neuro_Cnt,
												 &i_Error);
	
	S_LayerData.i_Help_Input_List=C_ListMan->\
		ncreate(S_LayerData.i_Neuro_Cnt,&i_Error);
	if(i_Error!=NO_ERROR)
	{
		error(i_Error);
	}
	i_NeuList=C_Neu_aaStor->create(NULL,&i_Error);
	if (i_Error!=NO_ERROR)
	{
		error(i_Error);
	}
	
}


int 
C_Layer_aa::Init(int i_InitMode,              /*init-mode for neurons*/
				 ifstream *I_GWI_File)            /*file with stored weights*/
{
	/*S_DeltaData=S_Delta_Data;*/ /* This seems to be senseless */
	/*We don't need C_NeuStor, cause we use C_NeuStor_aa*/
	
	DBG(cerr<<"Layer_aa: Entering Init"<<endl);
	delete C_NeuStor;
	C_NeuStor=NULL;
	
		
	/*init for all the neurons*/
	return Init_Neurons(i_InitMode, i_Bias, inCount, I_GWI_File);
}

int
C_Layer_aa::Action(int i_action_nr)
{
	int i_Error,i,j,i_Flag=0;
	ELEMTYPE output;
	
	C_Neuron_aa *C_Tmp_Neuron; /*This is needed for the function calls.*/
	i_Error=NO_ERROR;
	DBG(cerr<<"Layer_aa: Entering Action ..."<<endl);
	if(i_action_nr==ACTN_RECAL)
	{
		
		DBG(cerr<<"Layer_aa: We write now the i_Help_Input_List of this layer"
			<<endl);
	
		for(j=1;j<=S_LayerData.i_Neuro_Cnt;j++)
		{
			i_Error=C_ListMan->read(S_LayerData.
									i_Output_List,j,&output);
			if(i_Error==NO_ERROR)
			{
				i_Error=C_ListMan->
					write(S_LayerData.i_Help_Input_List,j,output);
			}
			else
			{
				error(i_Error);
				return i_Error;
			}
		}

		DBG(cerr<<"Layer_aa: The i_Help_Input_List of this layer is written"
			<<endl);
	}
	
	if(C_Neu_aaStor)
	{
		
		
		for(i=1;i<=S_LayerData.i_Neuro_Cnt;i++)
		{
			/*First determine the current Neuron ...*/
			i_Error=C_Neu_aaStor->read(i_NeuList,i,&C_Tmp_Neuron);
			if(i_Error==NO_ERROR)
			{
				/*...either call neuron's function Recall() or Learn()...*/
				switch(i_action_nr)
				{
				  case ACTN_RECAL:
					i_Error=C_Tmp_Neuron->Recall();
					break;
				  case ACTN_LEARN:
					i_Error=C_Tmp_Neuron->Learn();
					break;
				  default:
					i_Error=ERR_WRACTN_LAY;
				}
			}
			else return i_Error;
		}
		if(i_action_nr==ACTN_LEARN)
		{
			for(i=1;i<=S_LayerData.i_Neuro_Cnt;i++)
			{
				i_Error=C_Neu_aaStor->read(i_NeuList,i,&C_Tmp_Neuron);
				if(i_Error!=NO_ERROR)
				{
					error(i_Error);
					return i_Error;
				}
				i_Flag=C_Tmp_Neuron->Check_Weights(1e+100);	
				if(i_Flag==1)
					break;
			}
		}
		if(i_Flag==1)
		{
			for(i=1;i<=S_LayerData.i_Neuro_Cnt;i++)
			{
				i_Error=C_Neu_aaStor->read(i_NeuList,i,&C_Tmp_Neuron);
				if(i_Error!=NO_ERROR)
				{
					error(i_Error);
					return i_Error;
				}
				i_Error=C_Tmp_Neuron->Change_Weights((ELEMTYPE)  
													 S_LayerData.i_Neuro_Cnt);
				if(i_Error!=NO_ERROR)
				{
					error(i_Error);
					return i_Error;
				}
			}
		}
		
	}
	
	else return ERR_NONSTR_LAY;
	DBG(cerr<<"Layer_aa: Leaving Action with Error: "<<i_Error<<endl);
	return i_Error;
}


int 
C_Layer_aa::Save(ofstream *O_GWI_Save)
{
	int i_Error=NO_ERROR;
	C_Neuron_aa *C_AktNeuron;
	DBG(cerr<<"Layer_aa: Entering Save ..."<<endl);
	for(int i=1;i<=S_LayerData.i_Neuro_Cnt;i++)
	{
		i_Error=C_Neu_aaStor->read(i_NeuList,i,&C_AktNeuron);
		if(i_Error==NO_ERROR)
			i_Error=C_AktNeuron->Save(O_GWI_Save);
		if(i_Error!=NO_ERROR)
		{
			error(i_Error);
			return i_Error;
		}
	}
	return i_Error;
}


C_Layer_aa::~C_Layer_aa()
{
	DBG(cerr<<"Layer_aa: Entering Destructor ... "<<endl);
	
	Destroy_Neurons();
	Destroy_List(S_LayerData.i_Output_List);
	Destroy_List(S_LayerData.i_Error_List);
	Destroy_List(S_LayerData.i_Help_Input_List);
	
   	delete C_Neu_aaStor;
}



S_Layer_Param *
C_Layer_aa::hand_lay_data()
{
	return C_Layer::hand_lay_data();
	
}

int 
C_Layer_aa::Create_List(int i_Count,ELEMTYPE Cont)
{
	return C_Layer::Create_List(i_Count,Cont);
}


int 
C_Layer_aa::Destroy_List(int i_Numb)
{
	return C_Layer::Destroy_List(i_Numb);
	
}


int 
C_Layer_aa::Init_Neurons(int i_InitMode,int i_BiasQuest,
						  int inCount,ifstream *I_GWI_File)
{
	int i;
	int i_Error;
		
	C_Neuron_aa *C_Tmp_Neuron;
	
	DBG(cerr<<"Layer_aa: Entering Init_Neurons ..."<<endl);
	/*Initialize all the neuron's being wanted by the net*/
	i_Error=NO_ERROR;
	for(i=1;(i<=S_LayerData.i_Neuro_Cnt)&&(i_Error==NO_ERROR);
		i++)
	{
		C_Tmp_Neuron=(C_Neuron_aa*)new C_Neuron_aa(S_NNet,
												   &S_LayerData,\
											 C_ListMan,\
											 i,\
											 inCount,
											 i_BiasQuest);

		if(C_Tmp_Neuron==NULL) return ERR_NONEUR_LAY;
	
		if(i_Error!=NO_ERROR)
		{
			error(i_Error);
			return i_Error;
		}
		
		
		i_Error=C_Tmp_Neuron->Init(i_InitMode,
								   I_GWI_File);

		if(i_Error==NO_ERROR)
		{
			if(i==1) i_Error=C_Neu_aaStor->\
				write(i_NeuList,i,C_Tmp_Neuron);
			else i_Error=C_Neu_aaStor->\
				append(i_NeuList,C_Tmp_Neuron);
		}
	}
	DBG(cerr<<"Layer_aa: Leaving Init_Neurons with Error: "<<i_Error<<endl);
	return i_Error;
}

int 
C_Layer_aa::Destroy_Neurons()
{
	int i,i_Error,i_Error2;
	C_Neuron_aa *C_ActNeuron;
	
	
	DBG(cerr<<"Layer_aa: Entering Destroy_Neurons ..."<<endl);
	/* Call destructor of every neuron.*/
	i_Error2=NO_ERROR;
	i_Error=NO_ERROR;
	
	/*While a Neuron exists in the Neuron-list ...*/
	for(i=1;i<=S_LayerData.i_Neuro_Cnt;i++)
	{
		i_Error2=C_Neu_aaStor->read(i_NeuList,i,&C_ActNeuron);
		if(i_Error2==NO_ERROR)
			delete C_ActNeuron;
		
		if(i_Error!=NO_ERROR) 
		{ 
			if(i_Error2!=NO_ERROR) i_Error2=i_Error;
			else (i_Error2=ERR_MULTIP_NET);
		}
	}
	
	DBG(cerr<<"Layer_aa: Leaving Destroy_Neuron with Error: "<<i_Error2<<endl);
	return i_Error2;
}
	

		
