/* neuron_aa.cc
   Realizes one single neuron of a neural network.
    
   Author: Ralf Schmidt
   Date: 10.09.1995 (creation)
   Time-stamp: <96/01/31 13:13:38 rsc>
        
	BACKNET - A library for simulating neural BACKPROPAGATION-Networks
    Copyright (C) 1995	Ralf Schmidt

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


	If you have any suggestions, ideas or comments regarding this library
	feel free to contact me:

	Email:  rsc@informatik.th-zwickau.de
	Ordinary Mail:  Ralf Schmidt
	                Neuplanitzer Strasse 41
					D-08062 Zwickau
					F.R.G.
	
	
	Email:	mme@pub.th-zwickau.de
	Ordinary Mail:	Marko Meyer
					Teichstrasse 27
					D-08289 Schneeberg
					F.R.G.

*/

#include <neuron_aa.h>
#include <sys/time.h>
#include <unistd.h>

#define  error(x) (cerr<<"Neuron_aa: The following error occured: "<<x<<"!"\
					  <<endl)

C_Neuron_aa::C_Neuron_aa(S_NNet_Param *S_NNetData,
						 /*pointer to struct with nnet-data*/
						 S_Layer_Param *S_LayerData, 
						 /*pointer to struct with layer-data*/
                         C_List<ELEMTYPE> *C_NetLists,  
						 /*pointer to ListManager*/
                         int i_NeuNetID,                
						 /*position of neuron within net = position of neuron 
						   within layer since there is only one layer*/
                         int i_InputCount,              /*number of inputs*/
                         int i_BiasQuest)               /*using BIAS or not*/
:C_Neuron(S_LayerData,C_NetLists,i_NeuNetID,i_NeuNetID,i_InputCount,
		  i_BiasQuest) 
/*Here we call the constructor of the superclass C_Neuron*/
{
    /*This is the constructor of a single Auto-Associator-Neuron*/
    DBG(cerr<<"Neuron_aa: Entering Auto-Associator Neuron's constructor."<<endl);
	S_NNet=S_NNetData;
	
}
 
    
int
C_Neuron_aa::Init(int i_InitMode             /*number of initmode*/,
				  ifstream *I_GWI_File)
{
	/* Init - Initializes everything. */
	int i_LocError=NO_ERROR;

	DBG(cerr<<"Neuron_aa: Entering Init"<<endl);
	
	if(S_Neuron==NULL) return ERR_MEMORY_NEU;
	i_LocError=Create_Wgt_List(S_Neuron->i_WeightCnt,0);
	if(i_LocError==NO_ERROR)
	{
		/*if done initialize weights in weightlist*/
		DBG(cerr<<"Neuron_aa: Switching Init-Mode: "<<i_InitMode<<endl);
		
		switch(i_InitMode)
		{
		  case INIT_FROM_GWI:
			i_LocError=Init_GWI(I_GWI_File);
			break;
		  case INIT_GV_0_1:
			i_LocError=Init_GV(0,1);
			break;
		  case INIT_GV_N_P:
			i_LocError=Init_GV(-1,1);
			break;
		  case INIT_0:
			i_LocError=Init_(0);
			break;
		  case INIT_1:
			i_LocError=Init_(1);
			break;
		  default:
			i_LocError=ERR_INITMD_NEU;
		}
	}
	else return i_LocError;
	i_LocError=C_ListMan->write(S_Neuron->i_Weights,1,1);
	if(i_LocError!=NO_ERROR)
	{
		error (i_LocError);
		return i_LocError;
	}
	return i_LocError;
			
}


int 
C_Neuron_aa::Create_Wgt_List(int i_Count,ELEMTYPE Cont)
{
	return C_Neuron::Create_Wgt_List(i_Count,Cont);
}


int 
C_Neuron_aa::Destroy_Wgt_List()
{
	return C_Neuron::Destroy_Wgt_List();
}

int 
C_Neuron_aa::Init_GV(ELEMTYPE Min,ELEMTYPE Max)
{
	return C_Neuron::Init_GV(Min,Max);
}

int 
C_Neuron_aa::Init_(ELEMTYPE value)
{
	return C_Neuron::Init_(value);
}

int 
C_Neuron_aa::Init_GWI(ifstream *I_GWI_File)
{
	return C_Neuron::Init_GWI(I_GWI_File);
}

int 
C_Neuron_aa::Load_GWI(ifstream *I_GWI_File)
{
	return C_Neuron::Load_GWI(I_GWI_File);
}

int 
C_Neuron_aa::Save_GWI(ofstream *O_GWI_Save)
{
	return C_Neuron::Save_GWI(O_GWI_Save);
}

int 
C_Neuron_aa::Save(ofstream *O_GWI_Save)
{
	return C_Neuron::Save(O_GWI_Save);
}

C_Neuron_aa::~C_Neuron_aa()
{
	/*This is the destructor of a single Neuron.  */
	/*Deleting Neuron-information-struct if existent.  */
	/*Deleting the weightlist.  */
	/*Although it is possible that errors occure during 'Destroy_Wgt_List()'
	  we don't care.  This is the destructor of the Neuron and everything
	  must be destroyed.  What can't be destroyed by the program itself is
	  either not present or can be destroyed by the operating system.  */
    /*Destroy_Wgt_List();*/
	DBG(cerr<<"Neuron_aa: Leaving Neuron."<<endl);
}


int 
C_Neuron_aa::Recall()
{
	return C_Neuron::Recall();
}



int 
C_Neuron_aa::Learn()
{
	return C_Neuron::Learn();
}


int 
C_Neuron_aa::calc_effective_input()
{
	/* This is the virtual function for calculating the effective Input of a
	   Neuron. It takes the values from the Input- and HelpInputList 
	   of the neuron,
	   multiplicates them
	   with the appropriate weights and adds the results. So one value is
	   created: 'Entrance'. It is saved as a parameter of the Neuron. */
    
	int i_IntError=NO_ERROR;
	ELEMTYPE Input=0,Output=0,Weight=0,PreEntrance=0;
	
	DBG(cerr<<"Neuron_aa: Entering calc_effective_input ..."<<endl);
	i_IntError=NO_ERROR;
	DBG(cerr<<"Neuron_aa: i_IntError=No_Error"<<endl);
	
	Entrance=0.;
	DBG(cerr<<"Neuron_aa: Entrance=0."<<endl);
	
	PreEntrance=0.;
	DBG(cerr<<"Neuron_aa: PreEntrance=0."<<endl);
	
	
	
    
  	DBG(cerr<<"Neuron_aa: Reading extern input: "<<S_Neuron->i_Neuro_Nr<<endl);
	
	/*Here we read the extern input of the actual neuron (each neuron has 
	  ONE extern input) */ 
	i_IntError=C_ListMan->read(S_Layer->i_Input_List,\
							   S_Neuron->i_Neuro_Nr,&Input);
	
	if(i_IntError==NO_ERROR)
	{
		/*Now we read the weights*/
		for(int i=1;i<=(S_Neuron->i_WeightCnt-S_Neuron->i_UseBias);i++)
		{
			DBG(cerr<<"Neuron_aa: Reading weight :"<<i-1<<endl);
			
			i_IntError=C_ListMan->read(S_Neuron->i_Weights,i,&Weight);
			
			if(i_IntError==NO_ERROR)
			{

				/*Now we must test, whether it is the first weight wi0*/
				if(i==1)
				{
					DBG(cerr<<"Neuron_aa: Multiplicating the first weight w"
						<<S_Neuron->i_Neuro_Nr<<":0 with the extern input "
						<<endl<<"of this neuron and storing in PreEntrance"
						<<endl);
					
					PreEntrance=Weight*Input;
				}
                /*It isn't the first weight*/
				else
				{
					DBG(cerr<<"Neuron_aa: Reading the output of neuron "<<i-1
						<<endl);
					
					/*We must read the output of the neuron i-1 since the 
					  first weight of the neuron is multiplicated with the 
					  extern input, the second weight wi1 is then 
					  multiplicated with the output of neuron 1 and so on*/
					if(((i-1)==S_Neuron->i_Neuro_Nr)&&\
					   (S_NNet->i_SelfBackCuppling==SelfBackCuppling_Denied))
					{
						/* If SelfBackCuppling is forbidding then we set 
						   Output to 0, this should do it */
						Output=0;
					}
					else
					{
						
						i_IntError=C_ListMan->read(S_Layer->i_Help_Input_List,\
												   i-1,&Output);
					}
					
					if(i_IntError==NO_ERROR)
					{
						DBG(cerr<<"Neuron_aa: Multiplicating the weight w"
							<<S_Neuron->i_Neuro_Nr<<":"<<i-1
							<<"of this neuron with the output of neuron "
							<<i-1<<endl
							<<"and adding the product to PreEntrance"<<endl);
						
						
						PreEntrance+=Weight*Output;
												
					}
					else
					{
						error(i_IntError);
						return i_IntError;
						
					}
				}/*Here was tested whether we read the first */
			}
			
				
			else
			{
				error(i_IntError);
				return i_IntError;
					
			}
			
		}/*This is the ending of the loop*/
		Entrance=PreEntrance;
		DBG(cerr<<"Neuron_aa: Entrance of Neuron "
			<<S_Neuron->i_Neuro_Nr<<" is "
			<<Entrance<<endl);
		
			
	}	
    else
    {
		
	       error(i_IntError);
           return i_IntError;
				
    }
	return i_IntError;

}		
			
		

int 
C_Neuron_aa::calc_activity_value()
{
	/* This one calculates the value of the activity function. 
	   In this case we used the Hopfield-function. */
	
	DBG(cerr<<"Neuron_aa: Entering calc_activity_value ..."<<endl);
	if(Entrance<0)
	{
		Activity=S_NNet->i_Minimum;
	}
	else if(Entrance>0)
	{
		Activity=1;
	}
	return NO_ERROR;
	
}

 
int 
C_Neuron_aa::calc_output_value(int i_Derivation)
{
	/*This one calculates the output value. It is simple because the output-
	  function is the identity. */
	int i_IntError;
	i_Derivation=i_Derivation;
	
	DBG(cerr<<"Neuron_aa: Entering calc_output_value..."<<endl);
	Exit=Activity;
	DBG(cerr<<"Neuron_aa: Exit is: "<<Exit<<endl);
	i_IntError=C_ListMan->write(S_Layer->i_Output_List,S_Neuron->i_Neuro_Nr,
								Exit);
	
	return NO_ERROR;
}

int 
C_Neuron_aa::distribute_error()
{
	return NO_ERROR;
}

  
int 
C_Neuron_aa::modify_weights()
{
	
	/* This function modifies the weights using the Delta-Learning-Rule */

	ELEMTYPE input_first=0;
	ELEMTYPE input_sum=0;
	ELEMTYPE input_all=0;
	ELEMTYPE weight=0;
	
	ELEMTYPE input=0;
	
	
	int i_IntError=NO_ERROR;
	int j,k;
	
	
	DBG(cerr<<"Neuron_aa: Entering modify_weights ..."<<endl);
	for(j=1;j<=S_Neuron->i_WeightCnt-1;j++)
	{
		/* Now we read the first weight */
		DBG(cerr<<"Neuron_aa: Reading the first weight weight"
			<<S_Neuron->i_Neuro_Nr<<":"<<j-1<<endl);
		i_IntError=C_ListMan->read(S_Neuron->i_Weights,1,&weight);
		if(i_IntError==NO_ERROR)
		{
			DBG(cerr<<"Neuron_aa: Reading the extern entrance E"
				<<S_Neuron->i_Neuro_Nr<<endl);
			i_IntError=C_ListMan->read(S_Layer->i_Input_List,\
									   S_Neuron->i_Neuro_Nr,
									   &input);
			
			if(i_IntError==NO_ERROR)
			{
				input_first=weight*input;
				
				/*Now we must add the products of the weights and outputs 
				  (these stand in i_Help_Input_List) from
				  1 to the NeuronCount */
				
				DBG(cerr<<"Neuron_aa: Now entering the loop for" 
					<<"adding the products..."<<endl);
				
				for(k=1;k<=S_Neuron->i_WeightCnt-1;k++)
				{
					DBG(cerr<<"Neuron_aa: Reading the weight w"
						<<S_Neuron->i_Neuro_Nr<<":"<<k<<endl);
					
					i_IntError=C_ListMan->read(S_Neuron->i_Weights,k+1,
											   &weight);
					if(i_IntError==NO_ERROR)
					{
						if((k==S_Neuron->i_Neuro_Nr)&&\
						   (S_NNet->i_SelfBackCuppling==\
							SelfBackCuppling_Denied))
						{
							input=0;
						}
						else
						{
							
							DBG(cerr<<"Neuron_aa: Reading the output A"<<k<<endl);
							i_IntError=C_ListMan->read(S_Layer->\
													   i_Help_Input_List,k,
													   &input);
						}
						
						if(i_IntError==NO_ERROR)
						{
							input_sum+=weight*input;
						}
						else
						{
							error(i_IntError);
							return i_IntError;
							
						}
					}
					else
					{
						error(i_IntError);
						return i_IntError;
						
					}
				} /* End of the k-loop */
				input_all=input_first-input_sum;
				DBG(cerr<<"Neuron_aa: Now reading the input E"<<j<<endl);
				i_IntError=C_ListMan->read(S_Layer->i_Input_List,j,&input);
				if(i_IntError==NO_ERROR)
				{
					input_all*=S_Layer->f_Learn_Rate*input;
				}
			}
			else
			{
				error(i_IntError);
				return i_IntError;
				
			}
		}
		else
		{
			error(i_IntError);
			return i_IntError;
			
		}
		
		DBG(cerr<<"Neuron_aa: input_all of weight "<<j-1<<" of Neuron "
			<<S_Neuron->i_Neuro_Nr
			<<" is "<<input_all<<endl);
		
		DBG(cerr<<"Neuron_aa: Now reading and writing the weight"<<endl);
		
		i_IntError=C_ListMan->read(S_Neuron->i_Weights,j,&weight);
		if(i_IntError==NO_ERROR)
		{
			weight+=input_all;
						
			DBG(cerr<<"Neuron_aa: New weight "<<j-1<<" of Neuron "
				<<S_Neuron->i_Neuro_Nr
				<<" is "<<weight<<endl);
			
			i_IntError=C_ListMan->write(S_Neuron->i_Weights,j,weight);
			if(i_IntError==NO_ERROR)
			{
			}
			else
			{
				error(i_IntError);
				return i_IntError;
			}
		}
		else
		{
			error(i_IntError);
			return i_IntError;
		}
		
		
		
	} /* Here ends the for-loop for each weight */
	DBG(cerr<<"Neuron_aa: End of the for-loop over each weight in Neuron "
		<<S_Neuron->i_Neuro_Nr<<endl);
	/*Now we test whether one weight is greater than 1e+100, in this case
	  it must be divided*/
	/*for(int i=1;i<S_Neuron->i_WeightCnt;i++)
	{
		i_IntError=C_ListMan->read(S_Neuron->i_Weights,i,&HelpWeight);
		if(i_IntError!=NO_ERROR)
		{
			error(i_IntError);
			return i_IntError;
		}
		
		if(HelpWeight > MaxWeight)
		{
			MaxWeight=HelpWeight;
		}
	}
	if(MaxWeight >= 1e+100)
	{
		for(i=1;i<S_Neuron->i_WeightCnt;i++)
		{
			i_IntError=C_ListMan->read(S_Neuron->i_Weights,i,&HelpWeight);
			if(i_IntError!=NO_ERROR)
			{
				error(i_IntError);
				return i_IntError;
			}
			
			HelpWeight/=S_Neuron->i_WeightCnt;
			i_IntError=C_ListMan->write(S_Neuron->i_Weights,i,HelpWeight);
			if(i_IntError!=NO_ERROR)
			{
				error(i_IntError);
				return i_IntError;
			}
			
		}*/ /*This is the ending of the for-loop above*/
	/*}*/ /*This is the ending of the if>1e+100*/
	
		
	/* The first weight wi0 is always 1, I think */
	i_IntError=C_ListMan->write(S_Neuron->i_Weights,1,1);
	if(i_IntError!=NO_ERROR)
	{
		error(i_IntError);
		return i_IntError;
	}
	return i_IntError;
}


int
C_Neuron_aa::Check_Weights(ELEMTYPE i_Stop)
{

    int i_IntError=NO_ERROR,i_Result=0;
	ELEMTYPE HelpWeight=0;
	
	for(int i=1;(i<=S_Neuron->i_WeightCnt);i++)
	{
		i_IntError=C_ListMan->read(S_Neuron->i_Weights,i,&HelpWeight);
		if(i_IntError!=NO_ERROR)
		{
			error(i_IntError);
			return i_IntError;
		}
		if(HelpWeight>=i_Stop)
		{
			i_Result=1;
			return i_Result;
			
			break;
		}
	}
	return i_Result;
	
}

int
C_Neuron_aa::Change_Weights(ELEMTYPE divider)
{
	int i_IntError=NO_ERROR;
	ELEMTYPE HelpWeight=0;
	
	for(int i=2;i<=S_Neuron->i_WeightCnt;i++)
	{
		i_IntError=C_ListMan->read(S_Neuron->i_Weights,i,&HelpWeight);
		if(i_IntError!=NO_ERROR)
		{
			error(i_IntError);
			return i_IntError;
		}
		
		HelpWeight/=divider;
		i_IntError=C_ListMan->write(S_Neuron->i_Weights,i,HelpWeight);
		if(i_IntError!=NO_ERROR)
		{
			error(i_IntError);
			return i_IntError;
		}
	}
	return i_IntError;
}

				
	
/* It is the best you forget the following lines 
int 
C_Neuron_aa::Read_Help_Input_List(int number,ELEMTYPE *cont)
{
	int i_Error;
	
	DBG(cerr<<"Neuron_aa: Entering Read_Help_Input_List()"<<endl);
	i_Error=C_ListMan->read(i_Help_Input_List,number,cont);
	return i_Error;
}

int 
C_Neuron_aa::Write_Help_Input_List(int number,ELEMTYPE cont)
{
	int i_Error;
	
	DBG(cerr<<"Neuron_aa:  Entering Write_Help_Input_List()"<<endl);
	i_Error=C_ListMan->write(i_Help_Input_List,number,cont);
	return i_Error;
}
*/
