/*nnet_aa.cc
 
  Neural Network as class.

  Author: Ralf Schmidt
  Date:   14.10.1995 (creation)
  Time-stamp: <96/02/01 10:21:57 rsc> (last modification)

    BACKNET - A library for simulating neural BACKPROPAGATION-Networks
    Copyright (C) 1995	Ralf Schmidt

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


	If you have any suggestions, ideas or comments regarding this library
	feel free to contact me:

	Email:  rsc@informatik.th-zwickau.de
	Ordinary Mail:  Ralf Schmidt
	                Neuplanitzer Strasse 41
					D-08062 Zwickau
					Germany

	Email:	mme@pub.th-zwickau.de
	Ordinary Mail:	Marko Meyer
					Teichstrasse 27
					D-08289 Schneeberg
					Germany

    History:

	95/11/13 -- Ralf Schmidt: included in BACKNET sourcetree.
	
	95/12/{08,09} -- Marko Meyer: Fixed a problem with Take_Layer(...). 
	
	96/01/03 -- Ralf Schmidt: made limits for the parametres of Constructor
	                          and Init

*/

#include <stdlib.h>
#include <unistd.h>
#include <nnet_aa.h>

#define error(x)  (cerr<<"NNet_aa: The following error has occured: "\
					 <<x<<" !"<<endl)

C_NNet_aa::C_NNet_aa(float f_LearnR  /*Learning Rate.*/,
					 int i_SelfBackCuppling /*allowed or not?*/,
					 char *s_GWIName  /*Filename for GWI-file.*/)
:C_FNNet(1,f_LearnR,NO_BIAS,s_GWIName) /*Auto-associator has exactly 
											 one layer*/
{
	/* This is the constructor. It has to do a lot of very difficult jobs:
	   
	   - Initialization of the ListManager for the NetWeights.
	   - Initialization of the ListManager for the Layers.
	   - Initialization of some lists: LastErrList, OutList, ...
	   - Opening of the weightfiles.
	   - Initialization of all the Layers.

	   We are doing this with a lot of concentration, be aware!*/

	int i_IntError=NO_ERROR;
	DBG(cerr<<"NNet_aa: Entering constructor of NNet_aa ..."<<endl);
	
	/* Now the test start whether the params are correct */
	if((f_LearnR<=0)||(f_LearnR>=1))
	{
		DBG(cerr<<"NNet_aa: Unallowed value for f_LearnR: "<<f_LearnR<<endl);
		exit(1);
	}
	if((i_SelfBackCuppling!=SelfBackCuppling_Allowed)&&\
	   (i_SelfBackCuppling!=SelfBackCuppling_Denied))
	{
		DBG(cerr<<"NNet_aa: Unallowed value for i_SelfBackCuppling: "
			<<i_SelfBackCuppling<<endl);
		exit(1);
	}
	
	S_NNet = (S_NNet_Param *) new S_NNet_Param; /* mme 95/11/13 */
	
	S_NNet->i_SelfBackCuppling=i_SelfBackCuppling;
	error(i_IntError);
	
		
		
	DBG(cerr<<"NNet_aa: Leaving constructor with Error: "<<i_IntError<<endl);
}

int
C_NNet_aa::Init(int i_NeuCnt  /*Amount of neurons/layer.*/,
				int i_InitMode  /*InitMode for neurons.*/,
				int i_Minimum   /*Minimum for Hopfield-Activity-Function 
								  of neuron*/,
				int i_Maxsteps   /*Number of max. steps in Recall*/,
				ELEMTYPE i_Equal     /*For Recall: The differences between 
									   the Input-Values and the Output-Values
									   of each neuron is taken. If the highest
									   difference is less i_Equal, then all
									   is good.*/)
{
	int i_Error=NO_ERROR;
	S_Layer_Param *S_LastLayData=NULL;

	DBG(cerr<<"NNet_aa: Entering Init ..."<<endl);
	if(i_NeuCnt<1)
	{
		DBG(cerr<<"NNet_aa: Unallowed value for i_NeuCnt: "<<i_NeuCnt<<endl);
		exit(1);
	}
	if((i_InitMode!=INIT_FROM_GWI)&&(i_InitMode!=INIT_GV_0_1)&&\
	   (i_InitMode!=INIT_GV_N_P)&&(i_InitMode!=INIT_0)&&(i_InitMode!=INIT_1))
	{
		DBG(cerr<<"NNet_aa: Unallowed value for i_InitMode: "<<i_InitMode
			<<endl);
		exit(1);
	}
	if((i_Minimum!=0)&&(i_Minimum!=-1))
	{
		DBG(cerr<<"NNet_aa: Unallowed value for i_Minimum: "<<i_Minimum
			<<endl);
		exit(1);
	}
	if(i_Maxsteps<1)
	{
		DBG(cerr<<"NNet_aa: Unallowed value for i_Maxsteps: "<<i_Maxsteps);
		exit(1);
	}
	if(i_Equal<0)
	{
		DBG(cerr<<"NNet_aa: Unallowed value for i_Equal: "<<i_Equal);
		exit(1);
	}
	
	/*delete C_LayStor; Unfortunately this is must be done in the destructor
	  of C_NNet*/
	
	delete C_LayStor;
	C_LayStor=NULL;
	
	i_LastLayer=1;
	
	S_NNet->i_Minimum=i_Minimum;
		
	i_InputNeu=i_NeuCnt;
	i_OutputNeu=i_InputNeu;
	
	Maxsteps=i_Maxsteps;
	Equal=i_Equal;
	
	//i_OutputNeu=i_ArNeuCnt[i_LastLayer-1];
	
	/* First we count the Neurons ...*/

	if(i_NeuCnt)
	{
		i_NeuronCnt=i_NeuCnt;
	}
	else return ERR_ETYNAR_NET;
	DBG(cerr<<"NNet_aa: Counting Neurons gave: "<<i_NeuronCnt<<endl);
/**/
	/* Creating the lists: */
	i_Error=Create_Lists();
	DBG(cerr<<"NNet_aa: Back in the constructor. Error is: "<<i_Error<<endl);

	if(i_InitMode==INIT_FROM_GWI) i_Error=Open_GWI(s_Net_GWI);
	else i_Error=NO_ERROR;
	if(i_Error==NO_ERROR)
	{
		/*GWI-file has been correctly opened!*/
		/* Now it's time to initialise all the layers.*/
		
		DBG(cerr<<"NNet_aa: We initialize the layers!"<<endl);
		
		i_Error=Init_Layers(i_NeuCnt,f_LearnRate,
							i_InitMode,NO_BIAS);
				
		if(i_InitMode==INIT_FROM_GWI) I_GWI_File.close();
		/*Now we need some data from the last Layer for further use
		  in the NNet. */
		if(i_Error==NO_ERROR)
		{
			
				S_LastLayData=C_AktLayer->hand_lay_data();
				if(S_LastLayData)
				{
					i_OutList=S_LastLayData->i_Output_List;
					
				}
				else i_Error=ERR_LDREAD_NET;
			
		}
		/* Work has been done. */
	}
	return i_Error;
}

int C_NNet_aa::Create_Lists()
{
	int i_Error=NO_ERROR;
	
	C_FNNet::Create_Lists();
	C_ListMan->destroy(i_LastErrList);
	C_ListMan->destroy(i_LernOutList);
	
	return i_Error;
}


		

int C_NNet_aa::Open_GWI(char *s_Name)
{
	return C_FNNet::Open_GWI(s_Name);
}


int C_NNet_aa::Init_Layers(int i_NeuCnt,
						float f_LearnRate,int i_InitMode,int i_Bias)
{
	/* This one initializes all the layers. */

	
	int i_IntError=NO_ERROR;
	i_Bias=i_Bias;
	
	DBG(cerr<<"NNet_aa: Entering Init_Layers ..."<<endl);
	
	/* The amount of layers to be created is given  in the parameters
	   to the constructor. */
	C_AktLayer=(C_Layer_aa*)new C_Layer_aa(S_NNet,
										   C_NetLists,
										   i_NeuCnt,
										   i_InList,
										   f_LearnRate);
		
	if(!C_AktLayer) return ERR_MEMORY_NET;
	i_IntError=C_AktLayer->Init(i_InitMode, &I_GWI_File);
	if(i_IntError==NO_ERROR)
	{
					
	}
	else return i_IntError;
	
	DBG(cerr<<"NNet_aa: Leaving Init_Layers without errors."<<endl);
	/* Now we've got it! */
	return NO_ERROR;

}

int C_NNet_aa::Action(int i_Action,char *s_Name,int *i_Steps)
{
	return C_FNNet::Action(i_Action,s_Name,i_Steps);
}


int 
C_NNet_aa::Open_MST(char *s_Name, int *i_MST)
{
	return C_FNNet::Open_MST(s_Name,i_MST);
}

int
C_NNet_aa::Take_Layer(int i_Num)
{
	i_Num=0;
	return NO_ERROR;
}

int 
C_NNet_aa::learn()
{
	int i_IntError=NO_ERROR;
	
	/* Do a learning cycle. (Exactly one.) */
	/*Do a learn over all the layers. Remember the different count! */
	
	i_IntError=C_AktLayer->\
		Action(ACTN_LEARN);
	if(i_IntError!=NO_ERROR)
		error(i_IntError);
	return i_IntError;
}


int 
C_NNet_aa::Learn(char *s_Name,int *i_Steps,int i_MST)
{
	/* This one does the learning:
	   
	   - prepare a random order for the patterns to be learned
	   - and then, for all layers, for all learning steps:
	   - call Action of all the layers with 'Recall'.
	   - call Action of all the layers with 'Learn'. */

	int i_IntError=NO_ERROR;
	int *i_PatternArray;
	int i_AktStep;
	

	DBG(cerr<<"NNet_aa: Entering learn ..."<<endl);
	if(s_Name&&i_Steps)
	{
		/* Name and Steps exist, so let's begin. */
		/*Preparing the names...*/
		
		
		
		if(i_IntError==NO_ERROR)
		{
			/* Both files correctly opened. */
			/* Just now we have to find a random order for the 
			   patterns. This time I see the patterns as numbered
			   from 1 to i_MST (it should be the same as i_LRN_Cnt,
			   otherwise the program would never come to this point).*/

			i_PatternArray=(int*)new int[i_MST];
			if(i_PatternArray==NULL) return ERR_MEMORY_NET;
			for (int i=0;i<i_MST;i++) i_PatternArray[i]=i+1;

			/* Now we have to do the main-loop. 
			   It takes all patterns, runs over all learning steps or
			   until an error occures. */
			
			i_AktStep=*i_Steps;
			
			while((i_AktStep>0)&&(i_IntError==NO_ERROR))
			{
				/* At first: randomizing the patterns. */
				i_IntError=Randomize_Patterns(i_PatternArray,i_MST);
				if(i_IntError!=NO_ERROR) return i_IntError;
				
				/* Over all the patterns ...*/
				for(int i=0;(i<i_MST)&&(i_IntError==NO_ERROR);i++)
				{
					/*Load the MST-pattern ... */
					i_IntError=Load_Pattern\
						(LDPAT_MST,i_PatternArray[i]);
					
					if(i_IntError==NO_ERROR)
					{
						/* Do a recall over all layers. */
						recal();
						
						/* Load the LRN-DATA 
						   i_IntError=Load_Pattern\
						   (LDPAT_LRN,i_PatternArray[i]);
						   if(i_IntError==NO_ERROR)
						   {
						   
						   }
						   else return i_IntError;*/
						
						/* Do a learning step. */
						learn();
					}
					else return i_IntError;
				}
				/* At last: decrementing i_AktStep. */
				i_AktStep--;
			}	
		}
		else return ERR_NOOERR_NET;
		
	}
	else return ERR_NONAME_NET;

	DBG(cerr<<"NNet_aa: Leaving learn without errors!"<<endl);
	return NO_ERROR;
	/* This is the final point! */
}


int 
C_NNet_aa::Open_LRN(char *s_Name,int *i_LRN)
{
	return C_FNNet::Open_LRN(s_Name,i_LRN);
}

int 
C_NNet_aa::Open_ERR(char *s_Name)
{
	return C_FNNet::Open_ERR(s_Name);
}

int 
C_NNet_aa::Randomize_Patterns(int *i_PatArr,int i_MST)
{
	return C_FNNet::Randomize_Patterns(i_PatArr,i_MST);
}

int 
C_NNet_aa::Load_Pattern(int i_Where,int i_Num)
{
	return C_FNNet::Load_Pattern(i_Where,i_Num);
}

int 
C_NNet_aa::Detect_Error()
{
	int i_IntError=NO_ERROR;
	int k;
	S_Layer_Param *S_LayerData;
	
	ELEMTYPE input,output,Diff,Average=0;
		     
	
	
	S_LayerData=C_AktLayer->hand_lay_data();
		
	DBG(cerr<<"NNet_aa: Entering the loop over all "
		<<S_LayerData->i_Neuro_Cnt<<" values"<<endl);
						
							
	for(k=1;k<=S_LayerData->\
		i_Neuro_Cnt;k++)
	{
		/* read from HelpInputList of 
		   this layer and read
		   from outputlist of this layer and 
		   compare the
		   values, the highest difference is saved 
		   in MaxiDiff */
		i_IntError=C_ListMan->read(S_LayerData->\
								   i_Help_Input_List,k,
								   &input);
		if(i_IntError!=NO_ERROR)
		{
			error(i_IntError);
			return i_IntError;
		}
		
		i_IntError=C_ListMan->read(S_LayerData->\
								   i_Output_List,k,
								   &output);
		if(i_IntError!=NO_ERROR)
		{
			error(i_IntError);
			return i_IntError;
		}
		
		
		Diff=fabs(input-output);
		DBG(cerr<<"NNet_aa: Diff = "<<Diff<<endl);
		Average+=Diff;	
	}
	
	DBG(cerr<<"NNet_aa: Now we ended the loop over all values "
			<<endl);
		
	
	Average/=S_LayerData->i_Neuro_Cnt;
	MaxiDiff=Average;
	
	DBG(cerr<<"Neuron_aa: Average is "<<Average<<endl);
	return i_IntError;
}

int 
C_NNet_aa::Recall(char *s_Name,int i_MST)
{
	return C_FNNet::Recall(s_Name,i_MST);
}

int
C_NNet_aa::recal()
{
	
	int i_IntError=NO_ERROR;
	int j=1;
	int Maxcount;
	
		
	DBG(cerr<<"NNet_aa: Entering recal ..."<<endl);
	
	
	/* Do the recall. */
	if(i_Kind_Of_Action==ACTN_LEARN)
		MaxiDiff=1;
	else
		MaxiDiff=-1;

	if(i_Kind_Of_Action==ACTN_LEARN)
		Maxcount=1;
	else
		Maxcount=Maxsteps;
	
	
	while((j<=Maxcount)&&
		  (MaxiDiff>Equal))
	{
		i_IntError=C_AktLayer->Action(ACTN_RECAL);
		if(i_IntError!=NO_ERROR)
		{
			error(i_IntError);
			return i_IntError;
		}
		if (i_Kind_Of_Action==ACTN_RECAL)
			i_IntError=Detect_Error();
		if(i_IntError!=NO_ERROR)
			error(i_IntError);
		j++;
		
	}
	DBG(cerr<<"NNet_aa: Maximal difference was "<<MaxiDiff<<endl);
	return i_IntError;
			
}


int 
C_NNet_aa::Open_OUT(char *s_Name,int i_MST)
{
	return C_FNNet::Open_OUT(s_Name,i_MST);
}

int 
C_NNet_aa::Write_OUT()
{
	return C_FNNet::Write_OUT();
}

int 
C_NNet_aa::Save()
{
	return C_FNNet::Save();
}

int
C_NNet_aa::save()
{
	int i_Error=C_AktLayer->Save(&O_GWI_Save);
	if(i_Error!=NO_ERROR)
		error(i_Error);
	return i_Error;
}



C_NNet_aa::~C_NNet_aa()
{
	int i_RetVal=1;
	S_Layer_Param *S_LayerData;
	int i_Error=NO_ERROR;
	ELEMTYPE output,input;
	
	
	DBG(cerr<<"NNet_aa: Entering Destructor"<<endl);
	
	/*The destructor of the whole net saves the weights. */
	i_RetVal=Save();
	DBG(cerr<<"NNet_aa:  Destructing Layer "
		<<i_RetVal<<endl);
	S_LayerData=C_AktLayer->\
		hand_lay_data();
			
	for(int j=1;j<=S_LayerData->i_Neuro_Cnt;j++)
	{
		i_Error=C_ListMan->read(S_LayerData->i_Output_List,
								j,&output);
		if(i_Error!=NO_ERROR)
			DBG(cout<<"Error: "<<i_Error<<" when reading"
				<<" output "<<j<<endl);
		DBG(cerr<<"Output "<<j<<" = "<<output<<endl);
		i_Error=C_ListMan->read(S_LayerData->i_Input_List,
								j,&input);
		
		if(i_Error!=NO_ERROR)
			DBG(cout<<"Error: "<<i_Error<<" when reading"
				<<" input "<<j<<endl);
		DBG(cerr<<"Input "<<j<<" = "<<input<<endl);
		
	}
	if(S_LayerData) delete S_LayerData;
			
	if(C_AktLayer) delete C_AktLayer;
		
}
	
	
	
