/*
 * cccc.h 
 * diagnostic facilities for the cccc project
 */

#ifndef _CCCC_H__
#define _CCCC_H__

// OS dependencies
// the PC section is for DOS using the DJGPP development tools
// which are a port of GNU C etc to a 32 bit DPMI environment
// this implies that it will not run under vanilla DOS, although
// a DOS window in WfW3.11, OS/2, NT or Win95 should all be good
// enough

#ifdef PC

#define SIGNAL_HEADER <signal.h>
#define DEFAULT_LIBDIR "c:/cccc"

#else

#define SIGNAL_HEADER <sys/signal.h>
#define DEFAULT_LIBDIR "/usr/local/lib/cccc"

#endif


// standard include files
#include <iostream.h>
#include <fstream.h>
#include <strstream.h>
#include SIGNAL_HEADER
#include <unistd.h>
#include <stdlib.h>
#include <new.h>


// debugging facilities
extern int DebugMask;
enum DebugFlags { 
  LEXER=0x01, 
  PARSER=0x02, 
  COUNTER=0x04, 
  MEMORY=0x08,
  EXTENT=0x10,
  DATABASE=0x20
};
#define DbgMsg(DF,OS,X) if(DebugMask&DF) { OS << X ; }

// the global database to which stuff is added...
class CCCC_Project;
extern CCCC_Project *prj;

// a nasty global array of identifiers we want the lexer to ignore
#define SKIP_IDENTIFIERS_ARRAY_SIZE 256
extern char *skip_identifiers[SKIP_IDENTIFIERS_ARRAY_SIZE];
#if 0
#include "DLGLexer.h"
#endif

// GNU C++ has a bug in the constructor which builds an ostrstream on top of a
// preallocated buffer, while dynamic strstreams work correctly
// On DEC C++ for OSF, the preallocated version works, but a dynamic strstream
// can only be inserted onto once, as it does not flex if more is added after
// the first operation 

// the use of different classes implies a difference in the finalisation needs:
// the buffer of the dynamic stream will not be released unless a freeze(0) 
// call is issued before the stream object goes out of scope, while this method
// is not defined for the preallocated version
 
#ifdef __GNUG__

#define MAKE_STRSTREAM(X)     strstream X;
#define CONVERT_STRSTREAM(X)  (X)
#define RELEASE_STRSTREAM(X)  X.freeze(0);

#else

#define STR_BUFSIZE 1024

#define MAKE_STRSTREAM(X) \
  char auto_buf[STR_BUFSIZE]; \
  ostrstream X(auto_buf,STR_BUFSIZE, ios::trunc); 
#define CONVERT_STRSTREAM(X)  istrstream(X.str(),strlen(X.str()))
#define RELEASE_STRSTREAM(X) /* do nothing at all */

#endif // __GNUG__

#endif










