#ifndef __CCCC_HTM_H
#define __CCCC_HTM_H
#include <fstream.h>
#include <iomanip.h>
#include <time.h>

#include "cccc.h"
#include "cccc_stg.h"
#include "cccc_db.h"
#include "cccc_met.h"

enum ReportType { 
  rtCONTENTS=0x0001, rtSUMMARY=0x0002, 
  rtPROC1=0x0004, rtPROC2=0x0008,
  rtSTRUCT1=0x0010, rtSTRUCT2=0x0020,
  rtREJECTED=0x0100, 
  rtCCCC=0x8000 
};

class CCCC_Html_Stream {
    friend CCCC_Html_Stream& operator <<(
      CCCC_Html_Stream& os, const CCCC_String& stg);
    friend CCCC_Html_Stream& operator <<(
      CCCC_Html_Stream& os, const CCCC_Metric& mtc);

    ofstream fstr;
    CCCC_String libdir;
    CCCC_Project& prj;
    time_t time_generated;

    void Table_Of_Contents(int report_mask);
    void Project_Summary();
    void Procedural_Summary();
    void Procedural_Detail();
    void Structural_Summary();
    void Structural_Detail();
    void Rejected_Extents();

    void Put_Section_Heading(
    	const CCCC_String& section_name,const CCCC_String& section_tag,
    	int section_level);
    void Put_Section_TOC_Entry(
      const CCCC_String& section_name, const CCCC_String& section_href,
      const CCCC_String& section_description);

    void Put_Header_Cell(const CCCC_String& label, int width=0);
    void Put_Label_Cell(
      const CCCC_String& label, int width=0,
      const CCCC_String& ref_name="", const CCCC_String& ref_href="", 
      CCCC_Record *rec_ptr=0);
    void Put_Metric_Cell(const CCCC_Metric& metric, int width=0);
    void Put_Metric_Cell(int count, const CCCC_String& tag, int width=0);
    void Put_Metric_Cell(
      int num, int denom, const CCCC_String& tag, int width=0);
    void Put_Extent_URL(const CCCC_Extent& extent);
    void Put_Extent_Cell(const CCCC_Extent& extent, int width=0);
    void Put_Extent_List(CCCC_Record& record);
    void Put_Structural_Details_Cell(
      CCCC_Module *mod, CCCC_Project *prj, int mask, UserelNameLevel nl);
    void Include_Library_File(char *filename);
public:
    CCCC_Html_Stream(
      CCCC_Project& project, const char* fname, 
      int report_mask, const char* libdir=DEFAULT_LIBDIR);
};

CCCC_Html_Stream& operator <<(CCCC_Html_Stream& os, const CCCC_String& stg);
CCCC_Html_Stream& operator <<(CCCC_Html_Stream& os, const CCCC_Metric& mtc);
CCCC_Html_Stream& operator <<(CCCC_Html_Stream& os, const CCCC_Extent& ext);
   
#endif /* __CCCC_HTM_H */


