// Here are defined the basic controls such as button, scroller, ...

#ifndef CONTROL_H
#define CONTROL_H

#include "lge.h"
#include "messages.h"

// TButton : Simple square pushbutton

class TButton : public TObject
{
  public:
    char    *Title;
    FontPtr UsedFont;
    int     Style, Pressed, ID;

    TButton(int x, int y, char *title, FontPtr font, int style, int id);
    virtual ~TButton();

    virtual void Draw();
    virtual int  HandleEvent(int key);
    virtual void HandleMsg(int src, int msg, long param1, long param2);
    virtual void Activate();
    virtual void Desactivate();

  private:
    int     Actif;

    virtual void DrawI(int Pushed);
};

typedef TButton *PButton;

// TCheckBox : Checkmark toggle button

class TCheckBox : public TObject
{
  public:
    char    *Title;
    FontPtr UsedFont;
    int     Style, Pressed, ID;

    TCheckBox(int x, int y, char *title, FontPtr font, int style, int preset, int id);
    virtual ~TCheckBox();

    virtual void Draw();
    virtual int  HandleEvent(int key);
    virtual void HandleMsg(int src, int msg, long param1, long param2);
    virtual void Activate();
    virtual void Desactivate();

  private:
    int     Actif;

    virtual void DrawI(int checked, int grayed);
};

typedef TCheckBox *PCheckBox;

// TRadio : _ONE_ radio button (insert it in a TGroup)

class TRadio : public TObject
{
  public:
    char    *Title;
    FontPtr UsedFont;
    int     Style, Pressed, ID;

    TRadio(int x, int y, char *title, FontPtr font, int style, int preset, int id);
    virtual ~TRadio();

    virtual void Draw();
    virtual int  HandleEvent(int key);
    virtual void HandleMsg(int src, int msg, long param1, long param2);
    virtual void Activate();
    virtual void Desactivate();

  private:
    int     Actif;

    virtual void DrawI(int grayed);
};

typedef TRadio *PRadio;

// TGroup : Radio button group

class TGroup : public TObject
{
  public:
    char    *Title;
    FontPtr UsedFont;
    int     Style;
    PRadio  *Radios;
    int     NbRad;

    TGroup(int x, int y, int sizex, int sizey, FontPtr font, char *title,
    	   int style, int nbrad);
    virtual ~TGroup();

    virtual void AddButton(int index, PRadio rad);
    virtual void Draw();
    virtual int  HandleEvent(int key);
    virtual void Activate();
    virtual void Desactivate();
    virtual void GetCoords(int *X, int *Y);
    virtual int  GetContext();

  private:
    int     Actif;
};

typedef TGroup *PGroup;

// TEdit : Editable text zone

class TEdit : public TObject
{
  public:
    FontPtr UsedFont;
    char    *Text;
    int     MaxLength;

    TEdit(int x, int y, int size, FontPtr font, int max, char *preset);
    virtual ~TEdit();

    virtual void Draw();
    virtual int  HandleEvent(int key);
    virtual void HandleMsg(int src, int msg, long param1, long param2);
    virtual void Activate();
    virtual void Desactivate();

  private:
    int     Actif;
    int     ViewBegin, CurPos, Activ;
    
    virtual int SetCur();
};

typedef TEdit *PEdit;

// TStatic : Static text

class TStatic : public TObject
{
  public:
    FontPtr UsedFont;
    char    *Text;
    int	    Color;

    TStatic(int x, int y, FontPtr font, char *text, int col);
    virtual ~TStatic();

    virtual void Draw();
    virtual int  HandleEvent(int key);
    virtual void HandleMsg(int src, int msg, long param1, long param2);
};

typedef TStatic *PStatic;

// TScrollBar : "the OpenView scrollbar"

class TScroll : public TObject
{
  public:
    int Actif, PageStep, Step, Max, Min, CurPos;

    TScroll() {};
    virtual ~TScroll() {};

    virtual void Draw() {};
    virtual int  HandleEvent(int key) { return 0; };
    virtual void Activate() {};
    virtual void Desactivate() {};

    virtual void SetPos(int pos) {};
    virtual void SetParam(int pgstep, int step, int max, int min, int pos) {};
};

typedef TScroll *PScroll;

class TVScrollBar : public TScroll
{
  public:
    TVScrollBar(int x, int y, int size);
    virtual ~TVScrollBar();

    virtual void Draw();
    virtual int  HandleEvent(int key);
    virtual void HandleMsg(int src, int msg, long param1, long param2);
    virtual void Activate();
    virtual void Desactivate();

    virtual void SetPos(int pos);
    virtual void SetParam(int pgstep, int step, int max, int min, int pos);
    
  private:
    virtual void DrawI(int but);
    virtual void AButton(int who);
    virtual void EButton(int who);
    virtual void Drag();
};

typedef TVScrollBar *PVScrollBar;

class THScrollBar : public TScroll
{
  public:
    THScrollBar(int x, int y, int size);
    virtual ~THScrollBar();

    virtual void Draw();
    virtual int  HandleEvent(int key);
    virtual void HandleMsg(int src, int msg, long param1, long param2);
    virtual void Activate();
    virtual void Desactivate();

    virtual void SetPos(int pos);
    virtual void SetParam(int pgstep, int step, int max, int min, int pos);
    
  private:
    virtual void DrawI(int but);
    virtual void AButton(int who);
    virtual void EButton(int who);
    virtual void Drag();
};

typedef THScrollBar *PHScrollBar;

#define SB_VERTICAL   1
#define SB_HORIZONTAL 2

class TScrollBar : public TScroll
{
  public:
    PScroll Scroller;

    TScrollBar(int direction, int x, int y, int size);
    virtual ~TScrollBar();

    virtual void Draw();
    virtual int  HandleEvent(int key);
    virtual void HandleMsg(int src, int msg, long param1, long param2);
    virtual int  GetRessourceID();
    virtual void Activate();
    virtual void Desactivate();

    virtual int  GetPos();
    virtual void SetPos(int pos);
    virtual void SetParam(int pgstep, int step, int max, int min, int pos);
};

typedef TScrollBar *PScrollBar;

// TListItem : Listbox item

class TListBox;

class TListItem : public TObject
{
  public:
    int      Selected, Style;
    char     *Title;
    TListBox *Parent2;
    FontPtr  UsedFont;

    TListItem(char *title, FontPtr font, int style);
    virtual ~TListItem() {};

    virtual void Draw();
    virtual int  HandleEvent(int key);
    virtual void Activate();
    virtual void Desactivate();
    virtual int  GetHeight();
    
  private:
    int Actif;
};

typedef TListItem *PListItem;

class TListBox : public TObject
{
  public:
    PListItem  *Items;
    int        NbItems;
    PScrollBar Scroller;

    TListBox(int x, int y, int sizex, int sizey, int nbitems);
    virtual ~TListBox();

    virtual void Draw();
    virtual int  HandleEvent(int key);
    virtual void HandleMsg(int src, int msg, long param1, long param2);
    virtual void GetCoords(int *X, int *Y);
    virtual int  GetFocus();
    virtual int  GetSize();
    virtual int  GetContext();
    virtual void Activate();
    virtual void Desactivate();

    virtual void AddItem(PListItem item);
    virtual int  GetItemByName(char *title);
    virtual int  ItemPressed(int index);
};

typedef TListBox *PListBox;

#endif
