// Dis iz da testing machine
// What do u want ? I write a novel ? ;)

#define ID_EDITSTATE	0x100
#define	ID_QUITBUTTON	0x101

#include "lge.h"                        // Light speed engine
#include "dialog.h"
#include "control.h"                    // Stuffs you can play with
#include "special.h"                    // Overkewlz gadgets

PWindow      Win1, Win2, Win3;
PClient      Cli1, Cli2, Cli3;
PStatic	     Copy, Info;
PEdit	     Edit;
PButton      DaDeathBomb;
PCheckBox    chk1;
P3d	     DaWorld;
PRadio	     rad1, rad2, rad3;
PGroup	     rad;
PListBox     lst1;

PMenu	     NMn1, NMn2, SMn1;
PMenuItm     MnI1, MnI2;
PItem	     SMI1;
PMenuBar     MBar;

class TQuitDialog : public TDialog
{
  public:
    PClient Client;
    PButton Yes, No;
    PStatic QuitMsg;

    TQuitDialog();
    virtual ~TQuitDialog();

    virtual int  HandleEvent(int key);
    virtual void HandleMsg(int src, int msg, long param1, long param2);
};

class TApplication : public TDesk
{
  public:
    TApplication(int res, char *layout) : TDesk(res, layout) {};

    virtual void HandleMsg(int src, int msg, long param1, long param2);
};

typedef TApplication *PApplication;

#define ID_YES	0x200
#define ID_NO	0x201

TQuitDialog::TQuitDialog():
  TDialog(GetMaxX()/2-65, GetMaxY()/2-40, 130, 81, "Quit ?", TRUE)
{
  Client  = new TClient(FALSE, 0, NULL);
  QuitMsg = new TStatic(11, 7, SmallFont, "Really Quit ?", BLACK);
  Yes	  = new TButton(10, 25, "  Yes  ", SmallFont, st_Normal, ID_YES);
  No	  = new TButton(20+Yes->SizeX, 25, "   No   ", SmallFont, st_Normal, ID_NO);
  NewClient(Client);
  Client->AddObject(QuitMsg);
  Client->AddObject(Yes);
  Client->AddObject(No);
}

TQuitDialog::~TQuitDialog()
{
  delete QuitMsg;
  delete Yes;
  delete No;
  delete Client;
}

int TQuitDialog::HandleEvent(int key)
{
  int Result = TDialog::HandleEvent(key);
  if (No->Pressed)
    return msg_Destroy;
  else
    return Result;
}

void TQuitDialog::HandleMsg(int src, int msg, long param1, long param2)
{
  if ((msg == PUSHBUTTON_PRESSED) && (param1 == ID_YES))
    LGE->term = TRUE;
}

void TApplication::HandleMsg(int src, int msg, long param1, long param2)
{
  if ((msg == CHECKBOX_NEWSTATE) && (param1 == ID_EDITSTATE))
    SendMessage(Ressource, Edit->GetRessourceID(),
		(param2 == TRUE) ? OBJECT_ACTIVATE : OBJECT_DESACTIVATE,
		0, 0);
  if ((msg == PUSHBUTTON_PRESSED) && (param1 == ID_QUITBUTTON))
    LGE->AddObject(new TQuitDialog());
  if (msg == MENU_SELECTED)
    switch (param1) {
      case 0x0:
	PutString(SmallFont, Win3->pX+8, Win3->pY+30, "Inactive item! (0x00)",
		  BLACK, st_Normal, Win3->GetContext());
	break;
      case 0x123:
	PutString(SmallFont, Win3->pX+8, Win3->pY+44, "Active item! (0x123)",
		  BLACK, st_Bold, Win3->GetContext());
    }
}

// Build the stuffs and start
PApplication View;

void main(int argc, char **argv)
{
  char ch;
  int  Count;

  if (argc < 2) {
    printf("usage: %s <1|2|3>\n\n", argv[0]);
    exit(0);
  }

  if (!strcmp(argv[1], "1"))
    ch = '1';
  if (!strcmp(argv[1], "2"))
    ch = '2';
  if (!strcmp(argv[1], "3"))
    ch = '3';
  switch (ch) {
    case '1':  View = new TApplication(res_640,  "key.US"); break;
    case '2':  View = new TApplication(res_800,  "key.US"); break;
    case '3':  View = new TApplication(res_1024, "key.US");
  }
  if (!View) {
    printf("\nLamah...\n");
    exit(0);
  }

  for (Count=1; Count <= 239; Count++)
#ifndef __GO32__
    vga_setpalette(Count+16, 0, 15+63*Count/240, 15+63*Count/240);
#else
    GrSetColor(Count+16, 0, 15+Count, 15+Count);
#endif

  Win1 = new TWindow(50, 50, 300, 213, "Multi-client Window");
  Win2 = new TWindow(100, 350, 250, 200, "Mono-client Window");
  Win3 = new TWindow(400, 150, 250, 150, "No-client Window");

  Cli1 = new TClient(TRUE, 20, "Control demo");
  Cli2 = new TClient(TRUE, 80, "General Informations");
  Cli3 = new TClient(FALSE, 0, "LiGrEn 97...");

  Info = new TStatic(10, 3, SmallFont,
		     "&B&UAdditional informations about LGE&U&B&&&&" \
		     "Control's font and style can be changed at&&" \
		     "or run time. LGE's applications can also&&" \
		     "be DOS compiled with the DJGPP port of LGE&&" \
		     "without &B_any_ character change !&B&&" \
		     "Thanks to Nicolas for that&&" \
		     "&&                                   Antoine", BLACK);

  Copy = new TStatic(10, 3, SmallFont,
		     "&BLinux Graphic Environment&B&&" \
		     "&U(c) 1996-97 by Antoine & Nicolas&U", RED);

  DaDeathBomb = new TButton(10, 33, "Bomb o' death", SmallFont, st_Normal, ID_QUITBUTTON);

  Edit = new TEdit(100, 35, 180, SmallFont, 70,
                   "This is editable text but I'm sure you noticed that :)");

  lst1 = new TListBox(150, 61, 100, 87, 20);
  char **titles = (char**)malloc(sizeof(char*)*20);
  for(int i=0; i < 20; i++) {
    titles[i] = (char*)malloc(13);
    sprintf(titles[i], "Item n.%i", i);
    lst1->AddItem(new TListItem(titles[i], SmallFont, st_Normal));
  }

  chk1 = new TCheckBox(10, 63, "Check box", SmallFont, st_Normal, TRUE, ID_EDITSTATE);

  DaWorld = new T3d(10, 30, 150, 130, BLACK, "lge.asc", .5);
  View->AddTask(DaWorld);

  rad1 = new TRadio(3, 0, "Radio button one", SmallFont, st_Normal, TRUE, 0x0);
  rad2 = new TRadio(3, 15, "Radio button two", SmallFont, st_Normal, FALSE, 0x0);
  rad3 = new TRadio(3, 30, "Radio button three", SmallFont, st_Normal, FALSE, 0x0);
  rad  = new TGroup(10, 80, 120, 60, SmallFont, "Group", st_Normal, 3);
  rad->AddButton(0, rad1);
  rad->AddButton(1, rad2);
  rad->AddButton(2, rad3);

  NMn1 = new TMenu(0, 0, "LGE");
  NMn2 = new TMenu(0, 0, NULL);
  NMn1->AddItem(new TItem(SmallFont, st_Normal, "Menu item", 0x0));
  NMn1->AddItem(new TItem(SmallFont, st_Normal, NULL, 0x0));
  NMn1->AddItem(new TItem(SmallFont, st_Normal, "in a menu bar", 0x0));
  SMn1 = new TMenu(0, 0, "...");
  SMn1->AddItem(new TItem(SmallFont, st_Normal, "Infinite", 0x0));
  SMn1->AddItem(new TItem(SmallFont, st_Normal, "recursion...", 0x0));
  SMn1->AddItem(new TItem(SmallFont, st_Normal, NULL, 0x0));
  SMn1->AddItem(new TItem(SmallFont, st_Normal, "Activ item", 0x123));
  SMI1 = new TItem(SmallFont, st_Normal, "Sub Menu Item", 0x0);
  SMI1->SetChild(SMn1);
  NMn1->AddItem(SMI1);
  NMn2->AddItem(new TItem(SystemFont, st_Normal, "Free font", 0x0));
  NMn2->AddItem(new TItem(SmallFont, st_Bold, "Free style :)", 0x0));
  MnI1 = new TMenuItm(SmallFont, st_Normal, "Menu 1", 0x0);
  MnI2 = new TMenuItm(SmallFont, st_Normal, "Menu 2", 0x0);
  MnI1->SetMenu(NMn1);
  MnI2->SetMenu(NMn2);
  MBar = new TMenuBar(5, 5);
  MBar->AddItem(MnI1);
  MBar->AddItem(MnI2);

  Cli1->AddObject(Copy);
  Cli1->AddObject(DaDeathBomb);
  Cli1->AddObject(Edit);
  Cli1->AddObject(chk1);
  Cli1->AddObject(rad);
  Cli1->AddObject(lst1);
  Cli2->AddObject(Info);
  Cli3->AddObject(MBar);
  Cli3->AddObject(DaWorld);

  Win1->NewClient(Cli1);
  Win1->NewClient(Cli2);
  Win2->NewClient(Cli3);

  View->AddObject(Win3);
  View->AddObject(Win2);
  View->AddObject(Win1);

  View->Run();
  delete View;
}

