/* Declare les fonctions vitales du sous-systeme video.
 * Gere les contextes virtuels, les fonctions graphiques
 * contextuelles de base, la souris et les polices... Mortel :) */

#ifndef VIDEO_H
#define VIDEO_H

#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <string.h>
#include "keyboard.h"

#ifndef __GO32__

#include <vga.h>
#include <vgamouse.h>
#define MOUSE_MOVE	0x08

#else

#include <grx20.h>
#include "mouse.h"

#endif

typedef unsigned char byte;

typedef struct
{
  int           x1, y1, x2, y2;
} TZone;

typedef struct
{
  byte  lx, ly, pcx, pcy; // pcx and pcy are the relative positions of the cursor
  byte *mask;
} TCursor;

typedef struct
{
  byte Actif, SizeX, SizeY;
  byte *Motif;
} FontEntry;

typedef FontEntry Font[255];
typedef Font	  *FontPtr;

#define NB_MAX_ZONE     64
#define NB_MAX_CURS     8

extern	TZone	*Zones[NB_MAX_ZONE];
extern	int	Res;
extern  int	ClipX1, ClipY1, ClipX2, ClipY2;
extern	int	PosX, PosY;

extern  TCursor *Cursors[NB_MAX_CURS];
extern  int     NbCurs;
extern  int     CurrCurs;
extern  int     Show;

#define Curs_lx   Cursors[CurrCurs]->lx
#define Curs_ly   Cursors[CurrCurs]->ly
#define Curs_pcx  Cursors[CurrCurs]->pcx
#define Curs_pcy  Cursors[CurrCurs]->pcy
#define Curs_mask Cursors[CurrCurs]->mask

#define max(a,b)        (((a) > (b)) ? (a) : (b))
#define min(a,b)        (((a) < (b)) ? (a) : (b))

#define res_640		0
#define res_800		1
#define res_1024	2

#ifndef _cplusplus

#define BLACK		0
#define BLUE		1
#define GREEN		2
#define CYAN		3
#define RED		4
#define MAGENTA		5
#define BROWN		6
#define LIGHTGRAY	7
#define DARKGRAY	8
#define LIGHTBLUE	9
#define MIDDLEGRAY	10
#define LIGHTCYAN	11
#define LIGHTRED	12
#define LIGHTMAGENTA	13
#define YELLOW		14
#define WHITE		15

#endif

#define st_Normal	0
#define st_Bold		1
#define st_Italic	2
#define st_Underlined	4
#define st_Vertical	8

#define MOUSE_EVENT	1
#define KEY_EVENT	2

void InitVirt();
void SetClipping(int x1, int y1, int x2, int y2);
int  AddZone(int x1, int y1, int x2, int y2);
int  DelZone(int handle);
int  ActiveZone(int handle);
void MoveZone(int handle, int dX, int dY);
void ResizeZone(int handle, int dX, int dY);
void PutPixel(int x, int y, int c, int handle);
void HLine(int x, int x2, int y, int c, int handle);
void VLine(int x, int y1, int y2, int c, int handle);
void Bar(int x1, int y1, int x2, int y2, int c, int handle);
void Rectangle(int x1, int y1, int x2, int y2, int c, int handle);
void Phantom(int x1, int y1, int x2, int y2);
void Line(int x1, int y1, int x2, int y2, int c, int handle);
void InitVideo(int res, char *layout);
void DoneVideo();
int  GetMaxX();
int  GetMaxY();

int  LoadFont(char *Name, FontPtr font);
void ResetFont(FontPtr font);
void InitFont(FontPtr font);
void PutChar(FontPtr font, int x, int y, unsigned char Car, int Couleur, int Style, int handle);
void PutString(FontPtr font, int x, int y, char *Chaine, int Couleur, int Style, int handle);
void Print(FontPtr font, int x, int y, char *Chaine, int Couleur, int handle);

int  loadcursor(char *file);
void setcursor(int nb);
void SaveMouse(int x, int y);
void RestoreMouse(int x, int y);
void DrawMouse(int x, int y);
void ShowMouse();
void HideMouse();
void MoveMouse(int x, int y);
int  WaitEvent(int event_type);
int  UpdateEvent();

#endif