//  libeasy, C++ library to encapsulate things and make life easy.
//  Copyright (C) 2000 Hans Dijkema 
//
//  This program/library is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License as published 
//  by the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program/library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program/library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// This software is maintained by Hans Dijkema.
// See the Makefile.lsm for your primary and secundary site. 
// email me at hnmdijkema@softhome.net
//
#ifndef _H_ARRAY
#define _H_ARRAY

#ifdef WIN32
#include <vc6.hxx>
#endif

#include <stdlib.h>
#include <herror.hxx>


#define HSARRAY_INIT	10

//doc
// library : libeasy.a
// module  : harray
// include : harray.hxx
// link    : -leasy
//
// Versie Wie              Datum       Wijziging/Opdracht/Omschrijving
// --------------------------------------------------------------------------
// 1.00   HNM Dijkema      27-12-1999  Algemeen bruikbare library ten behoeve
//                                     van C++ projecten.
//h2 Revisies
// Versie Revisieinformatie
// --------------------------------------------------------------------------
// 1.00   Initiele versie
//
//end

//sec
//h1 Classes en functies

//h2 template <class T> class harray
//
// class harray implementeert een generieke array class, welke
// als een normale array benaderd kan worden, maar zichzelf automatisch
// aanpast aan de indexering. Met andere woorden, van te voren hoeft
// de grootte van de array niet aangegeven te worden. Tijdens het
// gebruik groeit de array vanzelf.
//
// Verder is er extra functionaliteit in de vorm van een insert
// en een remove functie (zie verderop).
//
// hsarray<T> doet hetzelfde als harray<T>, maar is efficienter met
// simple types, zoals pointers, integers en doubles. Gebruik hsarray<T>
// altijd, indien T <- {t *,int,double,long,float,enum...,char,char *}.
// Bij structures/classes moet worden afgewogen in hoeverre dit nodig is.
//
//end

template <class T> class harray
{
  private:
    T   **array;
    int   N,LN;
  private:
    void cleanup(void) { int i;
      for(i=0;i<N;i++) {
        if (array[i]!=NULL) { delete array[i]; }
      }
      delete array;
      LN=N=0;array=NULL;
    }

    void resize(int i) 
    {
     T **A=array;
     int c,n=i*2+1;

#ifdef WIN32
	   array=(T **) malloc(sizeof(T *) *n);
#else
       array=new (T *)[n];
#endif

       if (array==NULL) { THROW_FATAL("Out of memory resizing array"); }
       for(c=0;c<N;c++) { array[c]=A[c]; }
       for(c=N,N=n;c<N;c++) { array[c]=NULL; }
       if (A!=NULL) { delete A; }
    }
  public:
//def
    harray() 
    { LN=N=0;array=NULL; }
//
//    pre : -
//    post: er is een lege array geconstrueerd.
//end
//def
   ~harray() 
    { cleanup(); }
//
//    pre : 
//    post: de array is opgeruimd.
//    opm.:
//
//    Indien er een array wordt geconstrueerd van pointers, dan
//    dienen de array elementen (indien nodig) voor het opruimen
//    van de array opgeruimd te worden. Bijvoorbeeld:
//
//    int main()
//    { harray<char *> A;
//      char *s,num[10];
//      int i,N;
//         for(i=0;i<20;i++) {
//           sprintf(num,"%d",i);
//           s=strdup(num);
//           A[i]=s;		// of A[i]=strdup(num);
//         }
//         ...
//         for(i=0,N=A.len();i<N;i++) { delete A[i]; }
//    }
//end
  public:
//def
    void swap(int i,int j) 
    { T *h=array[i];
      array[i]=array[j];
      array[j]=h;
    }
//
// pre : 0 <= i,j < len()
// post: elementen i en j zijn omgedraaid
//end
//def
    int len(void) 	
    { return LN; }
    int length(void) 	
    { return LN; }
//
//    pre : -
//    post: =huidige lengte van de array
//end
  public:
//def
    void operator =(harray<T> & A) 
//
//    pre : A is een bestaande array.
//    post: A is gekopieerd in deze array; d.w.z.
//          for(i=0;i<A.len();i++) { (*this)[i]=A[i]; }
//    opm.:
//
//       Indien A[i] pointers bevat, zoals boven beschreven,
//       dan wordt daarvan dus geen kopie gemaakt! Wel van de
//       pointers zelf, maar niet van het geheugen waar ze naar
//       wijzen.
//end
    {int i,l;
      cleanup();
      for(i=0,l=A.len();i<l;i++) {
        (*this)[i]=A[i];
      }
    }
  public:
//def
    void insert(int I,T & v) 
//
//    pre: I>=0 en v is een valide variabele T
//    post: op positie I is v geinsert. Alle elementen van positie
//          I t/m len() zijn 1 plaats opgeschoven en len() is len()
//          +1.
//end
    {int i;
      if (I>=len()) {
        (*this)[I]=v;
      }
      else {
        if (len()==N) { resize(len()+1); }
        for(i=len();i>I;i--) {
          array[i]=array[i-1];
        }
        array[i]=NULL;
        (*this)[i]=v;
        LN+=1;
      }
    }
  public:
//def
    T & operator [](int i) 
//
//    pre:  i>=0
//    post: Element i van de array is gealloceerd en 
//          een reference naar het element is teruggegeven.
//    opm.: Het teruggeven van een reference maakt zowel de constructie 
//          A[i]=10 als de constructie S=A[i] mogelijk.
//end
    {
      //if (i<0) THROW_FATAL("Index out of range (<0)");
      if (i>=N) { resize(i); }
      if (array[i]==NULL) {
        array[i]=new T;
        if (array[i]==NULL) {THROW_FATAL("Out of memory allocating element"); }
      }
      if (i>=LN) { LN=i+1; }
      return array[i][0];
    }
  public:
//def
    void initialize(void)   
    { cleanup(); }
    void reinitialize(void) 
    { cleanup(); }
//
//    pre : -
//    post: de array is opgeruimd.
//    opm.: Hiervoor geldt dezelfde opmerking als bij ~harray().
//end 
  protected:
    void decrease(int n=1)  { LN-=n; }
};

//sec
//h2 template <class T> class hsarray
// class hsarray, doet hetzelfde als harray, maar moet gebruikt
// worden voor eenvoudige types, zoals kleine structs, int's, double's,
// en pointers. Daarvoor is deze class veel efficienter dan harray.
//end

template <class T> class hsarray
{
  private:
    T    *array;
    int   N,LN;
  private:
    void cleanup(void) { 
      delete array;
      LN=N=0;array=NULL;
    }

    void resize(int i) 
    {
     T *A=array;
     int c,n=i*2+1;
       array=new T[n];
       if (array==NULL) { THROW_FATAL("Out of memory resizing array"); }
       for(c=0;c<N;c++) { array[c]=A[c]; }
       N=n;
       if (A!=NULL) { delete A; }
    }
  public:
//def
    hsarray() 
    { LN=N=0;array=NULL;resize(HSARRAY_INIT); }
//
//    pre : -
//    post: er is een lege array geconstrueerd.
//end
//def
   ~hsarray() 
    { cleanup(); }
//
//    pre : 
//    post: de array is opgeruimd.
//    opm.:
//
//    Indien er een array wordt geconstrueerd van pointers, dan
//    dienen de array elementen (indien nodig) voor het opruimen
//    van de array opgeruimd te worden. Bijvoorbeeld:
//
//    int main()
//    { hsarray<char *> A;
//      char *s,num[10];
//      int i,N;
//         for(i=0;i<20;i++) {
//           sprintf(num,"%d",i);
//           s=strdup(num);
//           A[i]=s;		// of A[i]=strdup(num);
//         }
//         ...
//         for(i=0,N=A.len();i<N;i++) { delete A[i]; }
//    }
//end
  public:
//def
    void swap(int i,int j) 
    { T h=array[i];
      array[i]=array[j];
      array[j]=h;
    }
//
// pre : 0 <= i,j < len()
// post: elementen i en j zijn omgedraaid
//end
//def
    int len(void) 	
    { return LN; }
    int length(void) 	
    { return LN; }
//
//    pre : -
//    post: =huidige lengte van de array
//end
  public:
//def
    void operator =(hsarray<T> & A) 
//
//    pre : A is een bestaande array.
//    post: A is gekopieerd in deze array; d.w.z.
//          for(i=0;i<A.len();i++) { (*this)[i]=A[i]; }
//    opm.:
//
//       Indien A[i] pointers bevat, zoals boven beschreven,
//       dan wordt daarvan dus geen kopie gemaakt! Wel van de
//       pointers zelf, maar niet van het geheugen waar ze naar
//       wijzen.
//end
    {int i,l;
      cleanup();
      for(i=0,l=A.len();i<l;i++) {
        (*this)[i]=A[i];
      }
    }
//def
    void operator =(harray<T> & A) 
//
//    pre : A is een bestaande array.
//    post: A is gekopieerd in deze array; d.w.z.
//          for(i=0;i<A.len();i++) { (*this)[i]=A[i]; }
//    opm.:
//
//       Indien A[i] pointers bevat, zoals boven beschreven,
//       dan wordt daarvan dus geen kopie gemaakt! Wel van de
//       pointers zelf, maar niet van het geheugen waar ze naar
//       wijzen.
//end
    {int i,l;
      cleanup();
      for(i=0,l=A.len();i<l;i++) {
        (*this)[i]=A[i];
      }
    }

  public:
//def
    void insert(int I,T & v) 
//
//    pre: I>=0 en v is een valide variabele T
//    post: op positie I is v geinsert. Alle elementen van positie
//          I t/m len() zijn 1 plaats opgeschoven en len() is len()
//          +1.
//end
    {int i;
      if (I>=len()) {
        (*this)[I]=v;
      }
      else {
        if (len()==N) { resize(len()+1); }
        for(i=len();i>I;i--) {
          array[i]=array[i-1];
        }
        (*this)[i]=v;
        LN+=1;
      }
    }
  public:
//def
    T & operator [](int i) 
//
//    pre:  i>=0
//    post: Element i van de array is gealloceerd en 
//          een reference naar het element is teruggegeven.
//    opm.: Het teruggeven van een reference maakt zowel de constructie 
//          A[i]=10 als de constructie S=A[i] mogelijk.
//end
    {
      //if (i<0) THROW_FATAL("Index out of range (<0)");
      if (i>=N) { resize(i); }
      if (i>=LN) { LN=i+1; }
      return array[i];
    }
  public:
//def
    void initialize(void)   
    { cleanup(); }
    void reinitialize(void) 
    { cleanup(); }
//
//    pre : -
//    post: de array is opgeruimd.
//    opm.: Hiervoor geldt dezelfde opmerking als bij ~harray().
//end 
  protected:
    void decrease(int n=1)  { LN-=n; }
};


template <class T>
void sort(harray<T> & A,bool decending=false,int l=-1,int h=-1)
{
  if (l==-1) { l=0;h=A.len(); }
  if ((h-l)<=1) { return; }
  else {int lm,hm;
    {int i=((h-l)>>1)+l,j,n=h-1;
       A.swap(i,n);
       T & An=A[n];
       if (decending) {
         for(i=j=l;i<n;i++) {
           if (A[i]>An) { A.swap(i,j);j+=1; }
         }
       }
       else {
         for(i=j=l;i<n;i++) {
           if (A[i]<An) { A.swap(i,j);j+=1; }
         }
       }
       hm=j;
       for(i=j;i<n;i++) {
         if (A[i]==An) { A.swap(i,j);j+=1; }
       }
       A.swap(j,n);
       lm=j+1;
    }
    sort(A,decending,lm,h);
    sort(A,decending,l,hm);
  }
}

template <class T>
void sort(hsarray<T> & A,bool decending=false,int l=-1,int h=-1)
{
  if (l==-1) { l=0;h=A.len(); }
  if ((h-l)<=1) { return; }
  else {int lm,hm;
    {int i=((h-l)>>1)+l,j,n=h-1;
       A.swap(i,n);
       T & An=A[n];
       if (decending) {
         for(i=j=l;i<n;i++) {
           if (A[i]>An) { A.swap(i,j);j+=1; }
         }
       }
       else {
         for(i=j=l;i<n;i++) {
           if (A[i]<An) { A.swap(i,j);j+=1; }
         }
       }
       hm=j;
       for(i=j;i<n;i++) {
         if (A[i]==An) { A.swap(i,j);j+=1; }
       }
       A.swap(j,n);
       lm=j+1;
    }
    sort(A,decending,lm,h);
    sort(A,decending,l,hm);
  }
}

template <class T>
void psort(hsarray<T> & A,bool decending=false,int l=-1,int h=-1)
{
  if (l==-1) { l=0;h=A.len(); }
  if ((h-l)<=1) { return; }
  else {int lm,hm;
    {int i=((h-l)>>1)+l,j,n=h-1;
       A.swap(i,n);
       T & An=A[n];
       if (decending) {
         for(i=j=l;i<n;i++) {
           if (A[i][0]>An[0]) { A.swap(i,j);j+=1; }
         }
       }
       else {
         for(i=j=l;i<n;i++) {
           if (A[i][0]<An[0]) { A.swap(i,j);j+=1; }
         }
       }
       hm=j;
       for(i=j;i<n;i++) {
         if (A[i][0]==An[0]) { A.swap(i,j);j+=1; }
       }
       A.swap(j,n);
       lm=j+1;
    }
    psort(A,decending,lm,h);
    psort(A,decending,l,hm);
  }
}

//sec
//h2 template <class T> class hstack : protected harray<T>
// class hstack implementeert een stapel met gebruik van harray.
//
//h3 Voorbeelden van gebruik:
//   int main()
//   { hstack<int> S;
//     int i;
//        for(i=0;i<10;i++) { S.push(i); }
//        while(S.depth()!=0) {
//          for(i=0;i<S.depth();i++) { printf("%d\n",S[i]); }
//          S.pop(i);
//        }
//   }
//
//end

template <class T> class hstack : protected harray<T>
{
  public:
//def
    void pop(T & e) 
    { 
      e=(*this)[0];
      decrease();
    }
//
//   pre:  er is een element op de stapel gepushed.
//   post: e=het 1e element van de stapel en de stapel is
//         1 element kleiner.
//end
//def
    void push(T & e) 
    { 
      (*this)[-1]=e;
    }
//
//    pre:  -
//    post: element e is op de stapel gepushed.
//end
  public:
//def
    T & operator [](int i) 
    {
      return harray::operator [](len()-(i+1));
    }
//
//    pre:  er zijn elementen op de stapel en 0<=i<depth()
//    post: =het i'de element van de stapel.
//    opm.: Deze functie maakt het mogelijk om elementen van
//          de stapel op te vragen en evt. te veranderen, zonder
//          ze van de stapel af te halen.
//end
  public:
//def
    int depth(void) 
    {
      return len();
    }
//
//    pre:  -
//    post: =het aantal elementen op de stapel.
//end
};

//sec
//h1 Verwijzingen
//    n.v.t.

//h1 Gegevensbenadering
//    n.v.t.

//h1 Voorbeeld programma(s)
//h2 harray/hsarray
//
//   #include <harray.hxx>
//   #include <stdio.h>
//   #include <string.hxx>
//   
//   void f(void);
//
//   int main()
//   {
//    hsarray<int> int_array;  // simple typed array
//    int i;
//       for(i=0;i<100;i++) { int_array[i]=i*i; }
//       for(i=0;i<100;i++) { printf("%d %d\n",i,int_array[i]); }
//       f();
//   }
//
//   void f(void)
//   {
//    string w="A";
//    harray<string> A;
//    int i;
//       for(i=0;i<10;i++) { 
//         A[i]=w;
//         w=w+w;
//       }
//   }

//end
#endif
