//  libeasy, C++ library to encapsulate things and make life easy.
//  Copyright (C) 2000 Hans Dijkema 
//
//  This program/library is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License as published 
//  by the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program/library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program/library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// This software is maintained by Hans Dijkema.
// See the Makefile.lsm for your primary and secundary site. 
// email me at hnmdijkema@softhome.net
//
#include <hdate.hxx>
#include <time.h>
#include <y2k.hxx>
#include <strext.hxx>

hdate::hdate()
{
struct tm *T;
time_t TT;
char m[100];
  TT=time(NULL);
  T=localtime(&TT);
  sprintf(m,"%04d%02d%02d",T->tm_year+1900,T->tm_mon+1,T->tm_mday);
  thedate=m;
  sprintf(m,"%02d%02d%02d",T->tm_hour,T->tm_min,T->tm_sec);
  thetime=m;
  set();
}

hdate::hdate(string dt,string tm)
{
  thedate=dt;
  thetime=tm;
  if (tm.length()==4) { tm+="00"; }
  set();
}

hdate::hdate(const char *dt, const char *tm)
{
  thedate=dt;
  thetime=tm;
  if (thetime.length()==4) { thetime+="00"; }
  set();
}

void hdate::set(void)
{
  if (thedate.length()==6) { y2k_bug(thedate,thedate); }
  _dd_mm_yyyy=thedate.substr(6,2)+"-"+ 
              thedate.substr(4,2)+"-"+ 
              thedate.substr(0,4);
  _hh_mm=thetime.substr(0,2)+":"+thetime.substr(2,2);
}

string hdate::dd_mm_yyyy(void)
{
return _dd_mm_yyyy;
}

string hdate::hh_mm(void)
{
return _hh_mm;
}

string hdate::yyyymmddhhmmss(void)
{
return thedate+thetime;
}

