//  libeasy, C++ library to encapsulate things and make life easy.
//  Copyright (C) 2000 Hans Dijkema 
//
//  This program/library is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License as published 
//  by the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program/library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program/library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// This software is maintained by Hans Dijkema.
// See the Makefile.lsm for your primary and secundary site. 
// email me at hnmdijkema@softhome.net
//
#ifndef __HDATE__HXX
#define __HDATE__HXX

#include <hstring.hxx>

class hdate
{
  friend bool operator < (const hdate & ,const hdate &);
  friend bool operator ==(const hdate & ,const hdate &);
  friend bool operator > (const hdate & ,const hdate &);
private:
   string thedate;
   string thetime;
private:
   string _dd_mm_yyyy,_hh_mm;
   void set(void);
public:
//def
   hdate();
//
// post: =systemdate/time
//end
//def
   hdate(string datein,string timein="000000");
   hdate(const char *datein,const char *timein="000000");
//
// pre : date of format (CC)YYMMDD
//       time of format HHMM(SS)
//end
public:
   string dd_mm_yyyy(void);
   string hh_mm(void);
   string yyyymmddhhmmss(void);
};

inline bool operator < (const hdate & c,const hdate & d) 
{ return (c.thedate==d.thedate) ? c.thetime<d.thetime : c.thedate<d.thedate; }
inline bool operator > (const hdate & c,const hdate & d) 
{ return (c.thedate==d.thedate) ? c.thetime>d.thetime : c.thedate>d.thedate; }
inline bool operator==(const hdate & c,const hdate & d) 
{ return (c.thedate==d.thedate) && (c.thetime==d.thetime); }

#endif
