//  libeasy, C++ library to encapsulate things and make life easy.
//  Copyright (C) 2000 Hans Dijkema 
//
//  This program/library is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License as published 
//  by the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program/library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program/library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// This software is maintained by Hans Dijkema.
// See the Makefile.lsm for your primary and secundary site. 
// email me at hnmdijkema@softhome.net
//
#include <stdio.h>
#include <hini.hxx>
#include <hstring.hxx>
#include <strext.hxx>
#include <string.h>
#include <ctype.h>

//sec
//h1 hini2sh
//h2 Doel
//  Dit programma converteert alle secties/identifiers van een .INI file
//  naar shell variabelen en print ze op de standaard uitvoer (stdout).
//  Op deze manier kunnen variabelen uit een .INI file gebruikt worden
//  in een shell script.
//
//h2 Voorbeeld:
/*
usage: hini2sh <.INI file> [--export]

  converts an .INI file to bourne shell assignments
  example with --export: 

     greet=Hi        --> _GREET="Hi";export _greet

     [eg]
     greet =  Hi     --> EG_GREET="Hi";export eg_greet
     a d=1           --> EG_A_D="1";export eg_a_d
     greet[1]=Hello  --> EG_GREET_1_="Hello";export eg_greet_1_

     [a:b]
     ccc=1           --> A_B_CCC=1;export a_b_ccc

"{}: []()|\/?*~`!@#$^+';.," in ids are converted to '_'

end*/

static void correctId(string & id);

int main(int argc,char *argv[])
{
string s,nm;
bool doExport=false;

try {
  if (argc==2) {
    s=argv[1];
    if (s=="--export") { 
      fprintf(stderr,"You need to give a filename\n");
      exit(12);
    }
    nm=s;
  }
  else if (argc==3) {
    s=argv[1];
    if (s=="--export") {
      nm=argv[2];
      doExport=true;
    }
    else {
      nm=argv[1];
      s=argv[2];
      doExport=s=="--export";
    }
  }
  else {
    fprintf(stderr,"usage: hini2sh <.INI file> [--export]\n"
                   "\n"
                   "  converts an .INI file to bourne shell assignments\n"
                   "  example with --export: \n"
                   "\n"
                   "     greet=Hi        --> _GREET=\"Hi\";export _greet\n"
                   "\n"
                   "     [eg]\n"
                   "     greet =  Hi     --> EG_GREET=\"Hi\";export eg_greet\n"
                   "     a d=1           --> EG_A_D=\"1\";export eg_a_d\n"
                   "     greet[1]=Hello  --> EG_GREET_1_=\"Hello\";export eg_greet_1_\n"
                   "\n"
                   "     [a:b]\n"
                   "     ccc=1           --> A_B_CCC=1;export a_b_ccc\n"
                   "\n"
                   "\"{}: []()|\\/?*~`!@#$%^+';.,\" in ids are converted to '_'\n"
           );

    exit(12);
  }

  hini   f((char *) nm.c_str(),true);
  int    i,N;
  string section,entry,id,value;

    for(i=0,N=f.numOfSections();i<N;i++) {
      section=f.section(i);

      entry=f.nextIdIsEntry();
      TakeWhileNotInSet(id,entry,"=");
      Trim(id,id);
      DropWhileNotInSet(value,entry,"=");
      Drop(value,value,1);
      Trim(value,value);

      correctId(id);
      correctId(section);

      while (entry!="") {
        printf("%s_%s=\"%s\"",section.c_str(),id.c_str(),value.c_str());
        if (doExport) {
          printf(";export %s_%s",section.c_str(),id.c_str());
        }
        printf("\n");

        entry=f.nextIdIsEntry();
        TakeWhileNotInSet(id,entry,"=");
        Trim(id,id);
        DropWhileNotInSet(value,entry,"=");
        Drop(value,value,1);
        Trim(value,value);
        correctId(id);
      }
    }
}
HERROR_CATCH

return 0;
}


static void correctId(string & id)
{
int i,N;
char *convertstring="{}: []()|\\/?*~`!@#$%^+';.,";
  for(i=0,N=id.length();i<N;i++) {
    if (strchr(convertstring,id[i])!=NULL) { id[i]='_'; }
    else {
      id[i]=toupper(id[i]);
    }
  }
}

