//  libeasy, C++ library to encapsulate things and make life easy.
//  Copyright (C) 2000 Hans Dijkema 
//
//  This program/library is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License as published 
//  by the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program/library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program/library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// This software is maintained by Hans Dijkema.
// See the Makefile.lsm for your primary and secundary site. 
// email me at hnmdijkema@softhome.net
//
#include <hlog.hxx>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#ifndef WIN32
#include <syslog.h>
#endif

static log_base *LOG=NULL;

log_base::log_base()
{
  prev=LOG;
  LOG=this;
  if (prev==NULL) { _debugLevel=0; }
  else { _debugLevel=prev->_debugLevel; }
}

log_base::~log_base()
{
  LOG=prev;
}

void log_base::debugLevel(int level)
{
  _debugLevel=level;
}

//*************************************************************************

void log_cerr::log(int ,char *format,va_list arg)
{
  vfprintf(stderr,format,arg);
  fprintf(stderr,"\n");
}

void log_cerr::__debug(int type,char *format,va_list arg)
{
  if (_debugLevel!=0) {
    fprintf(stderr,"debugging (type=%d): ",type);
    vfprintf(stderr,format,arg);
    fprintf(stderr,"\n");
  }
}

//*************************************************************************

#ifndef WIN32

log_syslog::log_syslog(char *prgname)
{
  openlog(prgname,LOG_PID,LOG_USER);
}

log_syslog::~log_syslog()
{
  closelog();
}

void log_syslog::log(int ,char *format,va_list arg)
{
char msg[4096];
  vsprintf(msg,format,arg);
  syslog(LOG_INFO,"%s",msg);
}

void log_syslog::__debug(int type, char *format,va_list arg)
{
  if (_debugLevel!=0) {char msg[4096],msg1[4096];
    vsprintf(msg,format,arg);
    sprintf(msg1,"debugging (type=%d): %s",type,msg);
    syslog(LOG_INFO,"%s",msg1);
  }
}

#endif
//*************************************************************************

void log(int type,char *format,...)
{
va_list arg;
  va_start(arg,format);
  if (LOG==NULL) {
    log_cerr l;
      l.log(type,format,arg);
  }
  else {
    LOG->log(type,format,arg);
  }
  va_end(arg);
}

void __debug(int type,char *format,...)
{
va_list arg;
  va_start(arg,format);
  if (LOG==NULL) {
    log_cerr l;
      l.__debug(type,format,arg);
  }
  else {
    LOG->__debug(type,format,arg);
  }
  va_end(arg);
}

bool debugOn(void) 
{
  if (LOG==NULL) {
    return false;
  }
  else {
    return LOG->debugOn();
  }
}


