//  libeasy, C++ library to encapsulate things and make life easy.
//  Copyright (C) 2000 Hans Dijkema 
//
//  This program/library is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License as published 
//  by the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program/library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program/library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// This software is maintained by Hans Dijkema.
// See the Makefile.lsm for your primary and secundary site. 
// email me at hnmdijkema@softhome.net
//
#ifndef __HREGEX__HXX
#define __HREGEX__HXX

#include <vc6.hxx>
#include <hmmap.hxx>

//h1  Algemene gegevens
//sec
//
// library : libeasy.a
// module  : hregex
// include : hregex.hxx
// link    : -leasy
//
// Versie Wie              Datum       Wijziging/Opdracht/Omschrijving
// --------------------------------------------------------------------------
// 1.00   HNM Dijkema      27-12-1999  Algemeen bruikbare library ten behoeve
//                                     van C++ projecten.
//
//h2 Revisies
//
// Versie Revisieinformatie
// --------------------------------------------------------------------------
// 1.00   Initiele versie.
//
//
//h1 Doel van de library
// Doel van library hregex is om een encapsulatie van de GNU reguliere
// expressie library te maken, zodat de complexiteit van het gebruik
// van reguliere expressies wegvalt. 
//
// Als een bouwer gebruik wil maken van reguliere expressies, dan moet
// hij/zij kunnen volstaan met het instantieren van een variabele van type
// hregex met een reguliere expressie, waarna de reguliere expressie direct
// klaar voor gebruik is voor het matchen op strings en files.
// Ook het opruimen van data die nodig is voor reguliere expressies
// moet automatisch gaan, bij destructie van de variabele.
//
//
//h2 Referenties
// Deze module maakt gebruik van GNU regex, versie 0.12 voor de 
// implementatie van functies die voor het zoeken van reguliere 
// expressies kunnen worden gebruikt. De GNU regex library wordt
// o.a. als deel van de GNU posix rx-1.5 library geleverd. Verder
// zij de sources te vinden op het internet (bijvoorbeeld op
// http://sunsite.unc.edu/pub/GNU/regex-0.12.tar.gz).
//
// Documentatie over reguliere expressies kan worden gevonden in 
// het boek "Compilers - Principles, Techniques and Tools" van 
// Alfred V. Aho, Ravi Sethi en Jeffrey D.Ullman. Verder zit er
// bij de regex library documentatie die kan worden gebruikt.
//
// Voor variabelen van type string wordt in principe de class string
// gebruikt, zoals meegeleverd bij de GNU Standard Template Libraries.
// Indien dit type niet voorhanden is, dan moet het gemaakt worden.
// Hiervoor is include string.hxx gemaakt, welke van meegeleverde string
// classes voor andere C++ compilers weer type string afleidt.
//
//h2 Implementatie keuzes
// Het compileren van een reguliere expressie kost relatief veel 
// tijd. Daarom wordt tijdens het gebruik van hregex variabelen
// een cache bijgehouden van de gebruikte reguliere expressies. 
// Deze reguliere expressies worden slechts 1 keer gecompileerd
// en daarna iedere keer opgezocht en hergebruikt. Hierdoor ontstaat
// een loskoppeling van instantiaties van variabelen van type hregex 
// en het compileren van de reguliere expressies en neemt de performance
// van de hregex class drastisch toe (praktijk: factor 10).
//
//end

#include <stdlib.h>
extern "C" {
#include <regex-0.12/regex.h>
}
#include <hstring.hxx>

//h2 Classes en functies
//def
class hregex
//
// Deze class vormt een encapsulatie van een library voor reguliere
// expressies. 
//
//end 
{
  private:
    bool                 _matched;
    re_pattern_buffer    *R;
    re_registers         regs;
    int                  cache_index;
    int                  _matches;
    int                  _flags;
  public:
//def
    hregex(string regex,int flags=RE_SYNTAX_POSIX_EXTENDED);
    hregex(char *regex=".",int flags=RE_SYNTAX_POSIX_EXTENDED);
    void newrx(char *regex,int flags=RE_SYNTAX_POSIX_EXTENDED);
    void newrx(string regex,int flags=RE_SYNTAX_POSIX_EXTENDED);
//
//    pre:  - De string regex is een reguliere expressie die voldoet
//            aan de syntax zoals gedocumenteerd bij library regex-0.12.
//          - De flags voldoen aan de flags zoals gedefinieerd bij
//            library regex-0.12. De default waarde voldoet meestal, soms
//            is het handig om de flags anders in te stellen. Beinvloed
//            wordt de manier van gebruik van de reguliere expressie.
//    post: variabele van type hregex is geinstantieerd en 
//          de juiste reguliere expressie is gecompileerd.
//
//end
//def
   virtual ~hregex();
//
//    pre:  -
//    post: dit object is opgeruimd. De gecompileerde reguliere expressie
//          blijft staan in de cache.
//    opm: deze destuctor is virtual, om ervoor te zorgen dat, indien
//         afgeleide classes van hregex worden gebruikt, als een pointer
//         naar hregex, de destructor van deze classes netjes wordt 
//         aangeroepen bij een delete van de hregex pointer.
//end
  public:
//def
    bool match(char *s,long start_at=0,int maxmatch=1,long maxLen=-1);
    bool match(string & s,long start_at=0,int maxmatch=1,long maxLen=-1);
    bool match(FILE *f,long start_at=0,int maxmatch=1,long maxLen=-1);
    bool match(int fh,long start_at=0,int maxmatch=1,long maxLen=-1);
//
//     pre:  s    - string om in te zoeken naar de eerste match van regex.
//           f/fh - file om in te zoeken naar de eerste match van regex.
//           start_at - begin op positie 'start_at' te zoeken.
//           maxmatch - geef maximaal maxmatch resultaten terug (in de
//                      vorm van subexpressies (zie regex-0.12 documentatie).
//           maxLen - geef de maximale lengte die doorzocht moet worden.
//                    vanaf start_at.
//     post: =true,	match gevonden
//           =false,    geen match gevonden.
//end
  public:
//def
    long offset(int i=0) 
    { return regs.start[i]; }
//
//    pre:  match().
//    post: Geeft de offset in de string/file (vanaf positie 0) 
//          waar de match gevonden is.
//end
//def
    long len   (int i=0) 
    { return regs.end[i]; }
    long length(int i=0) 
    { return regs.end[i]; }
//
//    pre:  match()
//    post: Geeft de lengte van de match in string/file die gevonden is.
//end
//def
    int  matches(void)   
    { return _matches; }
//
//    pre:  match().
//    post: Geeft het aantal gematchte sub-expressies van de reguliere
//          expressie terug (zie documentatie regex-0.12).
//end
};

//h2 Functies t.b.v. aansturing van de cache
//def
void hregexCleanCache(void);
//
//  pre:  -
//  post: De cache van gecompileerde reguliere expressies is leeg gemaakt.
//  opm.: Voer dit meestal aan het einde van je programma uit, of als
//        je de grootte van de cache te groot vind worden.
//end

//def
int  hregexCacheLen(void);
//
//   pre:  -
//   post: = de grootte van de cache van gecompileeerde reguliere expressies.
//   opm: Controleer dit als je heel veel verschillende regex's gebruikt.
//        en schoon dan af en toe met hregexCleanCache() de cache op.
//end


/*h1 Verwijzingen
//sec

   n.v.t.


//h1 Gegevensbenadering

   n.v.t.


//h1 Voorbeeld programma(s)
//
//h2 Voorbeeld 1

  Matchen van een getal op een string.

//  #include <hregex.hxx>
//
//  {char * s="Hallo allemaal - 12345.1212 ja ja";
//   hregex r("[0-9]+[.][0-9]*");
//      if (r.match(s)) {
//        printf("matched '%-*s', length = %d\n",
//               r.length(),&s[r.offset()],r.length()
//              );
//      }
//      else {
//         printf("Geen match\n")
//      }
//  }
//
//h2 Voorbeeld 2
//  Doorzoeken van een file op een reguliere expressie
//
//  {FILE *f=fopen("match.fil","rt");
//   hregex r("([a-z]|[A-Z])+[(]([^)]*)[)]");
//   char   line[1000];
//   int    offset=0;
//     while (r.match(f),offset) {
//       fseek(f,r.offset(),SEEK_SET);
//       fgets(line,r.length(),f);
//       line[r.length()]='\0';
//       printf("%s\n",line);
//       offset=r.offset()+r.length();
//     }
//  }
//
//
end*/



#endif

