//  libeasy, C++ library to encapsulate things and make life easy.
//  Copyright (C) 2000 Hans Dijkema 
//
//  This program/library is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License as published 
//  by the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program/library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program/library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// This software is maintained by Hans Dijkema.
// See the Makefile.lsm for your primary and secundary site. 
// email me at hnmdijkema@softhome.net
//
#ifndef __HSTRING__HXX
#define __HSTRING__HXX

#ifdef WIN32
#include <vc6.hxx>
#endif

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

class _hstring;

class __hstring_elem {
  friend _hstring;
private:
  int            _size;
  char           *S;
  __hstring_elem *next;
}; 

class _hstring 
{
private:
  static __hstring_elem *first,*notused;
  friend _hstring operator + (const char *s,const _hstring &s1);
  friend _hstring operator + (const _hstring & s1,const char *s);
  friend _hstring operator + (char c,const _hstring &s1);
  friend _hstring operator + (const _hstring & s1,char c);
  friend _hstring operator + (const _hstring & s,const _hstring & s1);
private:
  char    *S;
  int      len,_size;
  bool     donttrust;
public:
  ~_hstring();
  _hstring();
  _hstring(const char *s);
  _hstring(const _hstring & s);
  _hstring(char c);
private:
  _hstring(const char *s,int l);
  void _set(const char *s,int l);
public:
  _hstring & operator =(const _hstring & s);
  _hstring & operator =(const char *s);
  _hstring & operator =(char c);
public:
  _hstring & operator +=(const _hstring & s);
  _hstring & operator +=(const char *s);
  _hstring & operator +=(char c);
public:
  void resize(int len);
public:
  void swap(_hstring & s);
public:
  char & operator[](int i);
  char operator[](int i) const;
public:
  int compare(const char *s,int offset=0,int l=-1);
  int compare(char c,int offset=0,int l=-1);
  int compare(const _hstring &s,int offset=0,int l=-1);
  int icompare(const char *s,int offset=0,int l=-1);
  int icompare(char c,int offset=0,int l=-1);
  int icompare(const _hstring &s,int offset=0,int l=-1);
public:
  bool operator < (const _hstring & s);
  bool operator < (const char *s);     
  bool operator < (char c);      
  bool operator ==(const _hstring & s); 
  bool operator ==(const char *s);     
  bool operator ==(char c);      
  bool operator !=(const _hstring & s); 
  bool operator !=(const char *s);     
  bool operator !=(char c);      
  bool operator > (const _hstring & s); 
  bool operator > (const char *s);     
  bool operator > (char c);      
public:
  _hstring substr(int offset=0,int l=-1);
public:
  const char    *c_str(void) const;
  const char    *data(void) const;
public:
  unsigned int   length(void);
  unsigned int   size(void);
  bool           empty(void);
  unsigned int   capacity(void) const;
public:
  _hstring & append(const _hstring & ,int offset=0,int l=-1);
  _hstring & append(const char *,int l);
  _hstring & append(const char *);
  _hstring & append(int n,char c);
public:
  _hstring & assign(const _hstring & s,int offset=0,int l=-1);
  _hstring & assign(const char *s,int l);
  _hstring & assign(const char *s);
  _hstring & assign(int n,char c);
public:
  int find(const _hstring &,int offset=0);
  int find(const char *s,int offset,int len);
  int find(const char *s,int offset=0);
  int find(char c,int offset=0);
  int rfind(const _hstring &,int offset=-1);
  int rfind(const char *s,int offset,int len);
  int rfind(const char *s,int offset=-1);
  int rfind(char c,int offset=-1);
};

_hstring operator +(const char *s,const _hstring & s1);
_hstring operator +(const _hstring & s,const char *s1);
_hstring operator +(char c,const _hstring & s1);
_hstring operator +(const _hstring & s1,char c);
_hstring operator +(const _hstring & s,const _hstring & s1);

typedef _hstring hstring;

#ifdef GCC
  #include <string>
//    typedef hstring string;
#else
  #ifdef WIN32
    #include <afx.h> 
    class string : public CString
	{
	public:
		string()                 : CString()  {}
		string(const string & s) : CString(s) {}
		string(const char *s)    : CString(s) {}
		string(char c)           : CString(c) {}
    public:
		int length(void)   { return GetLength(); }
		int size(void)     { return GetLength(); }
		bool empty(void)   { return IsEmpty() ? true : false; }
		int capacity(void) { return GetLength(); }
	public:
		string & assign(const char *s,int len) 
		{ 
			char *p;
			p=GetBuffer(len+1);
			strncpy(p,s,len);
			p[len]='\0';
			ReleaseBuffer();
			return *this;
		}
		string & assign(string & s,int len)
		{
			 return assign(s.c_str(),len);
		}
	public:
		char & operator[](int i) 
		{ if (i>=length()) { 
			CString s(' ',i-length()+1);
			*this+=s;
		  }
		  char *s=(char *) c_str();
		  return s[i]; 
		}
	public:
		const char *c_str(void) { return (LPCTSTR) *this; }
	public:
		string substr(int offset,int len) { return (string &) Mid(offset,len); }
	public:
		string & operator = (CString & s) { return (string &) CString::operator =(s); }
	};
    
  #else
    typedef hstring string;
  #endif
#endif

#endif  /* __STRING__HXX */
