//  libeasy, C++ library to encapsulate things and make life easy.
//  Copyright (C) 2000 Hans Dijkema 
//
//  This program/library is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License as published 
//  by the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program/library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program/library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// This software is maintained by Hans Dijkema.
// See the Makefile.lsm for your primary and secundary site. 
// email me at hnmdijkema@softhome.net
//
#include <strext.hxx>
#include <hregex.hxx>
#include <herror.hxx>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define cchar	const char

static unsigned int _match(char *s,string reg,long & at);

void Take(string & R,char * s,unsigned int n)
{
unsigned int N=strlen(s);
  if (n>N) { n=N; }
  R.assign((const char *) s,n);
}

void Take(string & r,string & s,unsigned int n)
{
  Take(r,(char *) s.c_str(),n);
}

void Drop(string & r,string & s,unsigned int n)
{
  Drop(r,(char *) s.c_str(),n);
}

void Drop(string & R,char *s,unsigned int n)
{
unsigned int N=strlen(s);
  if (n>N) { n=N; }
  R.assign(s+n,N-n);
}

#define TKDR_S(NM) \
void NM(string & r,string & s,string re) { NM(r,(char *) s.c_str(),re.c_str()); } 

TKDR_S(TakeWhile)
TKDR_S(DropWhile)
TKDR_S(RTakeWhile)
TKDR_S(RDropWhile)

#define TKDR_C(NM) \
void NM(string & r,string & s,const char *re) { NM(r,(char *) s.c_str(),re); }

TKDR_C(TakeWhile)
TKDR_C(DropWhile)
TKDR_C(RTakeWhile)
TKDR_C(RDropWhile)

#define TKDR_CS(NM) \
void NM(string & r,char *s,string re) { NM(r,s,re.c_str()); }

TKDR_CS(TakeWhile)
TKDR_CS(DropWhile)
TKDR_CS(RTakeWhile)
TKDR_CS(RDropWhile)

static inline bool TWIS(cchar *lit,cchar *set,char *s,int & i)
{
  if (strchr(lit,s[i])!=NULL) {
    return false;  // nee, nu zit het volgende teken niet meer in set!
  }
  else {
    return strchr(set,s[i])!=NULL;	// zit hij erin?
  }
}

void TakeWhileInSet(string & ret,char *s,const char *set,cchar *lit)
{
int i;
  if (lit==NULL) {
    for(i=0;strchr(set,s[i])!=NULL && s[i]!='\0';i++);
  }
  else {
    for(i=0;s[i]!='\0' && TWIS(lit,set,s,i);i++);
  }
  Take(ret,s,i);
}

void RTakeWhileInSet(string & ret,char *s,const char *set,cchar *lit)
{
int i;
  if (lit==NULL) {
    for(i=strlen(s)-1;strchr(set,s[i])!=NULL && i>=0;i--);
  }
  else {
    for(i=strlen(s)-1;i>=0 && TWIS(lit,set,s,i);i--);
  }
  Drop(ret,s,i+1);
}

#define DWIS TWIS

void DropWhileInSet(string & ret,char *s,const char *set,cchar *lit)
{
int i;
  if (lit==NULL) {
    for(i=0;strchr(set,s[i])!=NULL && s[i]!='\0';i++);
  }
  else {
    for(i=0;s[i]!='\0' && DWIS(lit,set,s,i);i++);
  }
  Drop(ret,s,i);
}

void RDropWhileInSet(string & ret,char *s,cchar *set,cchar *lit)
{
int i;
  if (lit==NULL) {
    for(i=strlen(s)-1;strchr(set,s[i])!=NULL && i>=0;i--);
  }
  else {
    for(i=0;i>=0 && DWIS(lit,set,s,i);i--);
  }
  Take(ret,s,i+1);
}


static inline bool TWNIS(cchar *lit,cchar *set,char *s,int & i)
{
  if (strchr(lit,s[i])!=NULL) { i+=1;return true; }
  else { return strchr(set,s[i])==NULL; }
}

void TakeWhileNotInSet(string & ret,char *s,const char *set,cchar *lit)
{
int i;
  if (lit==NULL) {
    for(i=0;strchr(set,s[i])==NULL && s[i]!='\0';i++);
  }
  else {
    for(i=0;s[i]!='\0' && TWNIS(lit,set,s,i);i++);
  }
  Take(ret,s,i);
}

void RTakeWhileNotInSet(string & ret,char *s,const char *set,cchar *lit)
{
int i;
  if (lit==NULL) {
    for(i=strlen(s)-1;strchr(set,s[i])==NULL && i>=0;i--);
  }
  else {
    for(i=strlen(s)-1;i>=0 && TWNIS(lit,set,s,i);i--);
  }
  Drop(ret,s,i+1);
}

#define DWNIS TWNIS

void DropWhileNotInSet(string & ret,char *s,const char *set,cchar *lit)
{
int i;
  if (lit==NULL) {
    for(i=0;strchr(set,s[i])==NULL && s[i]!='\0';i++);
  }
  else {
    for(i=0;s[i]!='\0' && DWNIS(lit,set,s,i);i++);
  }
  Drop(ret,s,i);
}

void RDropWhileNotInSet(string & ret,char *s,const char *set,cchar *lit)
{
int i;
  if (lit==NULL) {
    for(i=strlen(s)-1;strchr(set,s[i])==NULL && i>=0;i--);
  }
  else {
    for(i=0;i>=0 && DWNIS(lit,set,s,i);i--);
  }
  Take(ret,s,i+1);
}

void TakeWhile(string & ret,char *s,const char *regexp)
{
string  r="^";

  CHECKPOINT;

  r=r+regexp;

  {hregex R(r);

    CHECKPOINT;


    if (R.match(s)) {
      Take(ret,s,R.length());
    }
    else {
      Take(ret,s,0);
    }
  }
}

void DropWhile(string & ret,char *s,const char *regexp)
{
string     r="^";

  CHECKPOINT;
  r=r+regexp;

  {hregex R(r);

    CHECKPOINT;
    if (R.match(s)) {
      Drop(ret,s,R.length());
    }
    else {
      Drop(ret,s,0);
    }
  }
}

void RTakeWhile(string & ret,char *s,const char *regexp)
{
string r=regexp;

  CHECKPOINT;
  r=r+"$";

  {hregex R(r);

    CHECKPOINT;
    if (R.match(s)) {
      Drop(ret,s,strlen(s)-R.length());
    }
    else {
      Take(ret,s,0);
    }
  }
}

void RDropWhile(string & ret,char *s,const char *regexp)
{
string r=regexp;

  CHECKPOINT;
  r=r+"$";

  {hregex R(r);
    CHECKPOINT;
    if (R.match(s)) {
      Take(ret,s,strlen(s)-R.length());
    }
    else {
      ret=s;
    }
  }
}

void Trim(string & r,string & s,const char *L, const char *R)
{
char   *left,*right;
  CHECKPOINT;
  if (L==NULL) { left="[[:space:]]+"; } else { left=(char *) L; }
  if (R==NULL) { right=left; } else { right=(char *) R; }
  DropWhile(r,s,left);
  RDropWhile(r,r,right);
}


void Trim(string & r, string & s)
{
int i,N;
  for(i=0,N=s.length();i<N && isspace(s[i]);i++);
  Drop(r,s,i);
  for(i=r.length()-1;i>=0 && isspace(r[i]);i--);
  Take(r,r,i+1);
}

unsigned int match(char *s,string reg,long & at)
{
return _match(s,reg,at);
}

unsigned int match(string & s,string reg,long & at)
{
return _match((char *) s.c_str(),reg,at);
}

unsigned int match(char *s,string reg)
{
long at;
return _match(s,reg,at);
}

unsigned int match(string & s,string reg)
{
long at;
return _match((char *) s.c_str(),reg,at);
}

//////////////////////////////////////////////////////////////////////
// Statische functies (ondersteunend)
//////////////////////////////////////////////////////////////////////

unsigned int _match(char *s,string reg,long & at)
{
hregex R(reg);
  CHECKPOINT;

  if (R.match(s)) {
    at=R.offset();
    return R.length();
  }
  else {
    at=-1;
    return 0;
  }
}

