//  libeasy, C++ library to encapsulate things and make life easy.
//  Copyright (C) 2000 Hans Dijkema 
//
//  This program/library is free software; you can redistribute it and/or 
//  modify it under the terms of the GNU General Public License as published 
//  by the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  This program/library is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program/library; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// This software is maintained by Hans Dijkema.
// See the Makefile.lsm for your primary and secundary site. 
// email me at hnmdijkema@softhome.net
//
#ifndef __STREXT__HXX
#define __STREXT__HXX

#ifdef WIN32
#include <vc6.hxx>
#endif

#include <hstring.hxx>

//doc
// library : libeasy.a
// module  : strext
// include : strext.hxx
// link    : -leasy
//
// Versie Wie              Datum       Wijziging/Opdracht/Omschrijving
// --------------------------------------------------------------------------
// 1.00   HNM Dijkema      27-12-1999  Algemeen bruikbare library ten behoeve
//                                     van C++ projecten.
// 1.01   HNM Dijkema      29-12-1999  Uitbreiding aantal functies
//
//h2 Revisies
// Versie Revisieinformatie
// --------------------------------------------------------------------------
// 1.00   Initiele versie
// 1.01   Toevoegen RDrop(), RTake(), 
//                  RDropWhileInSet(), RDropWhileNotInSet(), 
//                  RTakeWhileInSet() en RTakeWhileNotInSet()
//
//h1 Doel van de library
// Deze module voorziet in extra functies die op strings werken.
// include <string.hxx> voor het gebruik van deze functies. 
//
// De basis functies zijn Take en Drop. Bij Take worden N tekens
// van een string genomen en in de result string geplaatst. Bij
// Drop worden de eerste N tekens overgeslagen en de rest van de 
// input string wordt in de result string geplaatst.
//
// TakeWhile en DropWhile borduren hierop voort. Hierbij worden echter
// niet N tekens ge"Taked" of ge"Dropped", maar wordt zolang er aan een
// conditie voldaan is genomen of gedropped. De conditie is in deze het
// waar zijn van een reguliere expressie vanaf het begin van de string.
//
// TakeWhileInSet en DropWhileInSet zijn versnelfuncties voor TakeWhile
// en DropWhile. Deze functies voorzien in de beperkte functionaliteit
// dat genomen en gedropped wordt, zolang de tekens van een string in
// de meegegeven lijst van characters staan.
//
// RTakeWhile en RDropWhile werken niet vanaf het begin, maar vanaf
// het eind van de input string. Verder gelijk aan TakeWhile en DropWhile.
//
// Trim, voert een DropWhile na een RDropWhile uit. Kan gebruikt worden
// om bijvoorbeeld tabs en spaties aan weerskanten van een string te
// verwijderen.
//
// match zoekt de eerste positie in een string, waarbij de meegegeven
// regulier expressie gematched wordt. Teruggegeven wordt de lengte van
// de match. Het meegegeven argument 'at' bevat dan de startpositie.
//
//end

//h1 Classes en Functies

//sec
#define cchar const char
//end

//def
void Drop(string & r,string & s,unsigned int n);
void Drop(string & r,char *s,unsigned int n);
/*lit
  pre : r en s mogen dezelfde variabele zijn.
  post: r="",                                     n>=s.length()
        r={ s[i] | i=n,n+1,...,s.length()-1 },    otherwise
end*/

//def
void Take(string & r,string & s,unsigned int n);
void Take(string & r,char *s, unsigned int n);
/*lit
  pre : r en s mogen dezelfde variabele zijn.
  post: r={ s[i] | i=0,1,...,MIN(s.length(),n)-1 }
end*/

//def
inline void RDrop(string & r,string & s,unsigned int n)
{ Take(r,s,s.length()-n); }
inline void RDrop(string & r,char *s,unsigned int n)
{ Take(r,s,strlen(s)-n); }
/*lit
  pre : r en s mogen dezelfde variabele zijn.
        n<=s.length()
  post: Take(r,s,s.length()-n)
end*/

//def
inline void RTake(string & r,string & s,unsigned int n)
{ Drop(r,s,s.length()-n); }
inline void RTake(string & r,char *s, unsigned int n)
{ Drop(r,s,strlen(s)-n); }
/*lit
  pre : r en s mogen dezelfde variabele zijn.
        n<=s.length()
  post: Drop(r,s,s.length()-n)
end*/


//def
void DropWhile(string & r,string & s,cchar *regexp);
void DropWhile(string & r,string & s,string regexp);
void DropWhile(string & r,char *s,cchar *regexp);
void DropWhile(string & r,char *s,string regexp);
/*lit
  pre :  - ^(regexp) is een goede reguliere expressie.
         - r en s mogen dezelfde variabele zijn.
  post: S1={ s[i] | s[i] voldoet aan regexp && i=0,1,...,s.length()-1 }
        Drop(r,s,length(S1))
end*/

//def
void TakeWhile(string & r,string & s,cchar *regexp);
void TakeWhile(string & r,string & s,string regexp);
void TakeWhile(string & r,char *s,cchar *regexp);
void TakeWhile(string & r,char *s,string regexp);
/*lit
  pre :  - ^(regexp) is een goede reguliere expressie.
         - r en s mogen dezelfde variabele zijn.
  post: r={ s[i] | s[i] voldoet aan regexp && i=0,1,...,s.length()-1 }
end*/

//def
void RDropWhile(string & r,string & s,cchar *regexp);
void RDropWhile(string & r,string & s,string regexp);
void RDropWhile(string & r,char *s,cchar *regexp);
void RDropWhile(string & r,char *s,string regexp);
/*lit
  pre :  - ^(regexp) is een goede reguliere expressie.
         - r en s mogen dezelfde variabele zijn.
  post: S1={ s[i] | s[i] voldoet aan regexp && i=s.length()-1,...,1,0 }
        Take(r,s,s.length()-S1.length())
end*/

//def
void RTakeWhile(string & r,string & s,cchar *regexp);
void RTakeWhile(string & r,string & s,string regexp);
void RTakeWhile(string & r,char *s,cchar *regexp);
void RTakeWhile(string & r,char *s,string regexp);
/*lit
  pre :  - ^(regexp) is een goede reguliere expressie.
         - r en s mogen dezelfde variabele zijn.
  post: r={ s[i] | s[i] voldoet aan regexp && i=s.length()-1,...,1,0 }
end*/



//def 
void TakeWhileInSet(string & r,char *s,cchar *set,cchar *lit=NULL);
inline void TakeWhileInSet(string & r,string & s,cchar *set,cchar *lit=NULL)
{ TakeWhileInSet(r,(char *) s.c_str(),set,lit); }
inline void TakeWhileInSet(string & r,string & s,string set,cchar *lit=NULL)
{ TakeWhileInSet(r,(char *) s.c_str(),set.c_str(),lit); }
inline void TakeWhileInSet(string & r,char *s,string set,cchar *lit=NULL)
{ TakeWhileInSet(r,s,set.c_str(),lit); }
inline void TakeWhileInSet(string & r,char *s,cchar *set,string lit)
{ TakeWhileInSet(r,s,set,lit.c_str()); }
inline void TakeWhileInSet(string & r,string & s,cchar *set,string lit)
{ TakeWhileInSet(r,(char *) s.c_str(),set,lit.c_str()); }
inline void TakeWhileInSet(string & r,string & s,string set,string lit)
{ TakeWhileInSet(r,(char *) s.c_str(),set.c_str(),lit); }
inline void TakeWhileInSet(string & r,char *s,string set,string lit)
{ TakeWhileInSet(r,s,set.c_str(),lit.c_str()); }
/*lit
  pre : r en s mogen dezelfde variabelen zijn.
        Indien lit==NULL, is lit de lege verzameling
  post: r={ s[i] | (s[i] in set && not (s[i] in lit,i+=1)) && s[i]!='\0' }
        NB. interpretatie is lit gevolgd door set! 
  opm.: Indien s[i] in lit zit, dan is de interpretatie dat het volgend
        teken letterlijk moet worden genomen, ongeacht of deze in set
        zit of niet. Het teken zit in dit geval per definitie niet in set.
        vandaar de eenvoudige boolean expressie. Het volgende teken wordt 
        dan overgeslagen.
end*/

//def 
void TakeWhileNotInSet(string & r,char *s,cchar *set,cchar *lit=NULL);
inline void TakeWhileNotInSet(string & r,string & s,cchar *set,cchar *lit=NULL)
{ TakeWhileNotInSet(r,(char *) s.c_str(),set,lit); }
inline void TakeWhileNotInSet(string & r,string & s,string set,cchar *lit=NULL)
{ TakeWhileNotInSet(r,(char *) s.c_str(),set.c_str(),lit); }
inline void TakeWhileNotInSet(string & r,char *s,string set,cchar *lit=NULL)
{ TakeWhileNotInSet(r,s,set.c_str(),lit); }
inline void TakeWhileNotInSet(string & r,char *s,cchar *set,string lit)
{ TakeWhileNotInSet(r,s,set,lit.c_str()); }
inline void TakeWhileNotInSet(string & r,string & s,cchar *set,string lit)
{ TakeWhileNotInSet(r,(char *) s.c_str(),set,lit.c_str()); }
inline void TakeWhileNotInSet(string & r,string & s,string set,string lit)
{ TakeWhileNotInSet(r,(char *) s.c_str(),set.c_str(),lit); }
inline void TakeWhileNotInSet(string & r,char *s,string set,string lit)
{ TakeWhileNotInSet(r,s,set.c_str(),lit.c_str()); }
/*lit
  pre : r en s mogen dezelfde variabelen zijn.
        Indien lit==NULL, is lit de lege verzameling
  post: r={ s[i] | (s[i] not in set || (s[i] in lit,i+=1)) && s[i]!='\0' }
        NB. interpretatie is lit gevolgd door set! 
  opm.: Indien s[i] in lit zit, dan is de interpretatie dat het volgend
        teken letterlijk moet worden genomen, ongeacht of deze in set
        zit of niet. Het teken zit in dit geval per definitie niet in set.
        vandaar de eenvoudige boolean expressie. Het volgende teken wordt 
        dan overgeslagen.
end*/

//def 
void DropWhileInSet(string & r,char *s,cchar *set,cchar *lit=NULL);
inline void DropWhileInSet(string & r,string & s,cchar *set,cchar *lit=NULL)
{ DropWhileInSet(r,(char *) s.c_str(),set,lit); }
inline void DropWhileInSet(string & r,string & s,string set,cchar *lit=NULL)
{ DropWhileInSet(r,(char *) s.c_str(),set.c_str(),lit); }
inline void DropWhileInSet(string & r,char *s,string set,cchar *lit=NULL)
{ DropWhileInSet(r,s,set.c_str(),lit); }
inline void DropWhileInSet(string & r,char *s,cchar *set,string lit)
{ DropWhileInSet(r,s,set,lit.c_str()); }
inline void DropWhileInSet(string & r,string & s,cchar *set,string lit)
{ DropWhileInSet(r,(char *) s.c_str(),set,lit.c_str()); }
inline void DropWhileInSet(string & r,string & s,string set,string lit)
{ DropWhileInSet(r,(char *) s.c_str(),set.c_str(),lit); }
inline void DropWhileInSet(string & r,char *s,string set,string lit)
{ DropWhileInSet(r,s,set.c_str(),lit.c_str()); }
/*lit
  pre : r en s mogen dezelfde variabelen zijn.
        Indien lit==NULL, is lit de lege verzameling
  post: R={ s[i] | (s[i] in set && not (s[i] in lit,i+=1)) && s[i]!='\0' }
        r <-- Drop(r,s,length(R))
        NB. interpretatie is lit gevolgd door set! 
  opm.: Indien s[i] in lit zit, dan is de interpretatie dat het volgend
        teken letterlijk moet worden genomen, ongeacht of deze in set
        zit of niet. Het teken zit in dit geval per definitie niet in set.
        vandaar de eenvoudige boolean expressie. Het volgende teken wordt 
        dan overgeslagen.
end*/

//def 
void DropWhileNotInSet(string & r,char *s,cchar *set,cchar *lit=NULL);
inline void DropWhileNotInSet(string & r,string & s,cchar *set,cchar *lit=NULL)
{ DropWhileNotInSet(r,(char *) s.c_str(),set,lit); }
inline void DropWhileNotInSet(string & r,string & s,string set,cchar *lit=NULL)
{ DropWhileNotInSet(r,(char *) s.c_str(),set.c_str(),lit); }
inline void DropWhileNotInSet(string & r,char *s,string set,cchar *lit=NULL)
{ DropWhileNotInSet(r,s,set.c_str(),lit); }
inline void DropWhileNotInSet(string & r,char *s,cchar *set,string lit)
{ DropWhileNotInSet(r,s,set,lit.c_str()); }
inline void DropWhileNotInSet(string & r,string & s,cchar *set,string lit)
{ DropWhileNotInSet(r,(char *) s.c_str(),set,lit.c_str()); }
inline void DropWhileNotInSet(string & r,string & s,string set,string lit)
{ DropWhileNotInSet(r,(char *) s.c_str(),set.c_str(),lit); }
inline void DropWhileNotInSet(string & r,char *s,string set,string lit)
{ DropWhileNotInSet(r,s,set.c_str(),lit.c_str()); }
/*lit
  pre : r en s mogen dezelfde variabelen zijn.
        Indien lit==NULL, is lit de lege verzameling
  post: R={ s[i] | (s[i] not in set || (s[i] in lit,i+=1)) && s[i]!='\0' }
        r <-- Drop(r,s,length(R))
        NB. interpretatie is lit gevolgd door set! 
  opm.: Indien s[i] in lit zit, dan is de interpretatie dat het volgend
        teken letterlijk moet worden genomen, ongeacht of deze in set
        zit of niet. Het teken zit in dit geval per definitie niet in set.
        vandaar de eenvoudige boolean expressie. Het volgende teken wordt 
        dan overgeslagen.
end*/

//def 
void RTakeWhileInSet(string & r,char *s,cchar *set,cchar *lit=NULL);
inline void RTakeWhileInSet(string & r,string & s,cchar *set,cchar *lit=NULL)
{ RTakeWhileInSet(r,(char *) s.c_str(),set,lit); }
inline void RTakeWhileInSet(string & r,string & s,string set,cchar *lit=NULL)
{ RTakeWhileInSet(r,(char *) s.c_str(),set.c_str(),lit); }
inline void RTakeWhileInSet(string & r,char *s,string set,cchar *lit=NULL)
{ RTakeWhileInSet(r,s,set.c_str(),lit); }
inline void RTakeWhileInSet(string & r,char *s,cchar *set,string lit)
{ RTakeWhileInSet(r,s,set,lit.c_str()); }
inline void RTakeWhileInSet(string & r,string & s,cchar *set,string lit)
{ RTakeWhileInSet(r,(char *) s.c_str(),set,lit.c_str()); }
inline void RTakeWhileInSet(string & r,string & s,string set,string lit)
{ RTakeWhileInSet(r,(char *) s.c_str(),set.c_str(),lit); }
inline void RTakeWhileInSet(string & r,char *s,string set,string lit)
{ RTakeWhileInSet(r,s,set.c_str(),lit.c_str()); }
/*lit
  pre : r en s mogen dezelfde variabelen zijn.
        Indien lit==NULL, is lit de lege verzameling
  post: r={ s[i] | (s[i] in set && not (s[i] in lit,i+=1)) && s[i]!='\0' }
        i=s.length(),...,1,0
        NB. interpretatie is lit gevolgd door set! 
  opm.: Indien s[i] in lit zit, dan is de interpretatie dat het volgend
        teken letterlijk moet worden genomen, ongeacht of deze in set
        zit of niet. Het teken zit in dit geval per definitie niet in set.
        vandaar de eenvoudige boolean expressie. Het volgende teken wordt 
        dan overgeslagen.
end*/

//def 
void RTakeWhileNotInSet(string & r,char *s,cchar *set,cchar *lit=NULL);
inline void RTakeWhileNotInSet(string & r,string & s,cchar *set,cchar *lit=NULL)
{ RTakeWhileNotInSet(r,(char *) s.c_str(),set,lit); }
inline void RTakeWhileNotInSet(string & r,string & s,string set,cchar *lit=NULL)
{ RTakeWhileNotInSet(r,(char *) s.c_str(),set.c_str(),lit); }
inline void RTakeWhileNotInSet(string & r,char *s,string set,cchar *lit=NULL)
{ RTakeWhileNotInSet(r,s,set.c_str(),lit); }
inline void RTakeWhileNotInSet(string & r,char *s,cchar *set,string lit)
{ RTakeWhileNotInSet(r,s,set,lit.c_str()); }
inline void RTakeWhileNotInSet(string & r,string & s,cchar *set,string lit)
{ RTakeWhileNotInSet(r,(char *) s.c_str(),set,lit.c_str()); }
inline void RTakeWhileNotInSet(string & r,string & s,string set,string lit)
{ RTakeWhileNotInSet(r,(char *) s.c_str(),set.c_str(),lit); }
inline void RTakeWhileNotInSet(string & r,char *s,string set,string lit)
{ RTakeWhileNotInSet(r,s,set.c_str(),lit.c_str()); }
/*lit
  pre : r en s mogen dezelfde variabelen zijn.
        Indien lit==NULL, is lit de lege verzameling
  post: r={ s[i] | (s[i] not in set || (s[i] in lit,i+=1)) && s[i]!='\0' }
        i=s.length(),...,1,0
        NB. interpretatie is lit gevolgd door set! 
  opm.: Indien s[i] in lit zit, dan is de interpretatie dat het volgend
        teken letterlijk moet worden genomen, ongeacht of deze in set
        zit of niet. Het teken zit in dit geval per definitie niet in set.
        vandaar de eenvoudige boolean expressie. Het volgende teken wordt 
        dan overgeslagen.
end*/

//def 
void RDropWhileInSet(string & r,char *s,cchar *set,cchar *lit=NULL);
inline void RDropWhileInSet(string & r,string & s,cchar *set,cchar *lit=NULL)
{ RDropWhileInSet(r,(char *) s.c_str(),set,lit); }
inline void RDropWhileInSet(string & r,string & s,string set,cchar *lit=NULL)
{ RDropWhileInSet(r,(char *) s.c_str(),set.c_str(),lit); }
inline void RDropWhileInSet(string & r,char *s,string set,cchar *lit=NULL)
{ RDropWhileInSet(r,s,set.c_str(),lit); }
inline void RDropWhileInSet(string & r,char *s,cchar *set,string lit)
{ RDropWhileInSet(r,s,set,lit.c_str()); }
inline void RDropWhileInSet(string & r,string & s,cchar *set,string lit)
{ RDropWhileInSet(r,(char *) s.c_str(),set,lit.c_str()); }
inline void RDropWhileInSet(string & r,string & s,string set,string lit)
{ RDropWhileInSet(r,(char *) s.c_str(),set.c_str(),lit); }
inline void RDropWhileInSet(string & r,char *s,string set,string lit)
{ RDropWhileInSet(r,s,set.c_str(),lit.c_str()); }
/*lit
  pre : r en s mogen dezelfde variabelen zijn.
        Indien lit==NULL, is lit de lege verzameling
  post: R={ s[i] | (s[i] in set && not (s[i] in lit,i+=1)) && s[i]!='\0' }
        i=s.length(),...,1,0
        r <-- RDrop(r,s,length(R))
        NB. interpretatie is lit gevolgd door set! 
  opm.: Indien s[i] in lit zit, dan is de interpretatie dat het volgend
        teken letterlijk moet worden genomen, ongeacht of deze in set
        zit of niet. Het teken zit in dit geval per definitie niet in set.
        vandaar de eenvoudige boolean expressie. Het volgende teken wordt 
        dan overgeslagen.
end*/

//def 
void RDropWhileNotInSet(string & r,char *s,cchar *set,cchar *lit=NULL);
inline void RDropWhileNotInSet(string & r,string & s,cchar *set,cchar *lit=NULL)
{ RDropWhileNotInSet(r,(char *) s.c_str(),set,lit); }
inline void RDropWhileNotInSet(string & r,string & s,string set,cchar *lit=NULL)
{ RDropWhileNotInSet(r,(char *) s.c_str(),set.c_str(),lit); }
inline void RDropWhileNotInSet(string & r,char *s,string set,cchar *lit=NULL)
{ RDropWhileNotInSet(r,s,set.c_str(),lit); }
inline void RDropWhileNotInSet(string & r,char *s,cchar *set,string lit)
{ RDropWhileNotInSet(r,s,set,lit.c_str()); }
inline void RDropWhileNotInSet(string & r,string & s,cchar *set,string lit)
{ RDropWhileNotInSet(r,(char *) s.c_str(),set,lit.c_str()); }
inline void RDropWhileNotInSet(string & r,string & s,string set,string lit)
{ RDropWhileNotInSet(r,(char *) s.c_str(),set.c_str(),lit); }
inline void RDropWhileNotInSet(string & r,char *s,string set,string lit)
{ RDropWhileNotInSet(r,s,set.c_str(),lit.c_str()); }
/*lit
  pre : r en s mogen dezelfde variabelen zijn.
        Indien lit==NULL, is lit de lege verzameling
  post: R={ s[i] | (s[i] not in set || (s[i] in lit,i+=1)) && s[i]!='\0' }
        i=s.length(),...,1,0
        r <-- RDrop(r,s,length(R))
        NB. interpretatie is lit gevolgd door set! 
  opm.: Indien s[i] in lit zit, dan is de interpretatie dat het volgend
        teken letterlijk moet worden genomen, ongeacht of deze in set
        zit of niet. Het teken zit in dit geval per definitie niet in set.
        vandaar de eenvoudige boolean expressie. Het volgende teken wordt 
        dan overgeslagen.
end*/

//def
void Trim(string & r,string & s);
void Trim(string & r,string & s,cchar *regexp_left,cchar *regexp_right=NULL);
/*lit
  pre : r en s mogen dezelfde variabele zijn.
  post: =Trim(r,s,"[[:space:]]","[[:space:]]"), regexp_left==regexp_right==NULL
        =Trim(r,s,"[[:space:]]",regexp_right),  regexp_left==NULL
        =Trim(r,s,regexp_left,regexp_left),     regexp_right==NULL
        =DropWhile(r,s,left);RDropWhile(r,r,right),	otherwise
end*/

//  def
unsigned int match(string & s,string regexp);
unsigned int match(char * s,string regexp);
unsigned int match(string & s,string regexp,long & at);
unsigned int match(char *s,string regexp,long & at);
/*lit
  pre : regexp is een goede reguliere expressie
  post: =lengte van de match (0==geen match).
        match begint bij s[at];
end*/


//sec
//h1 Verwijzingen
//      n.v.t.
//end

//sec
//h1 Gegevensbenadering
//      n.v.t.
//end

//sec
//h1 Voorbeeldprogramma's
//h2 tst_strext.cxx
//  #include <strext.hxx>
//  #include <hregex.hxx>
//  #include <stdio.h>
//  
//  int main()
//  {
//  string s="Hallo dit is een testje",s1;
//  string r,r1;
//  int i;
//  try {
//    r1="Hallo";
//    printf("%d\n",r1.length());
//  
//    for(i=0;i<10;i++) {
//      r1[i]='A'+i;
//    }
//    printf("%s\n",r1.c_str());
//  
//    {string r="Hallo allemaal";
//       Take(r,r,5);
//       printf("%s %d\n",r.c_str(),r.length());
//    }
//    {string r="Hallo allemaal";
//       Take(r,r,50);
//       printf("%s %d\n",r.c_str(),r.length());
//    }
//    {string r="Hallo allemaal";
//       Drop(r,r,5);
//       printf("%s %d\n",r.c_str(),r.length());
//    }
//    {string r="Hallo allemaal";
//       Drop(r,r,50);
//       printf("%s %d\n",r.c_str(),r.length());
//    }
//  
//  
//    printf("%s\n",s.c_str());
//  
//    Take(r,s,5);
//    printf("Take 5:%s\n",r.c_str());
//  
//    Drop(r,s,6);
//    printf("Drop 6:%s\n",r.c_str());
//  
//    {string m="^H...";
//      hregex R(m); 
//      R.match(s);
//      cout << R.length() << "\n";
//      Take(r,s,R.length());
//      printf("%s\n",r.c_str());
//    }
//    {string m="^H...";
//      hregex R(m); 
//      R.match(s);
//      cout << R.length() << "\n";
//      Take(r,s,R.length());
//      printf("%s\n",r.c_str());
//    }
//    TakeWhile(r,s,"H...");
//    printf("TakeWhile H...:%s\n",r.c_str());
//  
//    TakeWhile(r,s,"Hall");
//    printf("TakeWhile Hall:%s\n",r.c_str());
//    
//    DropWhile(r,s,"(.*)een");
//    printf("DropWhile (.*)een:%s\n",r.c_str());
//  
//    s1="   Hoi    ";
//    s=s1;
//    printf("%s\n",s.c_str());
//  
//    DropWhile(r,s,"[ ]*");
//    printf("DropWhile [ ]*:%s\n",r.c_str());
//  
//    
//    Trim(r,s);
//    printf("Trim:%s:%d\n",r.c_str(),r.length());
//  
//    s.resize(0);
//    s="AAABChallo172342";
//    printf("Original:%s:%d\n",s.c_str(),s.length());
//  
//    Trim(r,s,"[A-C]+","[1-4]+");
//    printf("Trim:%s:%d\n",r.c_str(),r.length());
//  
//    TakeWhile(r,s,"[A-C]+");
//    printf("TKW [A-C]+:%s:%d\n",r.c_str(),r.length());
//  
//    TakeWhile(r,s,"[A-C]");
//    printf("TKW [A-C]:%s:%d\n",r.c_str(),r.length());
//  
//    printf("Original:%s:%d\n",s.c_str(),s.length());
//  
//    s[0]=28;s[1]=29;s[2]=30;s[3]=31;
//    TakeWhile(r,s,"....");
//    printf("TKW ....:%s:%d\n\n\n",r.c_str(),r.length());
//  
//    string reg="[ - ]+[A-Z]";
//    reg[1]=28;
//    reg[3]=31;
//    TakeWhile(r,s,reg);
//    printf("TKW %s:%s:%d\n\n\n",reg.c_str(),r.c_str(),r.length());
//    printf("Original:%s:%d\n",s.c_str(),s.length());
//  
//    string set="01234566789",lit="?";
//  
//    s="123.232";
//    TakeWhileInSet(r,s,set,lit);
//    printf("TKWIS %s:%s:%s:%d\n\n\n",
//             set.c_str(),lit.c_str(),r.c_str(),r.length());
//    printf("Original:%s:%d\n",s.c_str(),s.length());
//  
//    s="123?5.222";
//    TakeWhileInSet(r,s,set,lit);
//    printf("TKWIS %s:%s:%s:%d\n\n\n",
//             set.c_str(),lit.c_str(),r.c_str(),r.length());
//    printf("Original:%s:%d\n",s.c_str(),s.length());
//  
//    s="ABC?52.222";
//    TakeWhileNotInSet(r,s,set,lit);
//    printf("TKWNIS %s:%s:%s:%d\n\n\n",
//             set.c_str(),lit.c_str(),r.c_str(),r.length());
//    printf("Original:%s:%d\n",s.c_str(),s.length());
//  
//    TakeWhile(r,s,"[A-C");
//  
//  
//  }
//  
//  catch(char *m) {
//    int e;
//      e=atoi(m+1);
//      printf("%s\n",m);
//      exit(e);
//  }
//  
//  return 0;
//  }
//  
//end

#undef cchar

#endif

