//
// class elementHandler
//
// this source code (c) 1996 Alessandro Cella
//
// uses gnu libg++ to provide a double linked list and
// a set of operation upon the list of
// pointers to class <T>, including
// call of member functions (thru pointers).
// 

#ifndef _ELEMENTHANDLER_H
#define _ELEMENTHANDLER_H

#define ELEMHANDNAME "elementHandler"
#define ELEMHANDVERS "v.0.3.1"
#define ELEMHANDAUTH "a.cella (cella@marvin.conecta.it)"
#define ELEMHANDDATE "29 jun 96"

#include <DLList.h>

template<class T> class elementHandler
{
  typedef void (T::*PMFV)(void);

 public:
  elementHandler() {};
  ~elementHandler() {};

  //
  // appends (at the end)
  // Pix is a cute fencepost for (void *)
  //
  Pix insAtBack(T* gizmo) { return eL.append(gizmo); }

  //
  // inserts at the front of the list
  //
  Pix insAtFront(T* gizmo) { return eL.prepend(gizmo); }

  //
  // checks if empty (0==false)
  //
  inline int empty() { return eL.empty(); }
  
  //
  // returns no of elements
  //
  inline int n() { return eL.length(); }

  //
  // returns a pointer to the n-th element
  // in the list (first is 1, last is ::n() )
  //
  T* gimmeNo(int position)
  {
    if((position<1) || (position>(this->n())))
      return (T*) 0;
    Pix idx=eL.first();
    for(int tempp=1; ((idx!=0) && (tempp!=position)); tempp++, eL.next(idx));
    return eL(idx);
  }

  //
  // scans all the list, front to back, and executes
  // the specified member function for each element.
  // accepts a pointer to plantElement's member function
  //
  void scanExec(PMFV pointerToWhichMemberFunction)
    {
      // do NOT remove thought-spurious parenthesis :)
      // note that "->*" is the operator used to bind
      // a pointer to object to a particular object
      // the precedence of () is higher than that of "->*"
      // see stroustrup, chap. 5 (Classes, Pointers to Members)

      for(Pix idx=eL.first(); idx!=0; eL.next(idx))
	((eL(idx))->*pointerToWhichMemberFunction)();
    }

  String getVersion() { return ELEMHANDNAME" "ELEMHANDVERS; }

 private:
  //
  // use of pointers (instead of the classes themselves) 
  // avoids slicing. see Stroustrup.
  //
  DLList<T*> eL;
};
#endif


