//
// class Fixed Temperature HeatXChanger
// (c) 1995--1996 Alessandro Cella
//

#ifndef _FIXTHEATXC_H
#define _FIXTHEATXC_H
#define FIXTHEATNAME "fixTheatXC"
#define FIXTHEATVERS "v.0.8.1"
#define FIXTHEATAUTH "a.cella (cella@marvin.conecta.it)"
#define FIXTHEATDATE "25 jun 96"

#ifndef _FLUID_H
#include "fluid.h"
#endif

#ifndef _PLANTELEMENT_H
#include "plantElement.h"
#endif

#ifndef _HEATXC_H
#include "heatXC.h"
#endif

#include <String.h>

class fixTheatXC : public heatXC
{
public:
  //
  // default constructor
  // exchanger defaults to Tin=Tout=273 K and CO2 for both fluids
  // counterflow configuration and nominal efficiency of unity
  //
  fixTheatXC(String name="default fixedT heat exchanger",int id=0);

  //
  // destructor
  //
  ~fixTheatXC() {};

// these have changed:
//  cold fluidinletT
//  double getColdFluidOutletT();
//  double getHotFluidOutletT();

  String getVersion();

private:
  // 0: no panic, otherwise solution is not reliable
  int panic;

  // 0: counterflow, 1: parallel flow
  int config;

  // 1 or 2 fluids? (i.e. regenerative exchanger or not?)
  int NoOfFluids;

  // hot and cold fluids representation
  fluid HotFluid,ColdFluid;

  // temperatures of the fluids (SI units: K)
  double TinH,ToutH,TinC,ToutC;

  // dunno if required
  double mnCpH,mnCpC;

  // mass flow of the 2 fluids (SI units: kg/s)
  double ColdFluidMassFlow,HotFluidMassFlow;
  
  // CpFlow = massFlow * meanCp
  double HotCpFlow,ColdCpFlow;

  //
  double CflowMinOverCflowMax;

  // nominal efficiency: (desing maximum/theorical maximum) heat flow
  // real    efficiency: how much heat flow *actually* exchanged
  double nominalEff,realEff;

  // gets fluid`s mean Cp
  // 0: cold fluid
  // 1: hot fluid
  double meanCp(int fluidNo,double T1, double T2);
};

#endif



