//
// fluid.h : a class to represent a fluid
// (c) 1995--1996 Alessandro Cella <cella@marvin.conecta.it>
//
// distributed under GNU GPL, see license doc
//
// this offers NO WARRANTY... 
//

#ifndef _FLUID_H
#define _FLUID_H

#define FLDNAME "fluid"
#define FLDVERS "v.0.8.1"
#define FLDDATE "24 jun 96"
#define FLDAUTH "a.cella (cella@marvin.conecta.it)"
#define FLDLKUP "fluid-"FLDVERS"-Cp.table"

#include <iostream.h>
#include <fstream.h>
#include <String.h>

class fluid
{
  //
  // please access me, ostream!
  //
  friend ostream& operator << (ostream&, fluid&);
  friend istream& operator >> (istream&, fluid&);

public:
  //
  // default constructor, assumes CO2 is used
  //
  fluid(String whichFluid="CO2");

  //
  // default destructor
  //
  ~fluid() {}; 

  //
  // sets current fluid by ID, e.g. "N2","SMOKES" ("CO2" is default)
  //
  int setFluid(String ID);

  //
  // overloaded assignment operator
  //
  fluid& operator = (const fluid&);
  
  //
  // returns fluid Cp at temperature T 
  // using the correlation Cp=CTp0+CTpmh*T^-.5+CTpm1*T^-1+CTpm2*T^-2
  //
  double Cp(double T);

  //
  // used by each fluid in heatxc to get mean Cp
  // though maybe it`s better to leave other classes to do this
  // as they please... on the other hand, this reduces coding and
  // simplifies access to the class...
  //
  double meanCp(double T1, double T2);
  
  //
  // returns k=Cp/Cv, where Cp-Cv=R'=Rprime=R/MMass, at temperature T
  //
  double kappa(double T);

  //
  // returns k-1/k at temperature T
  //
  double Km1OverK(double T);

  //
  // info methods
  //
  // these have the same name, though
  // "fluid" is not derived from
  // "plantElement" !!!
  //
  String getVersion();
  String getName(); 

private:
  //
  // this is R of perfect gases kJ/kg K
  //
  double R;

  //
  // identification string for the current fluid
  //
  String fluidID;

  //
  // sets fluid data, returns 0 if fails the attempt
  //
  int set(String ID);
  
  //
  // default internal stuff
  //
  int setCO2();

  //
  // Cp constants to multiply temp. raised to power 0, minus 1, minus 2
  //
  double CTp0,CTpmh,CTpm1,CTpm2;

  //
  // molecular mass of the fluid
  //
  double MMass;

  //
  // fluid-specific universal constant, which is R/MMass
  //
  double Rprime;
};
#endif

