//
// class HeatXchanger
// (c) 1995--1996 Alessandro Cella
//
// uses epsilon-NTU method (where epsilon is given, by now)
// calculates q = epsilon x qmax = eps x Cflow_min x (TinH - TinC)
// and then ToutC (and ToutH as well)
//

#ifndef _HEATXC_H
#define _HEATXC_H
#define HEATNAME "heatXC"
#define HEATVERS "v.0.8.1"
#define HEATAUTH "a.cella (cella@marvin.conecta.it)"
#define HEATDATE "25 jun 96"

#ifndef _FLUID_H
#include "fluid.h"
#endif

#ifndef _PLANTELEMENT_H
#include "plantElement.h"
#endif

#include <String.h>

class heatXC : public plantElement
{
public:
  // default constructor
  // exchanger defaults to Tin=Tout=273 K and CO2 for both fluids
  // counterflow configuration and nominal efficiency of unity
  heatXC(String name="default heat exchanger",int id=0);

  // destructor
  ~heatXC() {};
   
  // provides a way for changing the configuration
  // 0: counterflow, 1: parallel flow
  int setConfig(int conf=0) {if((conf==1)||(conf==0)) config=conf; return 1;};

  // sets hot and cold fluid, see fluid.h for details
  int setColdFluid(String fluidIDString);
  int setHotFluid(String fluidIDString);

  // sets hot and cold fluid`s massflow
  int setColdFluidMassFlow(double cmassflow) { ColdFluidMassFlow=cmassflow; return 0; };
  int setHotFluidMassFlow(double hmassflow) { HotFluidMassFlow=hmassflow; return 0; };

  // sets hot and cold fluid`s temperatures
  int setColdFluidInletT(double temp) { if(temp>0) { TinC=temp; return 0;}; return 1; };
  int setHotFluidInletT(double temp) { if(temp>0) { TinH=temp; return 0;}; return 1; };

  // sets default efficiency (epsilon= (actual/maximum) specific heat flow)
  int setEfficiency(double effc=1) {if((effc>=0) && (effc<=1)) { nominalEff=effc; return 0; }; return 1;};

  // solve for outlet T of the colder fluid, as i
  // am interested in solving _that_ way
  int getColdFluidOutletT();
  int getHotFluidOutletT();

  //
  // not yet implemented
  // 
  double power();

  //
  // info methods
  //
  String getVersion();

private:
  // 0: no panic, otherwise solution is not reliable
  int panic;

  // 0: counterflow, 1: parallel flow
  int config;

  // 1 or 2 fluids? (i.e. regenerative exchanger or not?)
  int NoOfFluids;

  // hot and cold fluids representation
  fluid HotFluid,ColdFluid;

  // temperatures of the fluids (SI units: K)
  double TinH,ToutH,TinC,ToutC;

  // dunno if required
  double mnCpH,mnCpC;

  // mass flow of the 2 fluids (SI units: kg/s)
  double ColdFluidMassFlow,HotFluidMassFlow;
  
  // CpFlow = massFlow * meanCp
  double HotCpFlow,ColdCpFlow;

  //
  double CflowMinOverCflowMax;

  // nominal efficiency: (desing maximum/theorical maximum) heat flow
  // real    efficiency: how much heat flow *actually* exchanged
  double nominalEff,realEff;

  // gets fluid`s mean Cp
  // 0: cold fluid
  // 1: hot fluid
  double meanCp(int fluidNo,double T1, double T2);
};

#endif







