#include <qstrlist.h>
#include <qfiledlg.h>

#include "QfruLibraryDlg.h"

QfruLibraryDlg::QfruLibraryDlg(QWidget *parent, const char *name) : QDialog(parent, name, TRUE) {
	initMetaObject();
	initLayout();

	QGridLayout *grid = new QGridLayout(frame, 1, 1);
	listbox = new QListBox(frame, "ListBox");
	grid->addWidget(listbox, 1, 1);
	grid->activate();
};

QfruLibraryDlg::~QfruLibraryDlg() {
	;
}



void QfruLibraryDlg::list(QStrList &l) {
	listbox->clear();
	listbox->insertStrList(&l);
}


QStrList QfruLibraryDlg::list() {
	QStrList foo;
	for (uint i=0 ; i<listbox->count() ; i++) {
		foo.append(listbox->text(i));
	}
	return foo;
}


void QfruLibraryDlg::btnAddclicked() {
	QFileDialog fd(0, "Library Path:", TRUE);

	if (fd.exec()) {
		listbox->insertItem(fd.dirPath());
	}
}


void QfruLibraryDlg::btnRemoveclicked() {
	if (listbox->currentItem() != -1)
		listbox->removeItem(listbox->currentItem());
}



void QfruLibraryDlg::initLayout(void) {
	QWidget *tmp0;
	tmp0 = new QWidget ( this);

	QPushButton *tmp1;
	tmp1 = new QPushButton ( tmp0 , "");

	QPushButton *tmp2;
	tmp2 = new QPushButton ( tmp0 , "");

	frame = new QFrame ( tmp0, "QFrame1");

	QBoxLayout *tmp4;
	tmp4 = new QBoxLayout ( frame, QBoxLayout::LeftToRight, 0);

	QPushButton *tmp5;
	tmp5 = new QPushButton ( tmp0 , "");

	QPushButton *tmp6;
	tmp6 = new QPushButton ( tmp0 , "");

	QBoxLayout *tmp7;
	tmp7 = new QBoxLayout (QBoxLayout::TopToBottom, 10);

	QBoxLayout *tmp8;
	tmp8 = new QBoxLayout (QBoxLayout::LeftToRight, 0);

	QBoxLayout *tmp9;
	tmp9 = new QBoxLayout ( tmp0, QBoxLayout::TopToBottom, 10);

	QBoxLayout *tmp10;
	tmp10 = new QBoxLayout (QBoxLayout::LeftToRight, 0);

	QBoxLayout *tmp11;
	tmp11 = new QBoxLayout ( tmp0, QBoxLayout::LeftToRight, 0);

	QBoxLayout *tmp12;
	tmp12 = new QBoxLayout ( tmp0, QBoxLayout::LeftToRight, 0);

	QBoxLayout *tmp13;
	tmp13 = new QBoxLayout ( tmp0, QBoxLayout::LeftToRight, 0);

	tmp0->setCaption( "" );
	tmp0->setGeometry( 0, 0, 304, 327 );
	tmp0->setMinimumSize( 130, 130 );
	tmp0->setMaximumSize( 32767, 32767 );
	tmp0->setMouseTracking( FALSE);
	tmp0->setSizeIncrement( 0, 0 );

	tmp1->setCaption( "" );
	tmp1->setGeometry( 96, 284, 50, 32 );
	tmp1->setMinimumSize( 50, 30 );
	tmp1->setMaximumSize( 32767, 32767 );
	tmp1->setMouseTracking( FALSE);
	tmp1->setSizeIncrement( 0, 0 );
	tmp1->setText( "&OK" );
	tmp1->setAutoResize( FALSE );
	tmp1->setAutoRepeat( FALSE );
	tmp1->setToggleButton( FALSE );
	tmp1->setAutoDefault( FALSE );

	tmp2->setCaption( "" );
	tmp2->setGeometry( 157, 287, 50, 30 );
	tmp2->setMinimumSize( 50, 30 );
	tmp2->setMaximumSize( 32767, 32767 );
	tmp2->setMouseTracking( FALSE);
	tmp2->setSizeIncrement( 0, 0 );
	tmp2->setText( "&Cancel" );
	tmp2->setAutoResize( FALSE );
	tmp2->setAutoRepeat( FALSE );
	tmp2->setToggleButton( FALSE );
	tmp2->setAutoDefault( FALSE );

	frame->setCaption( "" );
	frame->setGeometry( 8, 8, 224, 268 );
	frame->setMinimumSize( 0, 0 );
	frame->setMaximumSize( 32767, 32767 );
	frame->setMouseTracking( FALSE);
	frame->setSizeIncrement( 0, 0 );
	frame->setLineWidth( 1 );
	frame->setMidLineWidth( 0 );
	frame->setFrameStyle( QFrame::Panel | QFrame::Raised );


	tmp5->setCaption( "" );
	tmp5->setGeometry( 244, 8, 50, 32 );
	tmp5->setMinimumSize( 50, 30 );
	tmp5->setMaximumSize( 32767, 32767 );
	tmp5->setMouseTracking( FALSE);
	tmp5->setSizeIncrement( 0, 0 );
	tmp5->setText( "&Add" );
	tmp5->setAutoResize( FALSE );
	tmp5->setAutoRepeat( FALSE );
	tmp5->setToggleButton( FALSE );
	tmp5->setAutoDefault( FALSE );

	tmp6->setCaption( "" );
	tmp6->setGeometry( 244, 48, 50, 32 );
	tmp6->setMinimumSize( 50, 30 );
	tmp6->setMaximumSize( 32767, 32767 );
	tmp6->setMouseTracking( FALSE);
	tmp6->setSizeIncrement( 0, 0 );
	tmp6->setText( "&Remove" );
	tmp6->setAutoResize( FALSE );
	tmp6->setAutoRepeat( FALSE );
	tmp6->setToggleButton( FALSE );
	tmp6->setAutoDefault( FALSE );



	tmp9->addLayout( tmp8, 1);

	tmp8->addWidget( frame, 1, AlignCenter);
	tmp8->addSpacing( 10 );
	tmp8->addLayout( tmp7, 0);

	tmp7->addWidget( tmp5, 0, AlignCenter);
	tmp7->addWidget( tmp6, 0, AlignCenter);
	tmp7->addStretch( 1 );
	tmp9->addLayout( tmp10, 0);

	tmp10->addStretch( 1 );
	tmp10->addWidget( tmp1, 0, AlignCenter);
	tmp10->addSpacing( 10 );
	tmp10->addWidget( tmp2, 0, AlignCenter);
	tmp10->addStretch( 1 );
	tmp9->activate();

	connect(tmp1, SIGNAL(clicked()), this, SLOT(accept()));
	connect(tmp2, SIGNAL(clicked()), this, SLOT(reject()));
	connect(tmp5, SIGNAL(clicked()), this, SLOT(btnAddclicked()));
	connect(tmp6, SIGNAL(clicked()), this, SLOT(btnRemoveclicked()));
}
