#include <ostream.h>

#include <qlayout.h>

#include "TDataListBoxDlg.h"

TDataListBoxDlg::TDataListBoxDlg(QWidget *parent, const char *name, bool modal): QDialog(parent, name, modal) {
  initMetaObject();

  cout << "Setting up TDataListBoxDlg" << endl;
  QBoxLayout *mainLayout = new QBoxLayout(this, QBoxLayout::TopToBottom);
  QBoxLayout *btnLayout = new QBoxLayout(QBoxLayout::LeftToRight);

  fListBox = new TDataListBox(this);
  
  mainLayout->addWidget(fListBox, 1);
  mainLayout->addLayout(btnLayout, 0);

  btnOk = new QPushButton("OK", this);
  btnCancel = new QPushButton("Cancel", this);
  btnCancel->adjustSize();
  btnCancel->setFixedSize(btnCancel->size());
  btnOk->setFixedSize(btnCancel->size());
  
  btnLayout->addStretch(1);
  btnLayout->addWidget(btnOk);
  btnLayout->addSpacing(5);
  btnLayout->addWidget(btnCancel);
  btnLayout->addStretch(1);

  mainLayout->activate();


  connect(btnCancel, SIGNAL(clicked()), SLOT(reject()));
  connect(btnOk, SIGNAL(clicked()), SLOT(accept()));
  connect(fListBox, SIGNAL(selected(int)), SLOT(accept()));

  resize (200, 300);
  cout << "Set up TDataListBoxDlg" << endl;
}


QString TDataListBoxDlg::text(int id) {
	if (-1==id)
		id=fListBox->currentItem();
	return 
		fListBox->text(id);
}


void TDataListBoxDlg::insertItem(QString text, void *data, bool ordered) {
	TDataListBoxText *item = new TDataListBoxText(text, data);
	
	if (ordered)
		fListBox->inSort(item);
	else
		((QListBox*)fListBox)->insertItem(item);
}

void TDataListBoxDlg::deleteItem(int index) {
  fListBox->removeItem(index);
}

void *TDataListBoxDlg::data(int index) {
  return fListBox->data(index);
}

void *TDataListBoxDlg::data() {
  return fListBox->data(fListBox->currentItem());
}
