#ifndef _TEDITCONNECTION_H_
#define _TEDITCONNECTION_H_

#include <qdialog.h>
#include <qpushbt.h>
#include <qradiobt.h>
#include <qlined.h>
#include <qbttngrp.h>
#include <qchkbox.h>

#include "TSignalSlot.h"
#include "TButtonGroup.h"


class TEditConnectionDlg: public QDialog {
  Q_OBJECT
public:
  TEditConnectionDlg(TSignalSlot *ss=NULL, QWidget *parent=NULL, 
		     const char *name=NULL, bool modal=TRUE);
  QSize sizeHint() const;

  TConnectionType type();
  void setType(TConnectionType);

  QString name();
  void setName(QString);

  QString args();
  void setArgs(QString);

  bool isVirtual();
  void setVirtual(bool);

  TSlotPrivacy privacy();
  void setPrivacy(TSlotPrivacy);
protected:
protected slots:
  void groupClicked(int id);
  void privacyClicked(int id);
private:
  QPushButton *btnOK, *btnCancel;
  QRadioButton *typeSignal, *typeSlot;
  QLineEdit *editName;
  QLineEdit *editArgs;
  TButtonGroup *bgroup;
  TButtonGroup *bgroupPrivacy;
  QCheckBox *cbVirtual;

  TSlotPrivacy fPrivacy;
  TConnectionType fType;
};

#endif /* _TEDITCONNECTION_H_ */
