#include <qlayout.h>
#include "QfruEdit.h"
#include "TEditWindow.h"

#include "TLayoutWindow.h"


TEditWindow::TEditWindow(QWidget *parent, const char *name) : QWindow(parent, name) {
	initMetaObject();

	fInLoop = FALSE;
	fEdited = FALSE;

	edit = new QfruEdit(kapp, this, "edit Box");
	edit->setFocusPolicy(QWidget::ClickFocus);
	edit->setFont(QFont("Courier", 12, QFont::Normal));


	tabbar = new QTabBar(this, "Tab Bar");
	tabbar->setShape(QTabBar::TriangularBelow);
	tabbar->setFixedHeight(tabbar->fontMetrics().height()*2);

  
	QVBoxLayout *layout = new QVBoxLayout(this, 1, 0, "Layout");
	layout->addWidget(edit, 1);
	layout->addWidget(tabbar, 0);

	connect(tabbar, SIGNAL(selected(int)), SLOT(tabClicked(int)));
	connect(edit, SIGNAL(textChanged()), SLOT(setEdited()));

	tabCount=0;

	edit->installEventFilter(this);
	edit->setFocus();
}



TEditWindow::~TEditWindow() {
}


void TEditWindow::setEdited() {
	fEdited = TRUE;
}

void TEditWindow::editFile(TLayoutWindow *layout, const char *filename, const char *text, int line) {
	QTab *currTab = NULL;
	int row, col;

	fInLoop = TRUE;
  
	for (int i=0 ; i<tabCount ; i++) {
		if (filename == tabbar->tab(i)->label) {
			currTab = tabbar->tab(i);
			break;
		}
	}
  
	if (!currTab) {
		currTab = new QTab();
		currTab->label = filename;
		currTab->enabled = TRUE;
		tabbar->addTab(currTab);
		tabCount++;
		tabbar->update();

		TTab *currTTab = new TTab();
		currTTab->sourceLayout = layout;
		currTTab->row = 0;
		currTTab->col = 0;
		currTTab->topRow = 0;
		tabDetails.append(currTTab);

		connect(layout, SIGNAL(textChanged(const char *)), 
				SLOT(changeText(const char *)));
	}

	tabbar->setCurrentTab(currTab);

	edit->getCursorPosition(&row, &col);
	edit->setText(text);
	edit->setCursorPosition(line ? line : row, 0);

	fEdited = FALSE;
	fInLoop = FALSE;
}
  

void TEditWindow::tabClicked(int i) {
	if (!fInLoop) {
		QTab *currTab = tabbar->tab(i);
		TTab *currTTab = tabDetails.at(i);

		TLayoutWindow *lw = currTTab->sourceLayout;

		edit->setText(lw->text(currTab->label));
		edit->setTopLine(currTTab->topRow);
		edit->setCursorPosition(currTTab->row, currTTab->col);
		fEdited = FALSE;
	}
};


void TEditWindow::changeText(const char *filename) {
	int i = tabbar->currentTab();

	if (0==strcmp(filename, tabbar->tab(i)->label)) {
		TTab *currTTab = tabDetails.at(i);

		TLayoutWindow *lw = currTTab->sourceLayout;

		edit->setText(lw->text(filename));
		edit->setCursorPosition(lw->getTextRow(filename), 0);
		fEdited = FALSE;
	}
}


bool TEditWindow::eventFilter(QObject *obj, QEvent *ev) {
	if (obj == edit) {
		if (ev->type() == Event_Leave) {
			int row, col;
			int i = tabbar->currentTab();
			QTab *currTab = tabbar->tab(i);
			TTab *currTTab = tabDetails.at(i);

			if (currTTab) {
				TLayoutWindow *lw = currTTab->sourceLayout;
      
				if (fEdited) {
					lw->setText(currTab->label, edit->text());
					fEdited = FALSE;
				}

				edit->getCursorPosition(&row, &col);
				lw->setTextRow(currTab->label, row);

				currTTab->row = row;
				currTTab->col = col;
				currTTab->topRow = edit->topLine();
			}
		}
	}
	return FALSE;
}
	
void TEditWindow::renameTab(TLayoutWindow *lw, QString oldName, QString newName) {
	QTab *currTab = NULL;

	for (int i=0 ; i<tabCount ; i++) {
		currTab = tabbar->tab(i);
		if (oldName == currTab->label) {
			TTab *currTTab = tabDetails.at(i);
			if (currTTab->sourceLayout == lw) {
				currTab->label = newName;
				tabbar->update();
				break;
			}
		}
	}
}
