#ifndef __TEDITWINDOW_H__
#define __TEDITWINDOW_H__

#include <qwindow.h>
#include <qmlined.h>
#include <qtabbar.h>
#include <qlayout.h>

#include "QfruEdit.h"

class TLayoutWindow;

class TTab {
public:
  TLayoutWindow *sourceLayout;
  int row, col;
  int topRow;
};


class TEditWindow: public QWindow {
  Q_OBJECT
public:
  TEditWindow(QWidget *parent=0, const char *name=0);
  ~TEditWindow();
  void editFile(TLayoutWindow*, const char *, const char *, int line=0);
public slots:
  void renameTab(TLayoutWindow*, QString, QString);

signals:
  void fileEdited(const char *);
protected:
  bool eventFilter(QObject *, QEvent*);
protected slots:
  void setEdited();
  void tabClicked(int);
  void changeText(const char *);

private:
  QTabBar *tabbar;
  QfruEdit *edit;
  int tabCount, fCurrTab;
  QList<TTab> tabDetails;
  bool fInLoop, fEdited;
};




#endif /*__TEDITWINDOW_H__ */
