#ifndef _THANDLE_H_
#define _THANDLE_H_

#include <qevent.h>
#include <qwidget.h>

class THandle: public QWidget {
  Q_OBJECT
public:
  enum THandlePosition {NW, N, NE, E, SE, S, SW, W};
  
  THandle(THandlePosition hpos, QWidget *parent=0, const char *name=0);
  THandlePosition handlePosition(void) { return hPosition; };
public slots:
  void setPositionRect(QObject*,const QRect &);
signals:
  void sigPositionRectChanged(const QRect &);
protected:
  void mousePressEvent(QMouseEvent *ev);
  void mouseMoveEvent(QMouseEvent *ev);
private:
  THandlePosition hPosition;
  int OffsetX, OffsetY;
  QRect rectangle;
};


#endif /* _THANDLE_H_ */
