#ifndef _THANDLER_H_
#define _THANDLER_H_

#include <qwidget.h>
#include "THandle.h"

class THandleGroup: public QWidget {
  Q_OBJECT
public:
  THandleGroup(QWidget *parent=0, const char *name=0);
  ~THandleGroup();
  void showHandles();
  void hideHandles();
  void raiseHandles();

  void watched(QWidget *);
  QWidget *watched(void);

  void color(QColor);
  QColor color(void);

  void gridSize(uint g) { fGridSize = g; };
  uint gridSize(void) { return fGridSize; };
  
public slots:
  void setHandleGroupRect(const QRect &);
  void updateWatched(QObject*, const QRect&);
signals:
  void sigHandleGroupRectChanged(QObject*, const QRect &);
protected:
private:
  bool fInSetHandleGroupRectLoop;
  QWidget *FWatched;
  uint fGridSize;
  THandle *HandleNW, *HandleN, *HandleNE, *HandleW, *HandleE, *HandleSW, *HandleS, *HandleSE;
};


#endif /* _THANDLER_H_ */
