/*
** $Source: /usr/local/share/cvs/frugal/mawc/mawc/TObjectTree.cpp,v $
** $Author: frugal $
** $Date: 1998/01/13 18:48:43 $
** $Revision: 1.1.1.1 $
** $State: Exp $
** $Log: TObjectTree.cpp,v $
** Revision 1.1.1.1  1998/01/13 18:48:43  frugal
**
** Revision 1.3  1998/01/12 08:08:18  frugal
** Removed a few debugging messages
**
** Revision 1.2  1998/01/09 22:56:27  frugal
** variable names are now alloed to have numbers in them ;O)
**
** Revision 1.1.1.1  1998/01/09 12:01:32  frugal
** MAWC initial import
**
** Revision 1.2  1997/07/09 19:05:32  frugal
** - Added findByValidName()
**
** Revision 1.1  1997/06/01 13:45:52  frugal
** Initial revision
**
**
** All source code written by Frugal (frugal@wardrobe.demon.co.uk)
*/

#include <assert.h>
#include <iostream.h>

#include <qregexp.h>

#include "TObjectTree.h"

TObjectTree::TObjectTree(QObject *obj, TObjectTree *parent)
: QTree(parent) {
  
  fObject = obj;
  variableName("");
  tempName("");
}

TObjectTree::~TObjectTree() {
  cout << "Deleting TObjectTree: " << variableName() << endl;
  cout << "                      this: " << (void*) this << endl;
  cout << "                      Object: " << (void*) fObject << endl;
}


bool TObjectTree::variableName(QString aName) {
  if (aName=="") {
    fVariableName = "";
    return TRUE;
  }

  if (aName==fVariableName)
    return TRUE;

  TObjectTree *ptr = (TObjectTree*)root();
  while(ptr) {
    if (ptr->variableName()==aName)
      return FALSE;
    ptr = (TObjectTree*)ptr->next();
  }
  fVariableName=aName.replace(QRegExp("[^a-zA-Z0-9_]"), "_");

  return TRUE;
}

bool TObjectTree::tempName(QString aName) {
  if (aName=="") {
    fTmpName = "";
    return TRUE;
  }

  if (aName==fTmpName)
    return TRUE;

  TObjectTree *ptr = (TObjectTree*)root();
  while(ptr) {
    if (ptr->tempName()==aName)
      return FALSE;
    if (ptr->variableName()==aName)
      return FALSE;
    ptr = (TObjectTree*)ptr->next();
  }
  fTmpName=aName;
  fTmpName.detach();
  return TRUE;
}


QString TObjectTree::validName() {
  if (fVariableName=="")
    return fTmpName;
  else
    return fVariableName;
}

  

TObjectTree *TObjectTree::find(const QObject *obj) {
  TObjectTree *ptr = this;
  while(ptr) {
    if (ptr->object()==obj)
      break;
    ptr = (TObjectTree*)ptr->next();
  }
  return ptr;
}

TObjectTree *TObjectTree::findByObjName(const QString str) {
  TObjectTree *ptr = this;
  while(ptr) {
    if (0==strcmp(ptr->object()->name(), str))
      break;
    ptr = (TObjectTree*)ptr->next();
  }
  return ptr;
}


TObjectTree *TObjectTree::findByValidName(const QString str) {
  TObjectTree *ptr = this;
  while(ptr) {
    if (ptr->validName() == str)
      break;
    ptr = (TObjectTree*)ptr->next();
  }
  return ptr;
}



void TObjectTree::addData(QString n, void *d) {
  TObjectDataItem *item = new TObjectDataItem;
  item->name = n;
  item->data = d;
  fData.append(item);
}


void *TObjectTree::findData(QString n) {
  TObjectDataListIt it(fData);
  for ( ; it.current() ; ++it) {
    if (it.current()->name == n)
      return it.current()->data;
  }
  return NULL;
}


bool TObjectTree::deleteData(QString str, bool del) {
  for ( uint i=0 ; i<fData.count() ; ++i) {
    if (fData.at(i)->name == str) {
      void *foo = fData.at(i);
      fData.remove(i);
      if (del)
	delete foo;
      return TRUE;
    }
  }
  return FALSE;
}




void TObjectTree::addAppliedData(QString n, void *d) {
  TObjectDataItem *item = new TObjectDataItem;
  item->name = n;
  item->data = d;
  fAppliedData.append(item);
}



void *TObjectTree::findAppliedData(QString n) {
  TObjectDataListIt it(fAppliedData);
  for ( ; it.current() ; ++it) {
    if (it.current()->name == n)
      return it.current()->data;
  }
  return NULL;
}



bool TObjectTree::deleteAppliedData(QString str, bool del) {
  for ( uint i=0 ; i<fAppliedData.count() ; ++i) {
    if (fAppliedData.at(i)->name == str) {
      void *foo = fAppliedData.take(i);
      fAppliedData.remove(i);
      if (del) 
	delete foo;
      return TRUE;
    }
  }
  return FALSE;
}
