#ifndef _TOBJECTTREE_H_
#define _TOBJECTTREE_H_

#include <qobject.h>

#include "qtree.h"
#include "TSignalSlot.h"


class TStoreType;

typedef struct TObjectDataItem {
  QString name;
  void *data;
} TObjectDataItem;

typedef QListIterator<TObjectDataItem> TObjectDataListIt;

class TObjectDataList: public QList<TObjectDataItem> {
public:
private:
  int compareItems(GCI s1, GCI s2) {
    return (strcmp( ((TObjectDataItem*)s1)->name,
		    ((TObjectDataItem*)s2)->name) );
  };
};


class TObjectTree: public QTree {
  Q_OBJECT
public:
  TObjectTree(QObject *obj, TObjectTree *p=NULL);
  ~TObjectTree();

  QObject *object(void) { return fObject; };
  void object(QObject *obj) { fObject = obj; };

  bool variableName(QString);
  QString variableName(void) { return fVariableName; };

  bool tempName(QString);
  QString tempName(void) { return fTmpName; };

  QString validName(void);

  TObjectDataList *data() {return &fData;};
  void addData(QString n, void *d);
  void *findData(QString n);
  bool deleteData(QString str, bool del = TRUE);

  TObjectDataList *appliedData() {return &fAppliedData;};
  void addAppliedData(QString n, void *d);
  void *findAppliedData(QString n);
  bool deleteAppliedData(QString str, bool del = TRUE);

  TObjectTree *find(const QObject *);
  TObjectTree *findByObjName(const QString str);
  TObjectTree *findByValidName(const QString str);


  TObjectTree *parent(void) { return (TObjectTree*)QTree::parent();};
  TObjectTree *next(bool r=TRUE) { return (TObjectTree*)QTree::next(r);};
  TObjectTree *prev(bool r=TRUE) { return (TObjectTree*)QTree::prev(r);};
  TObjectTree *nextSibling() { return (TObjectTree*)QTree::nextSibling();};
  TObjectTree *prevSibling() { return (TObjectTree*)QTree::prevSibling();};
  TObjectTree *root(void) { return (TObjectTree*)QTree::root();};
  TObjectTree *firstChild(void) { return (TObjectTree*)QTree::firstChild();};
  TObjectTree *lastChild(void) { return (TObjectTree*)QTree::lastChild();};
  TObjectTree *find(TObjectTree *o, bool r=TRUE) { 
    return (TObjectTree*)QTree::find(o, r);
  };
  TObjectTree *child(uint i) { return (TObjectTree*)QTree::child(i);};

  TLinkedConnectionsList *connections() { return &fLinkedConnections;};
protected:
private:
  QString fVariableName;
  QString fTmpName;

  QObject *fObject;
  TObjectDataList fData, fAppliedData;
  TLinkedConnectionsList fLinkedConnections; /* the connections from
						every signal to every slot 
						it is connected to */
};


#endif /* _TOBJECTTREE_H_ */
