#ifndef _TPROPERTYWIDGET_H_
#define _TPROPERTYWIDGET_H_

#include "TStore.h"
#include "TStoreType.h"
#include "kpanner.h"

#include <qcombo.h>
#include <qlayout.h>
#include <qscrbar.h>

class TStore;

typedef struct TProperty {
  QWidget *widget;
  TPropertyType propType;
  QString name;
  TStorePropertySetFn setFunc;
  TStorePropertyGetFn getFunc;
  TStorePropertyActivateFn activateFunc;
  bool geometry;
};

class TPropertyWidget: public QWidget {
  Q_OBJECT
public:
  TPropertyWidget(QWidget *parent=0, const char *name=0);
  ~TPropertyWidget();

  void addTextChild(TStoreProperty);

  TStoreType *activeObject(void) { return (fActiveObject); };
  void store(TStore *s) { fStore = s; };

  void addNewObject(TStoreType *);
  void updateObject(TStoreType *, QString);
public slots:
  void activeObject(TStoreType *w);
  void setActive();
  void widgetGeometryChanged(QObject *, const QRect &);
signals:
  void sigWidgetGeometryChanged(QObject *, const QRect &);
  void sigObjectChanged(QObject*);
protected:
  void updateProperties();
  void resizeEvent(QResizeEvent*);
  bool updateObjectList(TStoreType *);
  void calculateScrollBars();
protected slots:
  void objectActivated();
  void objectActivated(int);
  void objectActivated(const QObject *);
  void comboActivated(const char *);
  void scrollChanged(int value);
private:
  QList<QWidget> fWidgetList;
  QList<TProperty> fPropertyList;
  TStoreType *fActiveObject, *fRootObject;
  bool fUpdatingProperties;
  TStore *fStore;
  QBoxLayout *fLayoutLeft, *fLayoutRight;
  KPanner *panner;
  QComboBox *comboCurrentObject;
  QScrollBar *scrollBar;
};

#endif /* _TPROPERTYWIDGET_H_ */
