#include "TSignalSlot.h"



TSignalSlot::TSignalSlot(const char *n, const char *a, TConnectionType t) {
  name = n;
  args = a;
  args = args.simplifyWhiteSpace();
  type = t;
  created = FALSE;
}

TSignalSlot::~TSignalSlot() {
	;
}


TSlot::TSlot(const char *n, const char *a, TSlotPrivacy p, bool v): TSignalSlot(n,a,ctSlot) {
  privacy = p;
  isVirtual = v;
}

TSlot::~TSlot() {
	;
}


TSignal::TSignal(const char *n, const char *a): TSignalSlot(n,a,ctSignal) {
  ;
}

TSignal::~TSignal() {
	;
}


ostream &operator<<(ostream &os, TSignalSlot &e) {
  os << "\t{ name=\"" << e.name <<
    "\", args=\"" << e.args << "\", ";
  if (ctSignal==e.type)
    os << "Signal";
  else
    os << "Slot";
  return (os);
}


/*****************************************
 **
 **  Class: TSlotList
 **
 *****************************************/

ostream &operator<<(ostream &os, TSlotList &l) {
  TSlotListIt it(l);
  for (it.toFirst() ; it.current() ; ++it)
    os << *(it.current()) << endl;
  return (os);
}

TSlotList::TSlotList(): QList<TSlot>() {
	;
}

TSlotList::~TSlotList() {
	;
}

int TSlotList::compareItems(GCI s1, GCI s2) {
  TSlot *slot1 = (TSlot*)s1;
  TSlot *slot2 = (TSlot*)s2;
  int i= strcmp(slot1->name, slot2->name);

  if (0==i)
    return (strcmp(slot1->args, slot2->args));
  else 
    return i;
};



TSlot *TSlotList::find(QString n, QString a) {
  TSlotListIt it(*this);
  for ( ; it.current() ; ++it)
    if ((it.current()->name==n) && (it.current()->args==a))
      return it.current();
  return NULL;
}

TSlot *TSlotList::find(QString n) {
  TSlotListIt it(*this);
  for ( ; it.current() ; ++it) {
    QString str;
    str.sprintf("%s ( %s )", (const char*)it.current()->name, 
		(const char*)it.current()->args);
    if (str == n)
      return it.current();
  }
  return NULL;
}




/*****************************************
 **
 **  Class: TSignalList
 **
 *****************************************/

ostream &operator<<(ostream &os, TSignalList &l) {
  TSignalListIt it(l);
  for (it.toFirst() ; it.current() ; ++it)
    os << *(it.current()) << endl;
  return (os);
}

TSignalList::TSignalList(): QList<TSignal>() {
	;
}

TSignalList::~TSignalList() {
	;
}

int TSignalList::compareItems(GCI s1, GCI s2) {
  TSignal *slot1 = (TSignal*)s1;
  TSignal *slot2 = (TSignal*)s2;
  int i= strcmp(slot1->name, slot2->name);

  if (0==i)
    return (strcmp(slot1->args, slot2->args));
  else 
    return i;
};



TSignal *TSignalList::find(QString n, QString a) {
  TSignalListIt it(*this);
  for ( ; it.current() ; ++it)
    if ((it.current()->name==n) && (it.current()->args==a))
      return it.current();
  return NULL;
}

TSignal *TSignalList::find(QString n) {
  TSignalListIt it(*this);
  for ( ; it.current() ; ++it) {
    QString str;
    str.sprintf("%s ( %s )", (const char*)it.current()->name, 
		(const char*)it.current()->args);
    if (str == n)
      return it.current();
  }
  return NULL;
}






/**
  * Pass in a string which is "SignalName ( SignalArgs )" and
  * this will return a ptr to the connection list
  */
TLinkedConnections *TLinkedConnectionsList::find(QString s) {
  TLinkedConnectionsListIt it(*this);
  for ( ; it.current() ; ++it) {
    QString str;
    str.sprintf("%s ( %s )", (const char*)it.current()->source->name, 
		(const char*)it.current()->source->args);
    cout << "Comparing: '" << s << "' with '" << str << "'" << endl;
    if (str == s) {
      break;
    }
  }
  return it.current();
}

TLinkedConnections *TLinkedConnectionsList::find(QString name, QString args) {
  TLinkedConnectionsListIt it(*this);
  for ( ; it.current() ; ++it) {
    if ((name == it.current()->source->name) &&
	(args == it.current()->source->args))
      break;
  }
  return it.current();
}


